/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.hbase.io.HeapSize;

public class BlockCacheKey
implements HeapSize {
    private String hfileName;
    private long offset;

    public BlockCacheKey(String file, long offset) {
        this.hfileName = file;
        this.offset = offset;
    }

    public int hashCode() {
        return this.hfileName.hashCode() * 127 + (int)(this.offset ^ this.offset >>> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof BlockCacheKey) {
            BlockCacheKey k = (BlockCacheKey)o;
            return this.offset == k.offset && (this.hfileName == null ? k.hfileName == null : this.hfileName.equals(k.hfileName));
        }
        return false;
    }

    public String toString() {
        return this.hfileName + "_" + this.offset;
    }

    @Override
    public long heapSize() {
        return 2 * this.hfileName.length() + 8;
    }

    public String getHfileName() {
        return this.hfileName;
    }
}

