/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.util.Bytes;

public final class BlockType
extends Enum<BlockType> {
    public static final /* enum */ BlockType DATA = new BlockType("DATABLK*", BlockCategory.DATA);
    public static final /* enum */ BlockType LEAF_INDEX = new BlockType("IDXLEAF2", BlockCategory.INDEX);
    public static final /* enum */ BlockType BLOOM_CHUNK = new BlockType("BLMFBLK2", BlockCategory.BLOOM);
    public static final /* enum */ BlockType META = new BlockType("METABLKc", BlockCategory.META);
    public static final /* enum */ BlockType INTERMEDIATE_INDEX = new BlockType("IDXINTE2", BlockCategory.INDEX);
    public static final /* enum */ BlockType ROOT_INDEX = new BlockType("IDXROOT2", BlockCategory.INDEX);
    public static final /* enum */ BlockType FILE_INFO = new BlockType("FILEINF2", BlockCategory.META);
    public static final /* enum */ BlockType BLOOM_META = new BlockType("BLMFMET2", BlockCategory.BLOOM);
    public static final /* enum */ BlockType TRAILER = new BlockType("TRABLK\"$", BlockCategory.META);
    public static final /* enum */ BlockType INDEX_V1 = new BlockType("IDXBLK)+", BlockCategory.INDEX);
    public static final int MAGIC_LENGTH = 8;
    private final byte[] magic;
    private final BlockCategory metricCat;
    private static final /* synthetic */ BlockType[] $VALUES;

    public static BlockType[] values() {
        return (BlockType[])$VALUES.clone();
    }

    public static BlockType valueOf(String name) {
        return Enum.valueOf(BlockType.class, name);
    }

    private BlockType(String magicStr, BlockCategory metricCat) {
        this.magic = Bytes.toBytes(magicStr);
        this.metricCat = metricCat;
        assert (this.magic.length == 8);
    }

    public void writeToStream(OutputStream out) throws IOException {
        out.write(this.magic);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.magic);
    }

    public void write(ByteBuffer buf) {
        buf.put(this.magic);
    }

    public String getMetricName() {
        return this.metricCat.toString();
    }

    public BlockCategory getCategory() {
        return this.metricCat;
    }

    public static BlockType parse(byte[] buf, int offset, int length) throws IOException {
        if (length != 8) {
            throw new IOException("Magic record of invalid length: " + Bytes.toStringBinary(buf, offset, length));
        }
        for (BlockType blockType : BlockType.values()) {
            if (Bytes.compareTo(blockType.magic, 0, 8, buf, offset, 8) != 0) continue;
            return blockType;
        }
        throw new IOException("Invalid HFile block magic: " + Bytes.toStringBinary(buf, offset, 8));
    }

    public static BlockType read(DataInputStream in) throws IOException {
        byte[] buf = new byte[8];
        in.readFully(buf);
        return BlockType.parse(buf, 0, buf.length);
    }

    public static BlockType read(ByteBuffer buf) throws IOException {
        BlockType blockType = BlockType.parse(buf.array(), buf.arrayOffset() + buf.position(), Math.min(buf.limit() - buf.position(), 8));
        buf.position(buf.position() + 8);
        return blockType;
    }

    public int put(byte[] bytes, int offset) {
        System.arraycopy(this.magic, 0, bytes, offset, 8);
        return offset + 8;
    }

    public void readAndCheck(DataInputStream in) throws IOException {
        byte[] buf = new byte[8];
        in.readFully(buf);
        if (Bytes.compareTo(buf, this.magic) != 0) {
            throw new IOException("Invalid magic: expected " + Bytes.toStringBinary(this.magic) + ", got " + Bytes.toStringBinary(buf));
        }
    }

    public void readAndCheck(ByteBuffer in) throws IOException {
        byte[] buf = new byte[8];
        in.get(buf);
        if (Bytes.compareTo(buf, this.magic) != 0) {
            throw new IOException("Invalid magic: expected " + Bytes.toStringBinary(this.magic) + ", got " + Bytes.toStringBinary(buf));
        }
    }

    static {
        $VALUES = new BlockType[]{DATA, LEAF_INDEX, BLOOM_CHUNK, META, INTERMEDIATE_INDEX, ROOT_INDEX, FILE_INFO, BLOOM_META, TRAILER, INDEX_V1};
    }

    public static enum BlockCategory {
        DATA,
        META,
        INDEX,
        BLOOM;

    }
}

