/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.concurrent.atomic.AtomicLong;

public class CacheStats {
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong hitCachingCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong missCachingCount = new AtomicLong(0L);
    private final AtomicLong evictionCount = new AtomicLong(0L);
    private final AtomicLong evictedBlockCount = new AtomicLong(0L);

    public void miss(boolean caching) {
        this.missCount.incrementAndGet();
        if (caching) {
            this.missCachingCount.incrementAndGet();
        }
    }

    public void hit(boolean caching) {
        this.hitCount.incrementAndGet();
        if (caching) {
            this.hitCachingCount.incrementAndGet();
        }
    }

    public void evict() {
        this.evictionCount.incrementAndGet();
    }

    public void evicted() {
        this.evictedBlockCount.incrementAndGet();
    }

    public long getRequestCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public long getRequestCachingCount() {
        return this.getHitCachingCount() + this.getMissCachingCount();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long getMissCachingCount() {
        return this.missCachingCount.get();
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getHitCachingCount() {
        return this.hitCachingCount.get();
    }

    public long getEvictionCount() {
        return this.evictionCount.get();
    }

    public long getEvictedCount() {
        return this.evictedBlockCount.get();
    }

    public double getHitRatio() {
        return (float)this.getHitCount() / (float)this.getRequestCount();
    }

    public double getHitCachingRatio() {
        return (float)this.getHitCachingCount() / (float)this.getRequestCachingCount();
    }

    public double getMissRatio() {
        return (float)this.getMissCount() / (float)this.getRequestCount();
    }

    public double getMissCachingRatio() {
        return (float)this.getMissCachingCount() / (float)this.getRequestCachingCount();
    }

    public double evictedPerEviction() {
        return (float)this.getEvictedCount() / (float)this.getEvictionCount();
    }
}

