/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV1;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV1;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;

public class HFile {
    static final Log LOG = LogFactory.getLog(HFile.class);
    public static final int MAXIMUM_KEY_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final Compression.Algorithm DEFAULT_COMPRESSION_ALGORITHM = Compression.Algorithm.NONE;
    public static final int MIN_FORMAT_VERSION = 1;
    public static final int MAX_FORMAT_VERSION = 2;
    public static final String DEFAULT_COMPRESSION = DEFAULT_COMPRESSION_ALGORITHM.getName();
    private static final AtomicLong readOps = new AtomicLong();
    private static final AtomicLong readTimeNano = new AtomicLong();
    private static final AtomicLong writeOps = new AtomicLong();
    private static final AtomicLong writeTimeNano = new AtomicLong();
    private static final int LATENCY_BUFFER_SIZE = 5000;
    private static final BlockingQueue<Long> fsReadLatenciesNanos = new ArrayBlockingQueue<Long>(5000);
    private static final BlockingQueue<Long> fsWriteLatenciesNanos = new ArrayBlockingQueue<Long>(5000);
    public static final String FORMAT_VERSION_KEY = "hfile.format.version";

    public static final void offerReadLatency(long latencyNanos) {
        fsReadLatenciesNanos.offer(latencyNanos);
        readTimeNano.addAndGet(latencyNanos);
        readOps.incrementAndGet();
    }

    public static final void offerWriteLatency(long latencyNanos) {
        fsWriteLatenciesNanos.offer(latencyNanos);
        writeTimeNano.addAndGet(latencyNanos);
        writeOps.incrementAndGet();
    }

    public static final Collection<Long> getReadLatenciesNanos() {
        ArrayList latencies = Lists.newArrayListWithCapacity((int)fsReadLatenciesNanos.size());
        fsReadLatenciesNanos.drainTo(latencies);
        return latencies;
    }

    public static final Collection<Long> getWriteLatenciesNanos() {
        ArrayList latencies = Lists.newArrayListWithCapacity((int)fsWriteLatenciesNanos.size());
        fsWriteLatenciesNanos.drainTo(latencies);
        return latencies;
    }

    public static final long getReadOps() {
        return readOps.getAndSet(0L);
    }

    public static final long getReadTimeMs() {
        return readTimeNano.getAndSet(0L) / 1000000L;
    }

    public static final long getWriteOps() {
        return writeOps.getAndSet(0L);
    }

    public static final long getWriteTimeMs() {
        return writeTimeNano.getAndSet(0L) / 1000000L;
    }

    public static int getFormatVersion(Configuration conf) {
        int version = conf.getInt(FORMAT_VERSION_KEY, 2);
        HFile.checkFormatVersion(version);
        return version;
    }

    public static final WriterFactory getWriterFactory(Configuration conf) {
        return HFile.getWriterFactory(conf, new CacheConfig(conf));
    }

    public static final WriterFactory getWriterFactory(Configuration conf, CacheConfig cacheConf) {
        int version = HFile.getFormatVersion(conf);
        switch (version) {
            case 1: {
                return new HFileWriterV1.WriterFactoryV1(conf, cacheConf);
            }
            case 2: {
                return new HFileWriterV2.WriterFactoryV2(conf, cacheConf);
            }
        }
        throw new IllegalArgumentException("Cannot create writer for HFile format version " + version);
    }

    private static Reader pickReaderVersion(Path path, FSDataInputStream fsdis, long size, boolean closeIStream, CacheConfig cacheConf) throws IOException {
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream(fsdis, size);
        switch (trailer.getVersion()) {
            case 1: {
                return new HFileReaderV1(path, trailer, fsdis, size, closeIStream, cacheConf);
            }
            case 2: {
                return new HFileReaderV2(path, trailer, fsdis, size, closeIStream, cacheConf);
            }
        }
        throw new IOException("Cannot instantiate reader for HFile version " + trailer.getVersion());
    }

    public static Reader createReader(FileSystem fs, Path path, CacheConfig cacheConf) throws IOException {
        return HFile.pickReaderVersion(path, fs.open(path), fs.getFileStatus(path).getLen(), true, cacheConf);
    }

    public static Reader createReader(Path path, FSDataInputStream fsdis, long size, CacheConfig cacheConf) throws IOException {
        return HFile.pickReaderVersion(path, fsdis, size, false, cacheConf);
    }

    public static boolean isReservedFileInfoKey(byte[] key) {
        return Bytes.startsWith(key, FileInfo.RESERVED_PREFIX_BYTES);
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return Compression.getSupportedAlgorithms();
    }

    static int longToInt(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    static List<Path> getStoreFiles(FileSystem fs, Path regionDir) throws IOException {
        FileStatus[] familyDirs;
        ArrayList<Path> res = new ArrayList<Path>();
        FSUtils.DirFilter dirFilter = new FSUtils.DirFilter(fs);
        for (FileStatus dir : familyDirs = fs.listStatus(regionDir, (PathFilter)dirFilter)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(dir.getPath())) {
                if (file.isDir()) continue;
                res.add(file.getPath());
            }
        }
        return res;
    }

    public static void main(String[] args) throws IOException {
        HFilePrettyPrinter prettyPrinter = new HFilePrettyPrinter();
        System.exit(prettyPrinter.run(args));
    }

    public static BlockCacheKey getBlockCacheKey(String hfileName, long offset) {
        return new BlockCacheKey(hfileName, offset);
    }

    public static void checkFormatVersion(int version) throws IllegalArgumentException {
        if (version < 1 || version > 2) {
            throw new IllegalArgumentException("Invalid HFile version: " + version + " (expected to be " + "between " + 1 + " and " + 2 + ")");
        }
    }

    static class FileInfo
    extends HbaseMapWritable<byte[], byte[]> {
        static final String RESERVED_PREFIX = "hfile.";
        static final byte[] RESERVED_PREFIX_BYTES = Bytes.toBytes("hfile.");
        static final byte[] LASTKEY = Bytes.toBytes("hfile.LASTKEY");
        static final byte[] AVG_KEY_LEN = Bytes.toBytes("hfile.AVG_KEY_LEN");
        static final byte[] AVG_VALUE_LEN = Bytes.toBytes("hfile.AVG_VALUE_LEN");
        static final byte[] COMPARATOR = Bytes.toBytes("hfile.COMPARATOR");

        FileInfo() {
        }

        public FileInfo append(byte[] k, byte[] v, boolean checkPrefix) throws IOException {
            if (k == null || v == null) {
                throw new NullPointerException("Key nor value may be null");
            }
            if (checkPrefix && HFile.isReservedFileInfoKey(k)) {
                throw new IOException("Keys with a hfile. are reserved");
            }
            this.put(k, v);
            return this;
        }
    }

    public static interface Reader
    extends Closeable,
    CachingBlockReader {
        public String getName();

        public String getColumnFamilyName();

        public RawComparator<byte[]> getComparator();

        public HFileScanner getScanner(boolean var1, boolean var2, boolean var3);

        public ByteBuffer getMetaBlock(String var1, boolean var2) throws IOException;

        public Map<byte[], byte[]> loadFileInfo() throws IOException;

        public byte[] getLastKey();

        public byte[] midkey() throws IOException;

        public long length();

        public long getEntries();

        public byte[] getFirstKey();

        public long indexSize();

        public byte[] getFirstRowKey();

        public byte[] getLastRowKey();

        public FixedFileTrailer getTrailer();

        public HFileBlockIndex.BlockIndexReader getDataBlockIndexReader();

        public HFileScanner getScanner(boolean var1, boolean var2);

        public Compression.Algorithm getCompressionAlgorithm();

        public DataInput getBloomFilterMetadata() throws IOException;

        public Path getPath();

        public void close(boolean var1) throws IOException;
    }

    public static interface CachingBlockReader {
        public HFileBlock readBlock(long var1, long var3, boolean var5, boolean var6, boolean var7) throws IOException;
    }

    public static abstract class WriterFactory {
        protected Configuration conf;
        protected CacheConfig cacheConf;

        WriterFactory(Configuration conf, CacheConfig cacheConf) {
            this.conf = conf;
            this.cacheConf = cacheConf;
        }

        public abstract Writer createWriter(FileSystem var1, Path var2) throws IOException;

        public abstract Writer createWriter(FileSystem var1, Path var2, int var3, Compression.Algorithm var4, KeyValue.KeyComparator var5) throws IOException;

        public abstract Writer createWriter(FileSystem var1, Path var2, int var3, String var4, KeyValue.KeyComparator var5) throws IOException;

        public abstract Writer createWriter(FSDataOutputStream var1, int var2, String var3, KeyValue.KeyComparator var4) throws IOException;

        public abstract Writer createWriter(FSDataOutputStream var1, int var2, Compression.Algorithm var3, KeyValue.KeyComparator var4) throws IOException;
    }

    public static interface Writer
    extends Closeable {
        public void appendFileInfo(byte[] var1, byte[] var2) throws IOException;

        public void append(KeyValue var1) throws IOException;

        public void append(byte[] var1, byte[] var2) throws IOException;

        public Path getPath();

        public void appendMetaBlock(String var1, Writable var2);

        public void addInlineBlockWriter(InlineBlockWriter var1);

        public void addBloomFilter(BloomFilterWriter var1);
    }
}

