/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileReader;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.RawComparator;

public class HFileReaderV1
extends AbstractHFileReader {
    private static final Log LOG = LogFactory.getLog(HFileReaderV1.class);
    private volatile boolean fileInfoLoaded = false;

    public HFileReaderV1(Path path, FixedFileTrailer trailer, FSDataInputStream fsdis, long size, boolean closeIStream, CacheConfig cacheConf) {
        super(path, trailer, fsdis, size, closeIStream, cacheConf);
        trailer.expectVersion(1);
        this.fsBlockReader = new HFileBlock.FSReaderV1(fsdis, this.compressAlgo, this.fileSize);
    }

    private byte[] readAllIndex(FSDataInputStream in, long indexOffset, int indexSize) throws IOException {
        byte[] allIndex = new byte[indexSize];
        in.seek(indexOffset);
        IOUtils.readFully((InputStream)in, (byte[])allIndex, (int)0, (int)allIndex.length);
        return allIndex;
    }

    @Override
    public HFile.FileInfo loadFileInfo() throws IOException {
        if (this.fileInfoLoaded) {
            return this.fileInfo;
        }
        this.istream.seek(this.trailer.getFileInfoOffset());
        this.fileInfo = new HFile.FileInfo();
        this.fileInfo.readFields((DataInput)this.istream);
        this.lastKey = (byte[])this.fileInfo.get(HFile.FileInfo.LASTKEY);
        this.avgKeyLen = Bytes.toInt((byte[])this.fileInfo.get(HFile.FileInfo.AVG_KEY_LEN));
        this.avgValueLen = Bytes.toInt((byte[])this.fileInfo.get(HFile.FileInfo.AVG_VALUE_LEN));
        String clazzName = Bytes.toString((byte[])this.fileInfo.get(HFile.FileInfo.COMPARATOR));
        this.comparator = this.getComparator(clazzName);
        this.dataBlockIndexReader = new HFileBlockIndex.BlockIndexReader((RawComparator<byte[]>)this.comparator, 1);
        this.metaBlockIndexReader = new HFileBlockIndex.BlockIndexReader(Bytes.BYTES_RAWCOMPARATOR, 1);
        int sizeToLoadOnOpen = (int)(this.fileSize - this.trailer.getLoadOnOpenDataOffset() - (long)this.trailer.getTrailerSize());
        byte[] dataAndMetaIndex = this.readAllIndex(this.istream, this.trailer.getLoadOnOpenDataOffset(), sizeToLoadOnOpen);
        ByteArrayInputStream bis = new ByteArrayInputStream(dataAndMetaIndex);
        DataInputStream dis = new DataInputStream(bis);
        if (this.trailer.getDataIndexCount() > 0) {
            BlockType.INDEX_V1.readAndCheck(dis);
        }
        this.dataBlockIndexReader.readRootIndex(dis, this.trailer.getDataIndexCount());
        if (this.trailer.getMetaIndexCount() > 0) {
            BlockType.INDEX_V1.readAndCheck(dis);
        }
        this.metaBlockIndexReader.readRootIndex(dis, this.trailer.getMetaIndexCount());
        this.fileInfoLoaded = true;
        return this.fileInfo;
    }

    private RawComparator<byte[]> getComparator(String clazzName) throws IOException {
        if (clazzName == null || clazzName.length() == 0) {
            return null;
        }
        try {
            return (RawComparator)Class.forName(clazzName).newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        return new ScannerV1(this, cacheBlocks, pread, isCompaction);
    }

    protected int blockContainingKey(byte[] key, int offset, int length) {
        Preconditions.checkState((!this.dataBlockIndexReader.isEmpty() ? 1 : 0) != 0, (Object)"Block index not loaded");
        return this.dataBlockIndexReader.rootBlockContainingKey(key, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getMetaBlock(String metaBlockName, boolean cacheBlock) throws IOException {
        if (this.trailer.getMetaIndexCount() == 0) {
            return null;
        }
        if (this.metaBlockIndexReader == null) {
            throw new IOException("Meta index not loaded");
        }
        byte[] nameBytes = Bytes.toBytes(metaBlockName);
        int block = this.metaBlockIndexReader.rootBlockContainingKey(nameBytes, 0, nameBytes.length);
        if (block == -1) {
            return null;
        }
        long offset = this.metaBlockIndexReader.getRootBlockOffset(block);
        long nextOffset = block == this.metaBlockIndexReader.getRootBlockCount() - 1 ? this.trailer.getFileInfoOffset() : this.metaBlockIndexReader.getRootBlockOffset(block + 1);
        long startTimeNs = System.nanoTime();
        BlockCacheKey cacheKey = HFile.getBlockCacheKey(this.name, offset);
        BlockType.BlockCategory effectiveCategory = BlockType.BlockCategory.META;
        if (metaBlockName.equals("BLOOM_FILTER_META") || metaBlockName.equals("BLOOM_FILTER_DATA")) {
            effectiveCategory = BlockType.BlockCategory.BLOOM;
        }
        byte[] byArray = this.metaBlockIndexReader.getRootBlockKey(block);
        synchronized (byArray) {
            HFileBlock cachedBlock;
            this.metaLoads.incrementAndGet();
            if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = (HFileBlock)this.cacheConf.getBlockCache().getBlock(cacheKey, this.cacheConf.shouldCacheBlockOnRead(effectiveCategory))) != null) {
                this.cacheHits.incrementAndGet();
                return cachedBlock.getBufferWithoutHeader();
            }
            HFileBlock hfileBlock = this.fsBlockReader.readBlockData(offset, nextOffset - offset, this.metaBlockIndexReader.getRootBlockDataSize(block), true);
            hfileBlock.expectType(BlockType.META);
            long latency = System.nanoTime() - startTimeNs;
            HFile.offerReadLatency(latency);
            if (cacheBlock && this.cacheConf.shouldCacheBlockOnRead(effectiveCategory)) {
                this.cacheConf.getBlockCache().cacheBlock(cacheKey, hfileBlock, this.cacheConf.isInMemory());
            }
            return hfileBlock.getBufferWithoutHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readBlockBuffer(int block, boolean cacheBlock, boolean pread, boolean isCompaction) throws IOException {
        if (this.dataBlockIndexReader == null) {
            throw new IOException("Block index not loaded");
        }
        if (block < 0 || block >= this.dataBlockIndexReader.getRootBlockCount()) {
            throw new IOException("Requested block is out of range: " + block + ", max: " + this.dataBlockIndexReader.getRootBlockCount());
        }
        long offset = this.dataBlockIndexReader.getRootBlockOffset(block);
        BlockCacheKey cacheKey = HFile.getBlockCacheKey(this.name, offset);
        byte[] byArray = this.dataBlockIndexReader.getRootBlockKey(block);
        synchronized (byArray) {
            HFileBlock cachedBlock;
            this.blockLoads.incrementAndGet();
            if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = (HFileBlock)this.cacheConf.getBlockCache().getBlock(cacheKey, this.cacheConf.shouldCacheDataOnRead())) != null) {
                this.cacheHits.incrementAndGet();
                return cachedBlock.getBufferWithoutHeader();
            }
            long startTimeNs = System.nanoTime();
            long nextOffset = block == this.dataBlockIndexReader.getRootBlockCount() - 1 ? (this.metaBlockIndexReader.getRootBlockCount() == 0 ? this.trailer.getFileInfoOffset() : this.metaBlockIndexReader.getRootBlockOffset(0)) : this.dataBlockIndexReader.getRootBlockOffset(block + 1);
            HFileBlock hfileBlock = this.fsBlockReader.readBlockData(offset, nextOffset - offset, this.dataBlockIndexReader.getRootBlockDataSize(block), pread);
            hfileBlock.expectType(BlockType.DATA);
            ByteBuffer buf = hfileBlock.getBufferWithoutHeader();
            long latency = System.nanoTime() - startTimeNs;
            HFile.offerReadLatency(latency);
            if (cacheBlock && this.cacheConf.shouldCacheBlockOnRead(hfileBlock.getBlockType().getCategory())) {
                this.cacheConf.getBlockCache().cacheBlock(cacheKey, hfileBlock, this.cacheConf.isInMemory());
            }
            return buf;
        }
    }

    @Override
    public byte[] getLastKey() {
        if (!this.fileInfoLoaded) {
            throw new RuntimeException("Load file info first");
        }
        return this.dataBlockIndexReader.isEmpty() ? null : this.lastKey;
    }

    @Override
    public byte[] midkey() throws IOException {
        Preconditions.checkState((boolean)this.isFileInfoLoaded(), (Object)"File info is not loaded");
        Preconditions.checkState((!this.dataBlockIndexReader.isEmpty() ? 1 : 0) != 0, (Object)"Data block index is not loaded or is empty");
        return this.dataBlockIndexReader.midkey();
    }

    @Override
    public void close() throws IOException {
        this.close(this.cacheConf.shouldEvictOnClose());
    }

    @Override
    public void close(boolean evictOnClose) throws IOException {
        if (evictOnClose && this.cacheConf.isBlockCacheEnabled()) {
            int numEvicted = 0;
            for (int i = 0; i < this.dataBlockIndexReader.getRootBlockCount(); ++i) {
                if (!this.cacheConf.getBlockCache().evictBlock(HFile.getBlockCacheKey(this.name, this.dataBlockIndexReader.getRootBlockOffset(i)))) continue;
                ++numEvicted;
            }
            LOG.debug((Object)("On close of file " + this.name + " evicted " + numEvicted + " block(s) of " + this.dataBlockIndexReader.getRootBlockCount() + " total blocks"));
        }
        if (this.closeIStream && this.istream != null) {
            this.istream.close();
            this.istream = null;
        }
    }

    @Override
    public HFileBlock readBlock(long offset, long onDiskBlockSize, boolean cacheBlock, boolean pread, boolean isCompaction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataInput getBloomFilterMetadata() throws IOException {
        ByteBuffer buf = this.getMetaBlock("BLOOM_FILTER_META", false);
        if (buf == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buf.array(), buf.arrayOffset(), buf.limit());
        return new DataInputStream(bais);
    }

    @Override
    public boolean isFileInfoLoaded() {
        return this.fileInfoLoaded;
    }

    protected static class ScannerV1
    extends AbstractHFileReader.Scanner {
        private final HFileReaderV1 reader;
        private int currBlock;

        public ScannerV1(HFileReaderV1 reader, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            super(cacheBlocks, pread, isCompaction);
            this.reader = reader;
        }

        @Override
        public KeyValue getKeyValue() {
            if (this.blockBuffer == null) {
                return null;
            }
            return new KeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() - 8);
        }

        @Override
        public ByteBuffer getKey() {
            Preconditions.checkState((this.blockBuffer != null && this.currKeyLen > 0 ? 1 : 0) != 0, (Object)"you need to seekTo() before calling getKey()");
            ByteBuffer keyBuff = this.blockBuffer.slice();
            keyBuff.limit(this.currKeyLen);
            keyBuff.rewind();
            return keyBuff;
        }

        @Override
        public ByteBuffer getValue() {
            if (this.blockBuffer == null || this.currKeyLen == 0) {
                throw new RuntimeException("you need to seekTo() before calling getValue()");
            }
            ByteBuffer valueBuff = this.blockBuffer.slice();
            valueBuff.position(this.currKeyLen);
            valueBuff = valueBuff.slice();
            valueBuff.limit(this.currValueLen);
            valueBuff.rewind();
            return valueBuff;
        }

        @Override
        public boolean next() throws IOException {
            if (this.blockBuffer == null) {
                throw new IOException("Next called on non-seeked scanner");
            }
            try {
                this.blockBuffer.position(this.blockBuffer.position() + this.currKeyLen + this.currValueLen);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Current pos = " + this.blockBuffer.position() + "; currKeyLen = " + this.currKeyLen + "; currValLen = " + this.currValueLen + "; block limit = " + this.blockBuffer.limit() + "; HFile name = " + this.reader.getName() + "; currBlock id = " + this.currBlock), (Throwable)e);
                throw e;
            }
            if (this.blockBuffer.remaining() <= 0) {
                ++this.currBlock;
                if (this.currBlock >= this.reader.getDataBlockIndexReader().getRootBlockCount()) {
                    this.currBlock = 0;
                    this.blockBuffer = null;
                    return false;
                }
                this.blockBuffer = this.reader.readBlockBuffer(this.currBlock, this.cacheBlocks, this.pread, this.isCompaction);
                this.currKeyLen = this.blockBuffer.getInt();
                this.currValueLen = this.blockBuffer.getInt();
                ++this.blockFetches;
                return true;
            }
            this.currKeyLen = this.blockBuffer.getInt();
            this.currValueLen = this.blockBuffer.getInt();
            return true;
        }

        @Override
        public int seekTo(byte[] key) throws IOException {
            return this.seekTo(key, 0, key.length);
        }

        @Override
        public int seekTo(byte[] key, int offset, int length) throws IOException {
            int b = this.reader.blockContainingKey(key, offset, length);
            if (b < 0) {
                return -1;
            }
            this.loadBlock(b, true);
            return this.blockSeek(key, offset, length, false);
        }

        @Override
        public int reseekTo(byte[] key) throws IOException {
            return this.reseekTo(key, 0, key.length);
        }

        @Override
        public int reseekTo(byte[] key, int offset, int length) throws IOException {
            int b;
            if (this.blockBuffer != null && this.currKeyLen != 0) {
                ByteBuffer bb = this.getKey();
                int compared = this.reader.getComparator().compare(key, offset, length, bb.array(), bb.arrayOffset(), bb.limit());
                if (compared <= 0) {
                    return compared;
                }
            }
            if ((b = this.reader.blockContainingKey(key, offset, length)) < 0) {
                return -1;
            }
            this.loadBlock(b, false);
            return this.blockSeek(key, offset, length, false);
        }

        private int blockSeek(byte[] key, int offset, int length, boolean seekBefore) {
            int lastLen = 0;
            do {
                int klen = this.blockBuffer.getInt();
                int vlen = this.blockBuffer.getInt();
                int comp = this.reader.getComparator().compare(key, offset, length, this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), klen);
                if (comp == 0) {
                    if (seekBefore) {
                        this.blockBuffer.position(this.blockBuffer.position() - lastLen - 16);
                        this.currKeyLen = this.blockBuffer.getInt();
                        this.currValueLen = this.blockBuffer.getInt();
                        return 1;
                    }
                    this.currKeyLen = klen;
                    this.currValueLen = vlen;
                    return 0;
                }
                if (comp < 0) {
                    this.blockBuffer.position(this.blockBuffer.position() - lastLen - 16);
                    this.currKeyLen = this.blockBuffer.getInt();
                    this.currValueLen = this.blockBuffer.getInt();
                    return 1;
                }
                this.blockBuffer.position(this.blockBuffer.position() + klen + vlen);
                lastLen = klen + vlen;
            } while (this.blockBuffer.remaining() > 0);
            this.blockBuffer.position(this.blockBuffer.position() - lastLen - 8);
            this.currKeyLen = this.blockBuffer.getInt();
            this.currValueLen = this.blockBuffer.getInt();
            return 1;
        }

        @Override
        public boolean seekBefore(byte[] key) throws IOException {
            return this.seekBefore(key, 0, key.length);
        }

        @Override
        public boolean seekBefore(byte[] key, int offset, int length) throws IOException {
            int b = this.reader.blockContainingKey(key, offset, length);
            if (b < 0) {
                return false;
            }
            byte[] firstkKey = this.reader.getDataBlockIndexReader().getRootBlockKey(b);
            if (this.reader.getComparator().compare(firstkKey, 0, firstkKey.length, key, offset, length) == 0) {
                if (b == 0) {
                    return false;
                }
                --b;
            }
            this.loadBlock(b, true);
            this.blockSeek(key, offset, length, true);
            return true;
        }

        @Override
        public String getKeyString() {
            return Bytes.toStringBinary(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), this.currKeyLen);
        }

        @Override
        public String getValueString() {
            return Bytes.toString(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + this.currKeyLen, this.currValueLen);
        }

        @Override
        public HFile.Reader getReader() {
            return this.reader;
        }

        @Override
        public boolean seekTo() throws IOException {
            if (this.reader.getDataBlockIndexReader().isEmpty()) {
                return false;
            }
            if (this.blockBuffer != null && this.currBlock == 0) {
                this.blockBuffer.rewind();
                this.currKeyLen = this.blockBuffer.getInt();
                this.currValueLen = this.blockBuffer.getInt();
                return true;
            }
            this.currBlock = 0;
            this.blockBuffer = this.reader.readBlockBuffer(this.currBlock, this.cacheBlocks, this.pread, this.isCompaction);
            this.currKeyLen = this.blockBuffer.getInt();
            this.currValueLen = this.blockBuffer.getInt();
            ++this.blockFetches;
            return true;
        }

        private void loadBlock(int bloc, boolean rewind) throws IOException {
            if (this.blockBuffer == null) {
                this.blockBuffer = this.reader.readBlockBuffer(bloc, this.cacheBlocks, this.pread, this.isCompaction);
                this.currBlock = bloc;
                ++this.blockFetches;
            } else if (bloc != this.currBlock) {
                this.blockBuffer = this.reader.readBlockBuffer(bloc, this.cacheBlocks, this.pread, this.isCompaction);
                this.currBlock = bloc;
                ++this.blockFetches;
            } else if (rewind) {
                this.blockBuffer.rewind();
            } else {
                this.blockBuffer.position(this.blockBuffer.position() - 8);
            }
        }
    }
}

