/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileReader;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableUtils;

public class HFileReaderV2
extends AbstractHFileReader {
    private static final Log LOG = LogFactory.getLog(HFileReaderV2.class);
    private static int KEY_VALUE_LEN_SIZE = 8;
    private boolean includesMemstoreTS = false;
    private IdLock offsetLock = new IdLock();
    private List<HFileBlock> loadOnOpenBlocks = new ArrayList<HFileBlock>();

    private boolean shouldIncludeMemstoreTS() {
        return this.includesMemstoreTS;
    }

    public HFileReaderV2(Path path, FixedFileTrailer trailer, FSDataInputStream fsdis, long size, boolean closeIStream, CacheConfig cacheConf) throws IOException {
        super(path, trailer, fsdis, size, closeIStream, cacheConf);
        HFileBlock b;
        trailer.expectVersion(2);
        this.fsBlockReader = new HFileBlock.FSReaderV2(fsdis, this.compressAlgo, this.fileSize);
        this.comparator = trailer.createComparator();
        this.dataBlockIndexReader = new HFileBlockIndex.BlockIndexReader((RawComparator<byte[]>)this.comparator, trailer.getNumDataIndexLevels(), this);
        this.metaBlockIndexReader = new HFileBlockIndex.BlockIndexReader(Bytes.BYTES_RAWCOMPARATOR, 1);
        HFileBlock.BlockIterator blockIter = this.fsBlockReader.blockRange(trailer.getLoadOnOpenDataOffset(), this.fileSize - (long)trailer.getTrailerSize());
        this.dataBlockIndexReader.readMultiLevelIndexRoot(blockIter.nextBlockAsStream(BlockType.ROOT_INDEX), trailer.getDataIndexCount());
        this.metaBlockIndexReader.readRootIndex(blockIter.nextBlockAsStream(BlockType.ROOT_INDEX), trailer.getMetaIndexCount());
        this.fileInfo = new HFile.FileInfo();
        this.fileInfo.readFields(blockIter.nextBlockAsStream(BlockType.FILE_INFO));
        this.lastKey = (byte[])this.fileInfo.get(HFile.FileInfo.LASTKEY);
        this.avgKeyLen = Bytes.toInt((byte[])this.fileInfo.get(HFile.FileInfo.AVG_KEY_LEN));
        this.avgValueLen = Bytes.toInt((byte[])this.fileInfo.get(HFile.FileInfo.AVG_VALUE_LEN));
        byte[] keyValueFormatVersion = (byte[])this.fileInfo.get(HFileWriterV2.KEY_VALUE_VERSION);
        boolean bl = this.includesMemstoreTS = keyValueFormatVersion != null && Bytes.toInt(keyValueFormatVersion) == 1;
        while ((b = blockIter.nextBlock()) != null) {
            this.loadOnOpenBlocks.add(b);
        }
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        return new ScannerV2(this, cacheBlocks, pread, isCompaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getMetaBlock(String metaBlockName, boolean cacheBlock) throws IOException {
        if (this.trailer.getMetaIndexCount() == 0) {
            return null;
        }
        if (this.metaBlockIndexReader == null) {
            throw new IOException("Meta index not loaded");
        }
        byte[] mbname = Bytes.toBytes(metaBlockName);
        int block = this.metaBlockIndexReader.rootBlockContainingKey(mbname, 0, mbname.length);
        if (block == -1) {
            return null;
        }
        long blockSize = this.metaBlockIndexReader.getRootBlockDataSize(block);
        long startTimeNs = System.nanoTime();
        byte[] byArray = this.metaBlockIndexReader.getRootBlockKey(block);
        synchronized (byArray) {
            HFileBlock cachedBlock;
            this.metaLoads.incrementAndGet();
            long metaBlockOffset = this.metaBlockIndexReader.getRootBlockOffset(block);
            BlockCacheKey cacheKey = HFile.getBlockCacheKey(this.name, metaBlockOffset);
            if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = (HFileBlock)this.cacheConf.getBlockCache().getBlock(cacheKey, cacheBlock &= this.cacheConf.shouldCacheDataOnRead())) != null) {
                this.cacheHits.incrementAndGet();
                return cachedBlock.getBufferWithoutHeader();
            }
            HFileBlock metaBlock = this.fsBlockReader.readBlockData(metaBlockOffset, blockSize, -1, true);
            long latency = System.nanoTime() - startTimeNs;
            HFile.offerReadLatency(latency);
            if (cacheBlock) {
                this.cacheConf.getBlockCache().cacheBlock(cacheKey, metaBlock, this.cacheConf.isInMemory());
            }
            return metaBlock.getBufferWithoutHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HFileBlock readBlock(long dataBlockOffset, long onDiskBlockSize, boolean cacheBlock, boolean pread, boolean isCompaction) throws IOException {
        if (this.dataBlockIndexReader == null) {
            throw new IOException("Block index not loaded");
        }
        if (dataBlockOffset < 0L || dataBlockOffset >= this.trailer.getLoadOnOpenDataOffset()) {
            throw new IOException("Requested block is out of range: " + dataBlockOffset + ", lastDataBlockOffset: " + this.trailer.getLastDataBlockOffset());
        }
        BlockCacheKey cacheKey = HFile.getBlockCacheKey(this.name, dataBlockOffset);
        IdLock.Entry lockEntry = this.offsetLock.getLockEntry(dataBlockOffset);
        try {
            HFileBlock cachedBlock;
            this.blockLoads.incrementAndGet();
            if (this.cacheConf.isBlockCacheEnabled() && (cachedBlock = (HFileBlock)this.cacheConf.getBlockCache().getBlock(cacheKey, cacheBlock)) != null) {
                this.cacheHits.incrementAndGet();
                HFileBlock hFileBlock = cachedBlock;
                return hFileBlock;
            }
            long startTimeNs = System.nanoTime();
            HFileBlock hfileBlock = this.fsBlockReader.readBlockData(dataBlockOffset, onDiskBlockSize, -1, pread);
            BlockType.BlockCategory blockCategory = hfileBlock.getBlockType().getCategory();
            long latency = System.nanoTime() - startTimeNs;
            HFile.offerReadLatency(latency);
            if (cacheBlock && this.cacheConf.shouldCacheBlockOnRead(hfileBlock.getBlockType().getCategory())) {
                this.cacheConf.getBlockCache().cacheBlock(cacheKey, hfileBlock, this.cacheConf.isInMemory());
            }
            HFileBlock hFileBlock = hfileBlock;
            return hFileBlock;
        }
        finally {
            this.offsetLock.releaseLockEntry(lockEntry);
        }
    }

    @Override
    public byte[] getLastKey() {
        return this.dataBlockIndexReader.isEmpty() ? null : this.lastKey;
    }

    @Override
    public byte[] midkey() throws IOException {
        return this.dataBlockIndexReader.midkey();
    }

    @Override
    public void close() throws IOException {
        this.close(this.cacheConf.shouldEvictOnClose());
    }

    @Override
    public void close(boolean evictOnClose) throws IOException {
        if (evictOnClose && this.cacheConf.isBlockCacheEnabled()) {
            int numEvicted = this.cacheConf.getBlockCache().evictBlocksByHfileName(this.name);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("On close, file=" + this.name + " evicted=" + numEvicted + " block(s)"));
            }
        }
        if (this.closeIStream && this.istream != null) {
            this.istream.close();
            this.istream = null;
        }
    }

    @Override
    public DataInput getBloomFilterMetadata() throws IOException {
        for (HFileBlock b : this.loadOnOpenBlocks) {
            if (b.getBlockType() != BlockType.BLOOM_META) continue;
            return b.getByteStream();
        }
        return null;
    }

    @Override
    public boolean isFileInfoLoaded() {
        return true;
    }

    protected static class ScannerV2
    extends AbstractHFileReader.Scanner {
        private HFileBlock block;
        private HFileReaderV2 reader;

        public ScannerV2(HFileReaderV2 r, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            super(cacheBlocks, pread, isCompaction);
            this.reader = r;
        }

        @Override
        public HFileReaderV2 getReader() {
            return this.reader;
        }

        @Override
        public KeyValue getKeyValue() {
            if (!this.isSeeked()) {
                return null;
            }
            KeyValue ret = new KeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position());
            if (this.reader.shouldIncludeMemstoreTS()) {
                ret.setMemstoreTS(this.currMemstoreTS);
            }
            return ret;
        }

        @Override
        public ByteBuffer getKey() {
            this.assertSeeked();
            return ByteBuffer.wrap(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE, this.currKeyLen).slice();
        }

        @Override
        public ByteBuffer getValue() {
            this.assertSeeked();
            return ByteBuffer.wrap(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE + this.currKeyLen, this.currValueLen).slice();
        }

        private void setNonSeekedState() {
            this.block = null;
            this.blockBuffer = null;
            this.currKeyLen = 0;
            this.currValueLen = 0;
            this.currMemstoreTS = 0L;
            this.currMemstoreTSLen = 0;
        }

        @Override
        public boolean next() throws IOException {
            this.assertSeeked();
            try {
                this.blockBuffer.position(this.blockBuffer.position() + KEY_VALUE_LEN_SIZE + this.currKeyLen + this.currValueLen + this.currMemstoreTSLen);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Current pos = " + this.blockBuffer.position() + "; currKeyLen = " + this.currKeyLen + "; currValLen = " + this.currValueLen + "; block limit = " + this.blockBuffer.limit() + "; HFile name = " + this.reader.getName() + "; currBlock currBlockOffset = " + this.block.getOffset()));
                throw e;
            }
            if (this.blockBuffer.remaining() <= 0) {
                long lastDataBlockOffset = this.reader.getTrailer().getLastDataBlockOffset();
                if (this.block.getOffset() >= lastDataBlockOffset) {
                    this.setNonSeekedState();
                    return false;
                }
                HFileBlock nextBlock = this.readNextDataBlock();
                if (nextBlock == null) {
                    this.setNonSeekedState();
                    return false;
                }
                this.updateCurrBlock(nextBlock);
                return true;
            }
            this.readKeyValueLen();
            return true;
        }

        private HFileBlock readNextDataBlock() throws IOException {
            long lastDataBlockOffset = this.reader.getTrailer().getLastDataBlockOffset();
            if (this.block == null) {
                return null;
            }
            HFileBlock curBlock = this.block;
            do {
                if (curBlock.getOffset() >= lastDataBlockOffset) {
                    return null;
                }
                if (curBlock.getOffset() >= 0L) continue;
                throw new IOException("Invalid block file offset: " + this.block);
            } while (!(curBlock = this.reader.readBlock(curBlock.getOffset() + (long)curBlock.getOnDiskSizeWithHeader(), curBlock.getNextBlockOnDiskSizeWithHeader(), this.cacheBlocks, this.pread, this.isCompaction)).getBlockType().equals((Object)BlockType.DATA));
            return curBlock;
        }

        @Override
        public boolean seekTo() throws IOException {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.getTrailer().getEntryCount() == 0L) {
                return false;
            }
            long firstDataBlockOffset = this.reader.getTrailer().getFirstDataBlockOffset();
            if (this.block != null && this.block.getOffset() == firstDataBlockOffset) {
                this.blockBuffer.rewind();
                this.readKeyValueLen();
                return true;
            }
            this.block = this.reader.readBlock(firstDataBlockOffset, -1L, this.cacheBlocks, this.pread, this.isCompaction);
            if (this.block.getOffset() < 0L) {
                throw new IOException("Invalid block offset: " + this.block.getOffset());
            }
            this.updateCurrBlock(this.block);
            return true;
        }

        @Override
        public int seekTo(byte[] key) throws IOException {
            return this.seekTo(key, 0, key.length);
        }

        private int seekTo(byte[] key, int offset, int length, boolean rewind) throws IOException {
            HFileBlockIndex.BlockIndexReader indexReader = this.reader.getDataBlockIndexReader();
            HFileBlock seekToBlock = indexReader.seekToDataBlock(key, offset, length, this.block, this.cacheBlocks, this.pread, this.isCompaction);
            if (seekToBlock == null) {
                return -1;
            }
            return this.loadBlockAndSeekToKey(seekToBlock, rewind, key, offset, length, false);
        }

        @Override
        public int seekTo(byte[] key, int offset, int length) throws IOException {
            return this.seekTo(key, offset, length, true);
        }

        @Override
        public int reseekTo(byte[] key) throws IOException {
            return this.reseekTo(key, 0, key.length);
        }

        @Override
        public int reseekTo(byte[] key, int offset, int length) throws IOException {
            if (this.isSeeked()) {
                ByteBuffer bb = this.getKey();
                int compared = this.reader.getComparator().compare(key, offset, length, bb.array(), bb.arrayOffset(), bb.limit());
                if (compared < 1) {
                    return compared;
                }
            }
            return this.seekTo(key, offset, length, false);
        }

        private int loadBlockAndSeekToKey(HFileBlock seekToBlock, boolean rewind, byte[] key, int offset, int length, boolean seekBefore) throws IOException {
            if (this.block == null || this.block.getOffset() != seekToBlock.getOffset()) {
                this.updateCurrBlock(seekToBlock);
            } else if (rewind) {
                this.blockBuffer.rewind();
            }
            return this.blockSeek(key, offset, length, seekBefore);
        }

        private void updateCurrBlock(HFileBlock newBlock) {
            this.block = newBlock;
            this.blockBuffer = this.block.getBufferWithoutHeader();
            this.readKeyValueLen();
            ++this.blockFetches;
        }

        private final void readKeyValueLen() {
            this.blockBuffer.mark();
            this.currKeyLen = this.blockBuffer.getInt();
            this.currValueLen = this.blockBuffer.getInt();
            this.blockBuffer.reset();
            if (this.reader.shouldIncludeMemstoreTS()) {
                try {
                    int memstoreTSOffset = this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE + this.currKeyLen + this.currValueLen;
                    this.currMemstoreTS = Bytes.readVLong(this.blockBuffer.array(), memstoreTSOffset);
                    this.currMemstoreTSLen = WritableUtils.getVIntSize((long)this.currMemstoreTS);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error reading memstoreTS. " + e);
                }
            }
            if (this.currKeyLen < 0 || this.currValueLen < 0 || this.currKeyLen > this.blockBuffer.limit() || this.currValueLen > this.blockBuffer.limit()) {
                throw new IllegalStateException("Invalid currKeyLen " + this.currKeyLen + " or currValueLen " + this.currValueLen + ". Block offset: " + this.block.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header).");
            }
        }

        private int blockSeek(byte[] key, int offset, int length, boolean seekBefore) {
            long memstoreTS = 0L;
            int memstoreTSLen = 0;
            int lastKeyValueSize = -1;
            do {
                this.blockBuffer.mark();
                int klen = this.blockBuffer.getInt();
                int vlen = this.blockBuffer.getInt();
                this.blockBuffer.reset();
                if (this.reader.shouldIncludeMemstoreTS()) {
                    try {
                        int memstoreTSOffset = this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE + klen + vlen;
                        memstoreTS = Bytes.readVLong(this.blockBuffer.array(), memstoreTSOffset);
                        memstoreTSLen = WritableUtils.getVIntSize((long)memstoreTS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error reading memstoreTS. " + e);
                    }
                }
                int keyOffset = this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE;
                int comp = this.reader.getComparator().compare(key, offset, length, this.blockBuffer.array(), keyOffset, klen);
                if (comp == 0) {
                    if (seekBefore) {
                        if (lastKeyValueSize < 0) {
                            throw new IllegalStateException("blockSeek with seekBefore at the first key of the block: key=" + Bytes.toStringBinary(key) + ", blockOffset=" + this.block.getOffset() + ", onDiskSize=" + this.block.getOnDiskSizeWithHeader());
                        }
                        this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
                        this.readKeyValueLen();
                        return 1;
                    }
                    this.currKeyLen = klen;
                    this.currValueLen = vlen;
                    if (this.reader.shouldIncludeMemstoreTS()) {
                        this.currMemstoreTS = memstoreTS;
                        this.currMemstoreTSLen = memstoreTSLen;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (lastKeyValueSize > 0) {
                        this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
                    }
                    this.readKeyValueLen();
                    return 1;
                }
                lastKeyValueSize = klen + vlen + memstoreTSLen + KEY_VALUE_LEN_SIZE;
                this.blockBuffer.position(this.blockBuffer.position() + lastKeyValueSize);
            } while (this.blockBuffer.remaining() > 0);
            this.blockBuffer.position(this.blockBuffer.position() - lastKeyValueSize);
            this.readKeyValueLen();
            return 1;
        }

        @Override
        public boolean seekBefore(byte[] key) throws IOException {
            return this.seekBefore(key, 0, key.length);
        }

        private ByteBuffer getFirstKeyInBlock(HFileBlock curBlock) {
            ByteBuffer buffer = curBlock.getBufferWithoutHeader();
            buffer.rewind();
            int klen = buffer.getInt();
            buffer.getInt();
            ByteBuffer keyBuff = buffer.slice();
            keyBuff.limit(klen);
            keyBuff.rewind();
            return keyBuff;
        }

        @Override
        public boolean seekBefore(byte[] key, int offset, int length) throws IOException {
            HFileBlock seekToBlock = this.reader.getDataBlockIndexReader().seekToDataBlock(key, offset, length, this.block, this.cacheBlocks, this.pread, this.isCompaction);
            if (seekToBlock == null) {
                return false;
            }
            ByteBuffer firstKey = this.getFirstKeyInBlock(seekToBlock);
            if (this.reader.getComparator().compare(firstKey.array(), firstKey.arrayOffset(), firstKey.limit(), key, offset, length) == 0) {
                long previousBlockOffset = seekToBlock.getPrevBlockOffset();
                if (previousBlockOffset == -1L) {
                    return false;
                }
                seekToBlock = this.reader.readBlock(previousBlockOffset, seekToBlock.getOffset() - previousBlockOffset, this.cacheBlocks, this.pread, this.isCompaction);
            }
            this.loadBlockAndSeekToKey(seekToBlock, true, key, offset, length, true);
            return true;
        }

        @Override
        public String getKeyString() {
            return Bytes.toStringBinary(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE, this.currKeyLen);
        }

        @Override
        public String getValueString() {
            return Bytes.toString(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position() + KEY_VALUE_LEN_SIZE + this.currKeyLen, this.currValueLen);
        }
    }
}

