/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class HFileWriterV2
extends AbstractHFileWriter {
    static final Log LOG = LogFactory.getLog(HFileWriterV2.class);
    public static final byte[] MAX_MEMSTORE_TS_KEY = Bytes.toBytes("MAX_MEMSTORE_TS_KEY");
    public static final byte[] KEY_VALUE_VERSION = Bytes.toBytes("KEY_VALUE_VERSION");
    public static final int KEY_VALUE_VER_WITH_MEMSTORE = 1;
    private List<InlineBlockWriter> inlineBlockWriters = new ArrayList<InlineBlockWriter>();
    private HFileBlock.Writer fsBlockWriter;
    private HFileBlockIndex.BlockIndexWriter dataBlockIndexWriter;
    private HFileBlockIndex.BlockIndexWriter metaBlockIndexWriter;
    private long firstDataBlockOffset = -1L;
    private long lastDataBlockOffset;
    private List<HFileBlock.BlockWritable> additionalLoadOnOpenData = new ArrayList<HFileBlock.BlockWritable>();
    private final boolean includeMemstoreTS = true;
    private long maxMemstoreTS = 0L;

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path) throws IOException {
        this(conf, cacheConf, fs, path, 65536, HFile.DEFAULT_COMPRESSION_ALGORITHM, null);
    }

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path, int blockSize, String compressAlgoName, KeyValue.KeyComparator comparator) throws IOException {
        this(conf, cacheConf, fs, path, blockSize, HFileWriterV2.compressionByName(compressAlgoName), comparator);
    }

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path, int blockSize, Compression.Algorithm compressAlgo, KeyValue.KeyComparator comparator) throws IOException {
        super(cacheConf, HFileWriterV2.createOutputStream(conf, fs, path), path, blockSize, compressAlgo, comparator);
        this.finishInit(conf);
    }

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FSDataOutputStream outputStream, int blockSize, String compressAlgoName, KeyValue.KeyComparator comparator) throws IOException {
        this(conf, cacheConf, outputStream, blockSize, Compression.getCompressionAlgorithmByName(compressAlgoName), comparator);
    }

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FSDataOutputStream outputStream, int blockSize, Compression.Algorithm compress, KeyValue.KeyComparator comparator) throws IOException {
        super(cacheConf, outputStream, null, blockSize, compress, comparator);
        this.finishInit(conf);
    }

    private void finishInit(Configuration conf) {
        if (this.fsBlockWriter != null) {
            throw new IllegalStateException("finishInit called twice");
        }
        this.fsBlockWriter = new HFileBlock.Writer(this.compressAlgo);
        boolean cacheIndexesOnWrite = this.cacheConf.shouldCacheIndexesOnWrite();
        this.dataBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter(this.fsBlockWriter, cacheIndexesOnWrite ? this.cacheConf.getBlockCache() : null, cacheIndexesOnWrite ? this.name : null);
        this.dataBlockIndexWriter.setMaxChunkSize(HFileBlockIndex.getMaxChunkSize(conf));
        this.inlineBlockWriters.add(this.dataBlockIndexWriter);
        this.metaBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter();
        LOG.debug((Object)("Initialized with " + this.cacheConf));
    }

    private void checkBlockBoundary() throws IOException {
        if (this.fsBlockWriter.blockSizeWritten() < this.blockSize) {
            return;
        }
        this.finishBlock();
        this.writeInlineBlocks(false);
        this.newBlock();
    }

    private void finishBlock() throws IOException {
        if (!this.fsBlockWriter.isWriting() || this.fsBlockWriter.blockSizeWritten() == 0) {
            return;
        }
        long startTimeNs = System.nanoTime();
        if (this.firstDataBlockOffset == -1L) {
            this.firstDataBlockOffset = this.outputStream.getPos();
        }
        this.lastDataBlockOffset = this.outputStream.getPos();
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        int onDiskSize = this.fsBlockWriter.getOnDiskSizeWithHeader();
        this.dataBlockIndexWriter.addEntry(this.firstKeyInBlock, this.lastDataBlockOffset, onDiskSize);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        HFile.offerWriteLatency(System.nanoTime() - startTimeNs);
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.cacheConf.getBlockCache().cacheBlock(HFile.getBlockCacheKey(this.name, this.lastDataBlockOffset), this.fsBlockWriter.getBlockForCaching());
        }
    }

    private void writeInlineBlocks(boolean closing) throws IOException {
        for (InlineBlockWriter ibw : this.inlineBlockWriters) {
            while (ibw.shouldWriteBlock(closing)) {
                long offset = this.outputStream.getPos();
                boolean cacheThisBlock = ibw.cacheOnWrite();
                ibw.writeInlineBlock(this.fsBlockWriter.startWriting(ibw.getInlineBlockType(), cacheThisBlock));
                this.fsBlockWriter.writeHeaderAndData(this.outputStream);
                ibw.blockWritten(offset, this.fsBlockWriter.getOnDiskSizeWithHeader(), this.fsBlockWriter.getUncompressedSizeWithoutHeader());
                this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
                if (!cacheThisBlock) continue;
                this.cacheConf.getBlockCache().cacheBlock(HFile.getBlockCacheKey(this.name, offset), this.fsBlockWriter.getBlockForCaching());
            }
        }
    }

    private void newBlock() throws IOException {
        this.fsBlockWriter.startWriting(BlockType.DATA, this.cacheConf.shouldCacheDataOnWrite());
        this.firstKeyInBlock = null;
    }

    @Override
    public void appendMetaBlock(String metaBlockName, Writable content) {
        byte[] cur;
        int i;
        byte[] key = Bytes.toBytes(metaBlockName);
        for (i = 0; i < this.metaNames.size() && Bytes.BYTES_RAWCOMPARATOR.compare(cur = (byte[])this.metaNames.get(i), 0, cur.length, key, 0, key.length) <= 0; ++i) {
        }
        this.metaNames.add(i, key);
        this.metaData.add(i, content);
    }

    @Override
    public void append(KeyValue kv) throws IOException {
        this.append(kv.getMemstoreTS(), kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        this.maxMemstoreTS = Math.max(this.maxMemstoreTS, kv.getMemstoreTS());
    }

    @Override
    public void append(byte[] key, byte[] value) throws IOException {
        this.append(0L, key, 0, key.length, value, 0, value.length);
    }

    private void append(long memstoreTS, byte[] key, int koffset, int klength, byte[] value, int voffset, int vlength) throws IOException {
        boolean dupKey = this.checkKey(key, koffset, klength);
        this.checkValue(value, voffset, vlength);
        if (!dupKey) {
            this.checkBlockBoundary();
        }
        if (!this.fsBlockWriter.isWriting()) {
            this.newBlock();
        }
        DataOutputStream out = this.fsBlockWriter.getUserDataStream();
        out.writeInt(klength);
        this.totalKeyLength += (long)klength;
        out.writeInt(vlength);
        this.totalValueLength += (long)vlength;
        out.write(key, koffset, klength);
        out.write(value, voffset, vlength);
        this.getClass();
        WritableUtils.writeVLong((DataOutput)out, (long)memstoreTS);
        if (this.firstKeyInBlock == null) {
            this.firstKeyInBlock = new byte[klength];
            System.arraycopy(key, koffset, this.firstKeyInBlock, 0, klength);
        }
        this.lastKeyBuffer = key;
        this.lastKeyOffset = koffset;
        this.lastKeyLength = klength;
        ++this.entryCount;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        this.finishBlock();
        this.writeInlineBlocks(true);
        FixedFileTrailer trailer = new FixedFileTrailer(2);
        if (!this.metaNames.isEmpty()) {
            for (int i = 0; i < this.metaNames.size(); ++i) {
                long offset = this.outputStream.getPos();
                DataOutputStream dos = this.fsBlockWriter.startWriting(BlockType.META, this.cacheConf.shouldCacheDataOnWrite());
                ((Writable)this.metaData.get(i)).write((DataOutput)dos);
                this.fsBlockWriter.writeHeaderAndData(this.outputStream);
                this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
                this.metaBlockIndexWriter.addEntry((byte[])this.metaNames.get(i), offset, this.fsBlockWriter.getOnDiskSizeWithHeader());
            }
        }
        long rootIndexOffset = this.dataBlockIndexWriter.writeIndexBlocks(this.outputStream);
        trailer.setLoadOnOpenOffset(rootIndexOffset);
        this.metaBlockIndexWriter.writeSingleLevelIndex(this.fsBlockWriter.startWriting(BlockType.ROOT_INDEX, false), "meta");
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        this.getClass();
        this.appendFileInfo(MAX_MEMSTORE_TS_KEY, Bytes.toBytes(this.maxMemstoreTS));
        this.appendFileInfo(KEY_VALUE_VERSION, Bytes.toBytes(1));
        this.writeFileInfo(trailer, this.fsBlockWriter.startWriting(BlockType.FILE_INFO, false));
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        for (HFileBlock.BlockWritable w : this.additionalLoadOnOpenData) {
            this.fsBlockWriter.writeBlock(w, this.outputStream);
            this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        }
        trailer.setNumDataIndexLevels(this.dataBlockIndexWriter.getNumLevels());
        trailer.setUncompressedDataIndexSize(this.dataBlockIndexWriter.getTotalUncompressedSize());
        trailer.setFirstDataBlockOffset(this.firstDataBlockOffset);
        trailer.setLastDataBlockOffset(this.lastDataBlockOffset);
        trailer.setComparatorClass(this.comparator.getClass());
        trailer.setDataIndexCount(this.dataBlockIndexWriter.getNumRootEntries());
        this.finishClose(trailer);
        this.fsBlockWriter.releaseCompressor();
    }

    @Override
    public void addInlineBlockWriter(InlineBlockWriter ibw) {
        this.inlineBlockWriters.add(ibw);
    }

    @Override
    public void addBloomFilter(final BloomFilterWriter bfw) {
        if (bfw.getKeyCount() <= 0L) {
            return;
        }
        this.additionalLoadOnOpenData.add(new HFileBlock.BlockWritable(){

            @Override
            public BlockType getBlockType() {
                return BlockType.BLOOM_META;
            }

            @Override
            public void writeToBlock(DataOutput out) throws IOException {
                bfw.getMetaWriter().write(out);
                Writable dataWriter = bfw.getDataWriter();
                if (dataWriter != null) {
                    dataWriter.write(out);
                }
            }
        });
    }

    static class WriterFactoryV2
    extends HFile.WriterFactory {
        WriterFactoryV2(Configuration conf, CacheConfig cacheConf) {
            super(conf, cacheConf);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path) throws IOException {
            return new HFileWriterV2(this.conf, this.cacheConf, fs, path);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path, int blockSize, Compression.Algorithm compress, KeyValue.KeyComparator comparator) throws IOException {
            return new HFileWriterV2(this.conf, this.cacheConf, fs, path, blockSize, compress, comparator);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path, int blockSize, String compress, KeyValue.KeyComparator comparator) throws IOException {
            return new HFileWriterV2(this.conf, this.cacheConf, fs, path, blockSize, compress, comparator);
        }

        @Override
        public HFile.Writer createWriter(FSDataOutputStream ostream, int blockSize, String compress, KeyValue.KeyComparator comparator) throws IOException {
            return new HFileWriterV2(this.conf, this.cacheConf, ostream, blockSize, compress, comparator);
        }

        @Override
        public HFile.Writer createWriter(FSDataOutputStream ostream, int blockSize, Compression.Algorithm compress, KeyValue.KeyComparator c) throws IOException {
            return new HFileWriterV2(this.conf, this.cacheConf, ostream, blockSize, compress, c);
        }
    }
}

