/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.slab.SingleSizeCache;
import org.apache.hadoop.hbase.io.hfile.slab.SlabItemActionWatcher;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.util.StringUtils;

public class SlabCache
implements SlabItemActionWatcher,
BlockCache,
HeapSize {
    private final ConcurrentHashMap<BlockCacheKey, SingleSizeCache> backingStore;
    private final TreeMap<Integer, SingleSizeCache> sizer;
    static final Log LOG = LogFactory.getLog(SlabCache.class);
    static final int STAT_THREAD_PERIOD_SECS = 300;
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Slab Statistics #%d").build());
    long size;
    private final CacheStats stats;
    final SlabStats requestStats;
    final SlabStats successfullyCachedStats;
    private final long avgBlockSize;
    private static final long CACHE_FIXED_OVERHEAD = ClassSize.estimateBase(SlabCache.class, false);

    public SlabCache(long size, long avgBlockSize) {
        this.avgBlockSize = avgBlockSize;
        this.size = size;
        this.stats = new CacheStats();
        this.requestStats = new SlabStats();
        this.successfullyCachedStats = new SlabStats();
        this.backingStore = new ConcurrentHashMap();
        this.sizer = new TreeMap();
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 300L, 300L, TimeUnit.SECONDS);
    }

    public void addSlabByConf(Configuration conf) {
        String[] sizes;
        String[] porportions = conf.getStrings("hbase.offheapcache.slab.proportions", new String[]{"0.80", "0.20"});
        if (porportions.length != (sizes = conf.getStrings("hbase.offheapcache.slab.sizes", new String[]{new Long(this.avgBlockSize * 11L / 10L).toString(), new Long(this.avgBlockSize * 21L / 10L).toString()})).length) {
            throw new IllegalArgumentException("SlabCache conf not initialized, error in configuration. hbase.offheap.slab.proportions specifies " + porportions.length + " slabs while hbase.offheap.slab.sizes specifies " + sizes.length + " slabs " + "offheapslabporportions and offheapslabsizes");
        }
        BigDecimal[] parsedProportions = this.stringArrayToBigDecimalArray(porportions);
        BigDecimal[] parsedSizes = this.stringArrayToBigDecimalArray(sizes);
        BigDecimal sumProportions = new BigDecimal(0);
        for (BigDecimal b : parsedProportions) {
            Preconditions.checkArgument((b.compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (Object)"Proportions in hbase.offheap.slab.proportions must be greater than 0!");
            sumProportions = sumProportions.add(b);
        }
        Preconditions.checkArgument((sumProportions.compareTo(BigDecimal.ONE) != 1 ? 1 : 0) != 0, (Object)"Sum of all proportions in hbase.offheap.slab.proportions must be less than 1");
        if (sumProportions.compareTo(new BigDecimal("0.99")) == -1) {
            LOG.warn((Object)"Sum of hbase.offheap.slab.proportions is less than 0.99! Memory is being wasted");
        }
        for (int i = 0; i < parsedProportions.length; ++i) {
            int blockSize = parsedSizes[i].intValue();
            int numBlocks = new BigDecimal(this.size).multiply(parsedProportions[i]).divide(parsedSizes[i], 1).intValue();
            this.addSlab(blockSize, numBlocks);
        }
    }

    Map.Entry<Integer, SingleSizeCache> getHigherBlock(int size) {
        return this.sizer.higherEntry(size - 1);
    }

    private BigDecimal[] stringArrayToBigDecimalArray(String[] parsee) {
        BigDecimal[] parsed = new BigDecimal[parsee.length];
        for (int i = 0; i < parsee.length; ++i) {
            parsed[i] = new BigDecimal(parsee[i].trim());
        }
        return parsed;
    }

    private void addSlab(int blockSize, int numBlocks) {
        LOG.info((Object)("Creating a slab of blockSize " + blockSize + " with " + numBlocks + " blocks."));
        this.sizer.put(blockSize, new SingleSizeCache(blockSize, numBlocks, this));
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable cachedItem) {
        Map.Entry<Integer, SingleSizeCache> scacheEntry = this.getHigherBlock(cachedItem.getSerializedLength());
        this.requestStats.addin(cachedItem.getSerializedLength());
        if (scacheEntry == null) {
            return;
        }
        this.successfullyCachedStats.addin(cachedItem.getSerializedLength());
        SingleSizeCache scache = scacheEntry.getValue();
        scache.cacheBlock(cacheKey, cachedItem);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.cacheBlock(cacheKey, buf);
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public Cacheable getBlock(BlockCacheKey key, boolean caching) {
        SingleSizeCache cachedBlock = this.backingStore.get(key);
        if (cachedBlock == null) {
            this.stats.miss(caching);
            return null;
        }
        Cacheable contentBlock = cachedBlock.getBlock(key, caching);
        if (contentBlock != null) {
            this.stats.hit(caching);
        } else {
            this.stats.miss(caching);
        }
        return contentBlock;
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        SingleSizeCache cacheEntry = this.backingStore.get(cacheKey);
        if (cacheEntry == null) {
            return false;
        }
        cacheEntry.evictBlock(cacheKey);
        return true;
    }

    @Override
    public void onEviction(BlockCacheKey key, SingleSizeCache notifier) {
        this.stats.evicted();
        this.backingStore.remove(key);
    }

    @Override
    public void onInsertion(BlockCacheKey key, SingleSizeCache notifier) {
        this.backingStore.put(key, notifier);
    }

    @Override
    public void shutdown() {
        for (SingleSizeCache s : this.sizer.values()) {
            s.shutdown();
        }
        this.scheduleThreadPool.shutdown();
    }

    @Override
    public long heapSize() {
        long childCacheSize = 0L;
        for (SingleSizeCache s : this.sizer.values()) {
            childCacheSize += s.heapSize();
        }
        return CACHE_FIXED_OVERHEAD + childCacheSize;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public long getBlockCount() {
        long count = 0L;
        for (SingleSizeCache cache : this.backingStore.values()) {
            count += cache.getBlockCount();
        }
        return count;
    }

    @Override
    public long getCurrentSize() {
        return this.size;
    }

    @Override
    public long getEvictedCount() {
        return this.stats.getEvictedCount();
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        int numEvicted = 0;
        for (BlockCacheKey key : this.backingStore.keySet()) {
            if (!key.getHfileName().equals(hfileName) || !this.evictBlock(key)) continue;
            ++numEvicted;
        }
        return numEvicted;
    }

    @Override
    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries(Configuration conf) {
        throw new UnsupportedOperationException();
    }

    static class SlabStats {
        final int MULTIPLIER = 10;
        final int NUMDIVISIONS = (int)(Math.log(2.147483647E9) * 10.0);
        private final AtomicLong[] counts = new AtomicLong[this.NUMDIVISIONS];

        public SlabStats() {
            for (int i = 0; i < this.NUMDIVISIONS; ++i) {
                this.counts[i] = new AtomicLong();
            }
        }

        public void addin(int size) {
            int index = (int)(Math.log(size) * 10.0);
            this.counts[index].incrementAndGet();
        }

        public AtomicLong[] getUsage() {
            return this.counts;
        }

        double getUpperBound(int index) {
            return Math.pow(Math.E, ((double)index + 0.5) / 10.0);
        }

        double getLowerBound(int index) {
            return Math.pow(Math.E, ((double)index - 0.5) / 10.0);
        }

        public void logStats() {
            AtomicLong[] fineGrainedStats = this.getUsage();
            for (int i = 0; i < fineGrainedStats.length; ++i) {
                if (fineGrainedStats[i].get() <= 0L) continue;
                LOG.info((Object)("From  " + StringUtils.humanReadableInt((long)((long)this.getLowerBound(i))) + "- " + StringUtils.humanReadableInt((long)((long)this.getUpperBound(i))) + ": " + StringUtils.humanReadableInt((long)fineGrainedStats[i].get()) + " requests"));
            }
        }
    }

    static class StatisticsThread
    extends HasThread {
        SlabCache ourcache;

        public StatisticsThread(SlabCache slabCache) {
            super("SlabCache.StatisticsThread");
            this.setDaemon(true);
            this.ourcache = slabCache;
        }

        @Override
        public void run() {
            for (SingleSizeCache s : this.ourcache.sizer.values()) {
                s.logStats();
            }
            LOG.info((Object)("Current heap size is: " + StringUtils.humanReadableInt((long)this.ourcache.heapSize())));
            LOG.info((Object)"Request Stats");
            this.ourcache.requestStats.logStats();
            LOG.info((Object)"Successfully Cached Stats");
            this.ourcache.successfullyCachedStats.logStats();
        }
    }
}

