/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;

public class ExecRPCInvoker
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.ExecRPCInvoker");
    private Configuration conf;
    private final HConnection connection;
    private Class<? extends CoprocessorProtocol> protocol;
    private final byte[] table;
    private final byte[] row;
    private byte[] regionName;

    public ExecRPCInvoker(Configuration conf, HConnection connection, Class<? extends CoprocessorProtocol> protocol, byte[] table, byte[] row) {
        this.conf = conf;
        this.connection = connection;
        this.protocol = protocol;
        this.table = table;
        this.row = row;
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call: " + method.getName() + ", " + (args != null ? args.length : 0)));
        }
        if (this.row != null) {
            final Exec exec = new Exec(this.conf, this.row, this.protocol, method, args);
            ServerCallable<ExecResult> callable = new ServerCallable<ExecResult>(this.connection, this.table, this.row){

                @Override
                public ExecResult call() throws Exception {
                    return this.server.execCoprocessor(this.location.getRegionInfo().getRegionName(), exec);
                }
            };
            ExecResult result = this.connection.getRegionServerWithRetries(callable);
            this.regionName = result.getRegionName();
            LOG.debug((Object)("Result is region=" + Bytes.toStringBinary(this.regionName) + ", value=" + result.getValue()));
            return result.getValue();
        }
        return null;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }
}

