/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ipc.HBaseRPCStatistics;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class HBaseRpcMetrics
implements Updater {
    public static final String NAME_DELIM = "$";
    private final MetricsRegistry registry = new MetricsRegistry();
    private final MetricsRecord metricsRecord;
    private final RpcServer myServer;
    private static Log LOG = LogFactory.getLog(HBaseRpcMetrics.class);
    private final HBaseRPCStatistics rpcStatistics;
    public final MetricsTimeVaryingLong receivedBytes = new MetricsTimeVaryingLong("ReceivedBytes", this.registry);
    public final MetricsTimeVaryingLong sentBytes = new MetricsTimeVaryingLong("SentBytes", this.registry);
    public final MetricsTimeVaryingRate rpcQueueTime = new MetricsTimeVaryingRate("RpcQueueTime", this.registry);
    public MetricsTimeVaryingRate rpcProcessingTime = new MetricsTimeVaryingRate("RpcProcessingTime", this.registry);
    public final MetricsIntValue numOpenConnections = new MetricsIntValue("NumOpenConnections", this.registry);
    public final MetricsIntValue callQueueLen = new MetricsIntValue("callQueueLen", this.registry);
    public final MetricsTimeVaryingInt authenticationFailures = new MetricsTimeVaryingInt("rpcAuthenticationFailures", this.registry);
    public final MetricsTimeVaryingInt authenticationSuccesses = new MetricsTimeVaryingInt("rpcAuthenticationSuccesses", this.registry);
    public final MetricsTimeVaryingInt authorizationFailures = new MetricsTimeVaryingInt("rpcAuthorizationFailures", this.registry);
    public final MetricsTimeVaryingInt authorizationSuccesses = new MetricsTimeVaryingInt("rpcAuthorizationSuccesses", this.registry);
    public MetricsTimeVaryingRate rpcSlowResponseTime = new MetricsTimeVaryingRate("RpcSlowResponse", this.registry);

    public HBaseRpcMetrics(String hostName, String port, RpcServer server) {
        this.myServer = server;
        MetricsContext context = MetricsUtil.getContext((String)"rpc");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info((Object)("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port));
        context.registerUpdater((Updater)this);
        this.initMethods(HMasterInterface.class);
        this.initMethods(HMasterRegionInterface.class);
        this.initMethods(HRegionInterface.class);
        this.rpcStatistics = new HBaseRPCStatistics(this.registry, hostName, port);
    }

    private void initMethods(Class<? extends VersionedProtocol> protocol) {
        for (Method m : protocol.getDeclaredMethods()) {
            if (this.get(m.getName()) != null) continue;
            this.create(m.getName());
        }
    }

    private MetricsTimeVaryingRate get(String key) {
        return (MetricsTimeVaryingRate)this.registry.get(key);
    }

    private MetricsTimeVaryingRate create(String key) {
        return new MetricsTimeVaryingRate(key, this.registry);
    }

    public void inc(String name, int amt) {
        MetricsTimeVaryingRate m = this.get(name);
        if (m == null) {
            LOG.warn((Object)("Got inc() request for method that doesnt exist: " + name));
            return;
        }
        m.inc((long)amt);
    }

    public void createMetrics(Class<?>[] ifaces) {
        this.createMetrics(ifaces, false);
    }

    public void createMetrics(Class<?>[] ifaces, boolean prefixWithClass) {
        this.createMetrics(ifaces, prefixWithClass, null);
    }

    public void createMetrics(Class<?>[] ifaces, boolean prefixWithClass, String[] suffixes) {
        for (Class<?> iface : ifaces) {
            Method[] methods;
            for (Method method : methods = iface.getMethods()) {
                String attrName;
                String string = attrName = prefixWithClass ? HBaseRpcMetrics.getMetricName(iface, method.getName()) : method.getName();
                if (this.get(attrName) == null) {
                    this.create(attrName);
                }
                if (suffixes == null) continue;
                for (String s : suffixes) {
                    String metricName = attrName + s;
                    if (this.get(metricName) != null) continue;
                    this.create(metricName);
                }
            }
        }
    }

    public static String getMetricName(Class<?> c, String method) {
        return c.getSimpleName() + NAME_DELIM + method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext context) {
        HBaseRpcMetrics hBaseRpcMetrics = this;
        synchronized (hBaseRpcMetrics) {
            this.numOpenConnections.set(this.myServer.getNumOpenConnections());
            this.callQueueLen.set(this.myServer.getCallQueueLen());
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcStatistics != null) {
            this.rpcStatistics.shutdown();
        }
    }
}

