/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.Invocation;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.SecureClient;
import org.apache.hadoop.hbase.ipc.SecureServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Objects;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;

public class SecureRpcEngine
implements RpcEngine {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.SecureRpcEngine");
    protected static final ClientCache CLIENTS = new ClientCache();

    private SecureRpcEngine() {
    }

    @Override
    public VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, User ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        VersionedProtocol proxy;
        long serverVersion;
        if (User.isSecurityEnabled()) {
            HBaseSaslRpcServer.init(conf);
        }
        if ((serverVersion = (proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout))).getProtocolVersion(protocol.getName(), clientVersion)) != clientVersion) {
            throw new HBaseRPC.VersionMismatch(protocol.getName(), clientVersion, serverVersion);
        }
        return proxy;
    }

    @Override
    public void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Class<? extends VersionedProtocol> protocol, User ticket, Configuration conf) throws IOException, InterruptedException {
        Invocation[] invocations = new Invocation[params.length];
        for (int i = 0; i < params.length; ++i) {
            invocations[i] = new Invocation(method, params[i]);
        }
        SecureClient client = CLIENTS.getClient(conf);
        try {
            Writable[] wrappedValues = client.call((Writable[])invocations, addrs, protocol, ticket);
            if (method.getReturnType() == Void.TYPE) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] values = (Object[])Array.newInstance(method.getReturnType(), wrappedValues.length);
            for (int i = 0; i < values.length; ++i) {
                if (wrappedValues[i] == null) continue;
                values[i] = ((HbaseObjectWritable)wrappedValues[i]).get();
            }
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            CLIENTS.stopClient(client);
        }
    }

    @Override
    public Server getServer(Class<? extends VersionedProtocol> protocol, Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        Server server = new Server(instance, ifaces, conf, bindAddress, port, numHandlers, metaHandlerCount, verbose, highPriorityLevel);
        return server;
    }

    protected static void log(String value) {
        String v = value;
        if (v != null && v.length() > 55) {
            v = v.substring(0, 55) + "...";
        }
        LOG.info((Object)v);
    }

    public static class Server
    extends SecureServer {
        private Object instance;
        private Class<?> implementation;
        private Class<?>[] ifaces;
        private boolean verbose;

        private static String classNameBase(String className) {
            String[] names = className.split("\\.", -1);
            if (names == null || names.length == 0) {
                return className;
            }
            return names[names.length - 1];
        }

        public Server(Object instance, Class<?>[] ifaces, Configuration conf, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, int highPriorityLevel) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, metaHandlerCount, conf, Server.classNameBase(instance.getClass().getName()), highPriorityLevel);
            this.instance = instance;
            this.implementation = instance.getClass();
            this.verbose = verbose;
            this.ifaces = ifaces;
            this.rpcMetrics.createMetrics(this.ifaces);
        }

        public AuthenticationTokenSecretManager createSecretManager() {
            if (this.instance instanceof org.apache.hadoop.hbase.Server) {
                org.apache.hadoop.hbase.Server server = (org.apache.hadoop.hbase.Server)this.instance;
                Configuration conf = server.getConfiguration();
                long keyUpdateInterval = conf.getLong("hbase.auth.key.update.interval", 86400000L);
                long maxAge = conf.getLong("hbase.auth.token.max.lifetime", 604800000L);
                return new AuthenticationTokenSecretManager(conf, server.getZooKeeper(), server.getServerName().toString(), keyUpdateInterval, maxAge);
            }
            return null;
        }

        @Override
        public void startThreads() {
            AuthenticationTokenSecretManager mgr = this.createSecretManager();
            if (mgr != null) {
                this.setSecretManager(mgr);
                mgr.start();
            }
            this.authManager = new ServiceAuthorizationManager();
            HBasePolicyProvider.init(this.conf, this.authManager);
            super.startThreads();
        }

        @Override
        public Writable call(Class<? extends VersionedProtocol> protocol, Writable param, long receivedTime, MonitoredRPCHandler status) throws IOException {
            try {
                Invocation call = (Invocation)param;
                if (call.getMethodName() == null) {
                    throw new IOException("Could not find requested method, the usual cause is a version mismatch between client and server.");
                }
                if (this.verbose) {
                    SecureRpcEngine.log("Call: " + (Object)((Object)call));
                }
                Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
                method.setAccessible(true);
                Object impl = null;
                if (!protocol.isAssignableFrom(this.implementation)) {
                    throw new HBaseRPC.UnknownProtocolException(protocol);
                }
                impl = this.instance;
                long startTime = System.currentTimeMillis();
                Object[] params = call.getParameters();
                Object value = method.invoke(impl, params);
                int processingTime = (int)(System.currentTimeMillis() - startTime);
                int qTime = (int)(startTime - receivedTime);
                if (TRACELOG.isDebugEnabled()) {
                    TRACELOG.debug((Object)("Call #" + ((HBaseServer.Call)Server.CurCall.get()).id + "; Served: " + protocol.getSimpleName() + "#" + call.getMethodName() + " queueTime=" + qTime + " processingTime=" + processingTime + " contents=" + Objects.describeQuantity(params)));
                }
                this.rpcMetrics.rpcQueueTime.inc((long)qTime);
                this.rpcMetrics.rpcProcessingTime.inc((long)processingTime);
                this.rpcMetrics.inc(call.getMethodName(), processingTime);
                if (this.verbose) {
                    SecureRpcEngine.log("Return: " + value);
                }
                return new HbaseObjectWritable(method.getReturnType(), value);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    LOG.error((Object)"Unexpected throwable object ", e);
                }
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private Class<? extends VersionedProtocol> protocol;
        private InetSocketAddress address;
        private User ticket;
        private SecureClient client;
        private boolean isClosed = false;
        private final int rpcTimeout;

        public Invoker(Class<? extends VersionedProtocol> protocol, InetSocketAddress address, User ticket, Configuration conf, SocketFactory factory, int rpcTimeout) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.client = CLIENTS.getClient(conf, factory);
            this.rpcTimeout = rpcTimeout;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean logDebug = LOG.isDebugEnabled();
            long startTime = 0L;
            if (logDebug) {
                startTime = System.currentTimeMillis();
            }
            HbaseObjectWritable value = (HbaseObjectWritable)this.client.call((Writable)new Invocation(method, args), this.address, this.protocol, this.ticket, this.rpcTimeout);
            if (logDebug) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        protected synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, SecureClient> clients = new HashMap<SocketFactory, SecureClient>();

        protected ClientCache() {
        }

        protected synchronized SecureClient getClient(Configuration conf, SocketFactory factory) {
            SecureClient client = this.clients.get(factory);
            if (client == null) {
                client = new SecureClient(HbaseObjectWritable.class, conf, factory);
                this.clients.put(factory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        protected synchronized SecureClient getClient(Configuration conf) {
            return this.getClient(conf, SocketFactory.getDefault());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopClient(SecureClient client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }
}

