/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.ipc.HBaseClient;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.Invocation;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Objects;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RPC;
import org.codehaus.jackson.map.ObjectMapper;

class WritableRpcEngine
implements RpcEngine {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.RPCEngine");
    protected static final ClientCache CLIENTS = new ClientCache();

    WritableRpcEngine() {
    }

    @Override
    public VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, User ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        long serverVersion;
        VersionedProtocol proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout));
        if (proxy instanceof VersionedProtocol && (serverVersion = proxy.getProtocolVersion(protocol.getName(), clientVersion)) != clientVersion) {
            throw new HBaseRPC.VersionMismatch(protocol.getName(), clientVersion, serverVersion);
        }
        return proxy;
    }

    @Override
    public void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Class<? extends VersionedProtocol> protocol, User ticket, Configuration conf) throws IOException, InterruptedException {
        Invocation[] invocations = new Invocation[params.length];
        for (int i = 0; i < params.length; ++i) {
            invocations[i] = new Invocation(method, params[i]);
        }
        HBaseClient client = CLIENTS.getClient(conf);
        try {
            Writable[] wrappedValues = client.call((Writable[])invocations, addrs, protocol, ticket);
            if (method.getReturnType() == Void.TYPE) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] values = (Object[])Array.newInstance(method.getReturnType(), wrappedValues.length);
            for (int i = 0; i < values.length; ++i) {
                if (wrappedValues[i] == null) continue;
                values[i] = ((HbaseObjectWritable)wrappedValues[i]).get();
            }
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            CLIENTS.stopClient(client);
        }
    }

    @Override
    public Server getServer(Class<? extends VersionedProtocol> protocol, Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        return new Server(instance, ifaces, conf, bindAddress, port, numHandlers, metaHandlerCount, verbose, highPriorityLevel);
    }

    protected static void log(String value) {
        String v = value;
        if (v != null && v.length() > 55) {
            v = v.substring(0, 55) + "...";
        }
        LOG.info((Object)v);
    }

    public static class Server
    extends HBaseServer {
        private Object instance;
        private Class<?> implementation;
        private Class<?>[] ifaces;
        private boolean verbose;
        private boolean authorize = false;
        private static ObjectMapper mapper = new ObjectMapper();
        private static final String WARN_RESPONSE_TIME = "hbase.ipc.warn.response.time";
        private static final String WARN_RESPONSE_SIZE = "hbase.ipc.warn.response.size";
        private static final int DEFAULT_WARN_RESPONSE_TIME = 10000;
        private static final int DEFAULT_WARN_RESPONSE_SIZE = 0x6400000;
        private static final String ABOVE_ONE_SEC_METRIC = ".aboveOneSec.";
        private final int warnResponseTime;
        private final int warnResponseSize;

        private static String classNameBase(String className) {
            String[] names = className.split("\\.", -1);
            if (names == null || names.length == 0) {
                return className;
            }
            return names[names.length - 1];
        }

        public Server(Object instance, Class<?>[] ifaces, Configuration conf, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, int highPriorityLevel) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, metaHandlerCount, conf, Server.classNameBase(instance.getClass().getName()), highPriorityLevel);
            this.instance = instance;
            this.implementation = instance.getClass();
            this.verbose = verbose;
            this.ifaces = ifaces;
            String[] metricSuffixes = new String[]{ABOVE_ONE_SEC_METRIC};
            this.rpcMetrics.createMetrics(this.ifaces, false, metricSuffixes);
            this.authorize = conf.getBoolean("hadoop.security.authorization", false);
            this.warnResponseTime = conf.getInt(WARN_RESPONSE_TIME, 10000);
            this.warnResponseSize = conf.getInt(WARN_RESPONSE_SIZE, 0x6400000);
        }

        @Override
        public Writable call(Class<? extends VersionedProtocol> protocol, Writable param, long receivedTime, MonitoredRPCHandler status) throws IOException {
            try {
                boolean tooLarge;
                Invocation call = (Invocation)param;
                if (call.getMethodName() == null) {
                    throw new IOException("Could not find requested method, the usual cause is a version mismatch between client and server.");
                }
                if (this.verbose) {
                    WritableRpcEngine.log("Call: " + (Object)((Object)call));
                }
                status.setRPC(call.getMethodName(), call.getParameters(), receivedTime);
                status.setRPCPacket(param);
                status.resume("Servicing call");
                Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
                method.setAccessible(true);
                if (!method.getDeclaringClass().equals(VersionedProtocol.class)) {
                    long clientVersion = call.getProtocolVersion();
                    ProtocolSignature serverInfo = ((VersionedProtocol)this.instance).getProtocolSignature(protocol.getCanonicalName(), call.getProtocolVersion(), call.getClientMethodsHash());
                    long serverVersion = serverInfo.getVersion();
                    if (serverVersion != clientVersion) {
                        LOG.warn((Object)("Version mismatch: client version=" + clientVersion + ", server version=" + serverVersion));
                        throw new RPC.VersionMismatch(protocol.getName(), clientVersion, serverVersion);
                    }
                }
                Object impl = null;
                if (!protocol.isAssignableFrom(this.implementation)) {
                    throw new HBaseRPC.UnknownProtocolException(protocol);
                }
                impl = this.instance;
                long startTime = System.currentTimeMillis();
                Object[] params = call.getParameters();
                Object value = method.invoke(impl, params);
                int processingTime = (int)(System.currentTimeMillis() - startTime);
                int qTime = (int)(startTime - receivedTime);
                if (TRACELOG.isDebugEnabled()) {
                    TRACELOG.debug((Object)("Call #" + ((HBaseServer.Call)Server.CurCall.get()).id + "; Served: " + protocol.getSimpleName() + "#" + call.getMethodName() + " queueTime=" + qTime + " processingTime=" + processingTime + " contents=" + Objects.describeQuantity(params)));
                }
                this.rpcMetrics.rpcQueueTime.inc((long)qTime);
                this.rpcMetrics.rpcProcessingTime.inc((long)processingTime);
                this.rpcMetrics.inc(call.getMethodName(), processingTime);
                if (this.verbose) {
                    WritableRpcEngine.log("Return: " + value);
                }
                HbaseObjectWritable retVal = new HbaseObjectWritable(method.getReturnType(), value);
                long responseSize = retVal.getWritableSize();
                boolean tooSlow = processingTime > this.warnResponseTime && this.warnResponseTime > -1;
                boolean bl = tooLarge = responseSize > (long)this.warnResponseSize && this.warnResponseSize > -1;
                if (tooSlow || tooLarge) {
                    this.logResponse(call, tooLarge ? "TooLarge" : "TooSlow", status.getClient(), startTime, processingTime, qTime, responseSize);
                    if (tooSlow) {
                        this.rpcMetrics.rpcSlowResponseTime.inc((long)processingTime);
                    }
                }
                if (processingTime > 1000) {
                    this.rpcMetrics.inc(call.getMethodName() + ABOVE_ONE_SEC_METRIC, processingTime);
                }
                return retVal;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    LOG.error((Object)"Unexpected throwable object ", e);
                }
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }

        private void logResponse(Invocation call, String tag, String clientAddress, long startTime, int processingTime, int qTime, long responseSize) throws IOException {
            Object[] params = call.getParameters();
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, Object> responseInfo = new HashMap<String, Object>();
            responseInfo.put("starttimems", startTime);
            responseInfo.put("processingtimems", processingTime);
            responseInfo.put("queuetimems", qTime);
            responseInfo.put("responsesize", responseSize);
            responseInfo.put("client", clientAddress);
            responseInfo.put("class", this.instance.getClass().getSimpleName());
            responseInfo.put("method", call.getMethodName());
            if (params.length == 2 && this.instance instanceof HRegionServer && params[0] instanceof byte[] && params[1] instanceof Operation) {
                byte[] tableName = HRegionInfo.parseRegionName((byte[])params[0])[0];
                responseInfo.put("table", Bytes.toStringBinary(tableName));
                responseInfo.putAll(((Operation)params[1]).toMap());
                LOG.warn((Object)("(operation" + tag + "): " + mapper.writeValueAsString(responseInfo)));
            } else if (params.length == 1 && this.instance instanceof HRegionServer && params[0] instanceof Operation) {
                responseInfo.putAll(((Operation)params[0]).toMap());
                LOG.warn((Object)("(operation" + tag + "): " + mapper.writeValueAsString(responseInfo)));
            } else {
                responseInfo.put("call", call.toString());
                LOG.warn((Object)("(response" + tag + "): " + mapper.writeValueAsString(responseInfo)));
            }
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private Class<? extends VersionedProtocol> protocol;
        private InetSocketAddress address;
        private User ticket;
        private HBaseClient client;
        private boolean isClosed = false;
        private final int rpcTimeout;

        public Invoker(Class<? extends VersionedProtocol> protocol, InetSocketAddress address, User ticket, Configuration conf, SocketFactory factory, int rpcTimeout) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.client = CLIENTS.getClient(conf, factory);
            this.rpcTimeout = rpcTimeout;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean logDebug = LOG.isDebugEnabled();
            long startTime = 0L;
            if (logDebug) {
                startTime = System.currentTimeMillis();
            }
            HbaseObjectWritable value = (HbaseObjectWritable)this.client.call((Writable)new Invocation(method, args), this.address, this.protocol, this.ticket, this.rpcTimeout);
            if (logDebug) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        protected synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, HBaseClient> clients = new HashMap<SocketFactory, HBaseClient>();

        protected ClientCache() {
        }

        protected synchronized HBaseClient getClient(Configuration conf, SocketFactory factory) {
            HBaseClient client = this.clients.get(factory);
            if (client == null) {
                client = new HBaseClient(HbaseObjectWritable.class, conf, factory);
                this.clients.put(factory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        protected synchronized HBaseClient getClient(Configuration conf) {
            return this.getClient(conf, SocketFactory.getDefault());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopClient(HBaseClient client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }
}

