/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class HFileOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, KeyValue> {
    static Log LOG = LogFactory.getLog(HFileOutputFormat.class);
    static final String COMPRESSION_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    TimeRangeTracker trt = new TimeRangeTracker();

    public RecordWriter<ImmutableBytesWritable, KeyValue> getRecordWriter(final TaskAttemptContext context) throws IOException, InterruptedException {
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        final Path outputdir = new FileOutputCommitter(outputPath, context).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x40000000L);
        final int blocksize = conf.getInt("hbase.mapreduce.hfileoutputformat.blocksize", 65536);
        final String defaultCompression = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        final Map<byte[], String> compressionMap = HFileOutputFormat.createFamilyCompressionMap(conf);
        return new RecordWriter<ImmutableBytesWritable, KeyValue>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final byte[] now = Bytes.toBytes(System.currentTimeMillis());
            private boolean rollRequested = false;

            public void write(ImmutableBytesWritable row, KeyValue kv) throws IOException {
                if (row == null && kv == null) {
                    this.rollWriters();
                    return;
                }
                byte[] rowKey = kv.getRow();
                long length = kv.getLength();
                byte[] family = kv.getFamily();
                WriterLength wl = this.writers.get(family);
                if (wl == null) {
                    fs.mkdirs(new Path(outputdir, Bytes.toString(family)));
                }
                if (wl != null && wl.written + length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo(this.previousRow, rowKey) != 0) {
                    this.rollWriters();
                }
                if (wl == null || wl.writer == null) {
                    wl = this.getNewWriter(family, conf);
                }
                kv.updateLatestStamp(this.now);
                HFileOutputFormat.this.trt.includeTimestamp(kv);
                wl.writer.append(kv);
                wl.written += length;
                this.previousRow = rowKey;
            }

            private void rollWriters() throws IOException {
                for (WriterLength wl : this.writers.values()) {
                    if (wl.writer != null) {
                        LOG.info((Object)("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written)));
                        this.close(wl.writer);
                    }
                    wl.writer = null;
                    wl.written = 0L;
                }
                this.rollRequested = false;
            }

            private WriterLength getNewWriter(byte[] family, Configuration conf2) throws IOException {
                WriterLength wl = new WriterLength();
                Path familydir = new Path(outputdir, Bytes.toString(family));
                String compression = (String)compressionMap.get(family);
                compression = compression == null ? defaultCompression : compression;
                wl.writer = HFile.getWriterFactory(conf2).createWriter(fs, StoreFile.getUniqueFile(fs, familydir), blocksize, compression, KeyValue.KEY_COMPARATOR);
                this.writers.put(family, wl);
                return wl;
            }

            private void close(HFile.Writer w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes(System.currentTimeMillis()));
                    w.appendFileInfo(StoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes(context.getTaskAttemptID().toString()));
                    w.appendFileInfo(StoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes(true));
                    w.appendFileInfo(StoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes(compactionExclude));
                    w.appendFileInfo(StoreFile.TIMERANGE_KEY, WritableUtils.toByteArray((Writable[])new Writable[]{HFileOutputFormat.this.trt}));
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals(HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary(first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);
        try {
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
        finally {
            writer.close();
        }
    }

    public static void configureIncrementalLoad(Job job, HTable table) throws IOException {
        URI cacheUri;
        Class<? extends Partitioner> topClass;
        Configuration conf = job.getConfiguration();
        try {
            topClass = HFileOutputFormat.getTotalOrderPartitionerClass();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed getting TotalOrderPartitioner", e);
        }
        job.setPartitionerClass(topClass);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        if (KeyValue.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(KeyValueSortReducer.class);
        } else if (Put.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else {
            LOG.warn((Object)("Unknown map output value type:" + job.getMapOutputValueClass()));
        }
        LOG.info((Object)("Looking up current regions for table " + table));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat.getRegionStartKeys(table);
        LOG.info((Object)("Configuring " + startKeys.size() + " reduce partitions " + "to match current region count"));
        job.setNumReduceTasks(startKeys.size());
        Path partitionsPath = new Path(job.getWorkingDirectory(), "partitions_" + System.currentTimeMillis());
        LOG.info((Object)("Writing partition information to " + partitionsPath));
        FileSystem fs = partitionsPath.getFileSystem(conf);
        HFileOutputFormat.writePartitions(conf, partitionsPath, startKeys);
        partitionsPath.makeQualified(fs);
        try {
            cacheUri = new URI(partitionsPath.toString() + "#" + "_partition.lst");
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        DistributedCache.addCacheFile((URI)cacheUri, (Configuration)conf);
        DistributedCache.createSymlink((Configuration)conf);
        HFileOutputFormat.configureCompression(table, conf);
        TableMapReduceUtil.addDependencyJars(job);
        LOG.info((Object)"Incremental table output configured.");
    }

    private static Class<? extends Partitioner> getTotalOrderPartitionerClass() throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner");
        }
        catch (ClassNotFoundException e) {
            clazz = Class.forName("org.apache.hadoop.hbase.mapreduce.hadoopbackport.TotalOrderPartitioner");
        }
        return clazz;
    }

    static Map<byte[], String> createFamilyCompressionMap(Configuration conf) {
        TreeMap<byte[], String> compressionMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String compressionConf = conf.get(COMPRESSION_CONF_KEY, "");
        for (String familyConf : compressionConf.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                compressionMap.put(URLDecoder.decode(familySplit[0], "UTF-8").getBytes(), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return compressionMap;
    }

    static void configureCompression(HTable table, Configuration conf) throws IOException {
        StringBuilder compressionConfigValue = new StringBuilder();
        HTableDescriptor tableDescriptor = table.getTableDescriptor();
        if (tableDescriptor == null) {
            return;
        }
        Collection<HColumnDescriptor> families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                compressionConfigValue.append('&');
            }
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            compressionConfigValue.append('=');
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getCompression().getName(), "UTF-8"));
        }
        conf.set(COMPRESSION_CONF_KEY, compressionConfigValue.toString());
    }

    static class WriterLength {
        long written = 0L;
        HFile.Writer writer = null;

        WriterLength() {
        }
    }
}

