/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class Import {
    static final String NAME = "import";
    public static final String CF_RENAME_PROP = "HBASE_IMPORTER_RENAME_CFS";

    public static void configureCfRenaming(Configuration conf, Map<String, String> renameMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : renameMap.entrySet()) {
            String sourceCf = entry.getKey();
            String destCf = entry.getValue();
            if (sourceCf.contains(":") || sourceCf.contains(",") || destCf.contains(":") || destCf.contains(",")) {
                throw new IllegalArgumentException("Illegal character in CF names: " + sourceCf + ", " + destCf);
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(sourceCf + ":" + destCf);
        }
        conf.set(CF_RENAME_PROP, sb.toString());
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path inputDir = new Path(args[1]);
        Job job = new Job(conf, "import_" + tableName);
        job.setJarByClass(Importer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapperClass(Importer.class);
        TableMapReduceUtil.initTableReducerJob(tableName, null, job);
        job.setNumReduceTasks(0);
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Import <tablename> <inputdir>");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Import.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        System.exit((job = Import.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class Importer
    extends TableMapper<ImmutableBytesWritable, Put> {
        private Map<byte[], byte[]> cfRenameMap;

        Importer() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                context.write((Object)row, (Object)this.resultToPut(row, value));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private Put resultToPut(ImmutableBytesWritable key, Result result) throws IOException {
            Put put = new Put(key.get());
            for (KeyValue kv : result.raw()) {
                byte[] newCfName;
                if (this.cfRenameMap != null && (newCfName = this.cfRenameMap.get(kv.getFamily())) != null) {
                    kv = new KeyValue(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), newCfName, 0, newCfName.length, kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getType()), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
                }
                put.add(kv);
            }
            return put;
        }

        public void setup(Mapper.Context context) {
            this.cfRenameMap = null;
            String allMappingsPropVal = context.getConfiguration().get(Import.CF_RENAME_PROP);
            if (allMappingsPropVal != null) {
                String[] allMappings;
                for (String mapping : allMappings = allMappingsPropVal.split(",")) {
                    String[] srcAndDest;
                    if (this.cfRenameMap == null) {
                        this.cfRenameMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
                    }
                    if ((srcAndDest = mapping.split(":")).length != 2) continue;
                    this.cfRenameMap.put(srcAndDest[0].getBytes(), srcAndDest[1].getBytes());
                }
            }
        }
    }
}

