/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LoadIncrementalHFiles
extends Configured
implements Tool {
    private static Log LOG = LogFactory.getLog(LoadIncrementalHFiles.class);
    private static final int TABLE_CREATE_MAX_RETRIES = 20;
    private static final long TABLE_CREATE_SLEEP = 60000L;
    static AtomicLong regionCount = new AtomicLong(0L);
    private HBaseAdmin hbAdmin;
    private Configuration cfg;
    public static String NAME = "completebulkload";

    public LoadIncrementalHFiles(Configuration conf) throws Exception {
        super(conf);
        this.cfg = conf;
        this.hbAdmin = new HBaseAdmin(conf);
    }

    private void usage() {
        System.err.println("usage: " + NAME + " /path/to/hfileoutputformat-output " + "tablename");
    }

    private void discoverLoadQueue(Deque<LoadQueueItem> ret, Path hfofDir) throws IOException {
        FileSystem fs = hfofDir.getFileSystem(this.getConf());
        if (!fs.exists(hfofDir)) {
            throw new FileNotFoundException("HFileOutputFormat dir " + hfofDir + " not found");
        }
        FileStatus[] familyDirStatuses = fs.listStatus(hfofDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + hfofDir);
        }
        for (FileStatus stat : familyDirStatuses) {
            Path[] hfiles;
            if (!stat.isDir()) {
                LOG.warn((Object)("Skipping non-directory " + stat.getPath()));
                continue;
            }
            Path familyDir = stat.getPath();
            if (familyDir.getName().startsWith("_")) continue;
            byte[] family = familyDir.getName().getBytes();
            for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(familyDir))) {
                if (hfile.getName().startsWith("_")) continue;
                ret.add(new LoadQueueItem(family, hfile));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void doBulkLoad(Path hfofDir, HTable table) throws TableNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void bulkLoadPhase(final HTable table, final HConnection conn, ExecutorService pool, Deque<LoadQueueItem> queue, Multimap<ByteBuffer, LoadQueueItem> regionGroups) throws IOException {
        HashSet<Future<List<LoadQueueItem>>> loadingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        for (Map.Entry entry : regionGroups.asMap().entrySet()) {
            final byte[] first = ((ByteBuffer)entry.getKey()).array();
            final Collection lqis = (Collection)entry.getValue();
            Callable<List<LoadQueueItem>> call = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> toRetry = LoadIncrementalHFiles.this.tryAtomicRegionLoad(conn, table.getTableName(), first, lqis);
                    return toRetry;
                }
            };
            loadingFutures.add(pool.submit(call));
        }
        for (Future future : loadingFutures) {
            try {
                List toRetry = (List)future.get();
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error((Object)"Unexpected execution exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error((Object)"Unexpected interrupted exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(e1);
            }
        }
    }

    private Multimap<ByteBuffer, LoadQueueItem> groupOrSplitPhase(final HTable table, ExecutorService pool, Deque<LoadQueueItem> queue, final Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        final Multimap regionGroups = Multimaps.synchronizedMultimap((Multimap)rgs);
        HashSet<Future<List<LoadQueueItem>>> splittingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        while (!queue.isEmpty()) {
            final LoadQueueItem item = queue.remove();
            Callable<List<LoadQueueItem>> callable = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> splits = LoadIncrementalHFiles.this.groupOrSplit((Multimap<ByteBuffer, LoadQueueItem>)regionGroups, item, table, startEndKeys);
                    return splits;
                }
            };
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                List splits = (List)future.get();
                if (splits == null) continue;
                queue.addAll(splits);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error((Object)"IOException during splitting", (Throwable)e1);
                    throw (IOException)t;
                }
                LOG.error((Object)"Unexpected execution exception during splitting", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error((Object)"Unexpected interrupted exception during splitting", (Throwable)e1);
                throw new IllegalStateException(e1);
            }
        }
        return regionGroups;
    }

    String getUniqueName(byte[] tableName) {
        String name = Bytes.toStringBinary(tableName) + "," + regionCount.incrementAndGet();
        return name;
    }

    protected List<LoadQueueItem> splitStoreFile(LoadQueueItem item, HTable table, byte[] startKey, byte[] splitKey) throws IOException {
        Path hfilePath = item.hfilePath;
        Path tmpDir = new Path(item.hfilePath.getParent(), "_tmp");
        LOG.info((Object)("HFile at " + hfilePath + " no longer fits inside a single " + "region. Splitting..."));
        String uniqueName = this.getUniqueName(table.getTableName());
        HColumnDescriptor familyDesc = table.getTableDescriptor().getFamily(item.family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        LoadIncrementalHFiles.splitStoreFile(this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        ArrayList<LoadQueueItem> lqis = new ArrayList<LoadQueueItem>(2);
        lqis.add(new LoadQueueItem(item.family, botOut));
        lqis.add(new LoadQueueItem(item.family, topOut));
        LOG.info((Object)("Successfully split into new HFiles " + botOut + " and " + topOut));
        return lqis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadQueueItem> regionGroups, LoadQueueItem item, HTable table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        byte[] last;
        byte[] first;
        Path hfilePath = item.hfilePath;
        FileSystem fs = hfilePath.getFileSystem(this.getConf());
        HFile.Reader hfr = HFile.createReader(fs, hfilePath, new CacheConfig(this.getConf()));
        try {
            hfr.loadFileInfo();
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        finally {
            hfr.close();
        }
        LOG.info((Object)("Trying to load hfile=" + hfilePath + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last)));
        if (first == null || last == null) {
            assert (first == null && last == null);
            LOG.info((Object)("hfile " + hfilePath + " has no entries, skipping"));
            return null;
        }
        if (Bytes.compareTo(first, last) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(first) + " > " + Bytes.toStringBinary(last));
        }
        int idx = Arrays.binarySearch((Object[])startEndKeys.getFirst(), first, Bytes.BYTES_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        int indexForCallable = idx;
        boolean bl = lastKeyInRange = Bytes.compareTo(last, startEndKeys.getSecond()[idx]) < 0 || Bytes.equals(startEndKeys.getSecond()[idx], HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            List<LoadQueueItem> lqis = this.splitStoreFile(item, table, startEndKeys.getFirst()[indexForCallable], startEndKeys.getSecond()[indexForCallable]);
            return lqis;
        }
        regionGroups.put((Object)ByteBuffer.wrap(startEndKeys.getFirst()[idx]), (Object)item);
        return null;
    }

    protected List<LoadQueueItem> tryAtomicRegionLoad(HConnection conn, byte[] tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        final ArrayList<Pair<byte[], String>> famPaths = new ArrayList<Pair<byte[], String>>(lqis.size());
        for (LoadQueueItem lqi : lqis) {
            famPaths.add(Pair.newPair(lqi.family, lqi.hfilePath.toString()));
        }
        ServerCallable<Boolean> svrCallable = new ServerCallable<Boolean>(conn, tableName, first){

            @Override
            public Boolean call() throws Exception {
                LOG.debug((Object)("Going to connect to server " + this.location + " for row " + Bytes.toStringBinary(this.row)));
                byte[] regionName = this.location.getRegionInfo().getRegionName();
                return this.server.bulkLoadHFiles(famPaths, regionName);
            }
        };
        try {
            ArrayList<LoadQueueItem> toRetry = new ArrayList<LoadQueueItem>();
            boolean success = conn.getRegionServerWithRetries(svrCallable);
            if (!success) {
                LOG.warn((Object)("Attempt to bulk load region containing " + Bytes.toStringBinary(first) + " into table " + Bytes.toStringBinary(tableName) + " with files " + lqis + " failed.  This is recoverable and they will be retried."));
                toRetry.addAll(lqis);
            }
            return toRetry;
        }
        catch (IOException e) {
            LOG.error((Object)"Encountered unrecoverable error from region server", (Throwable)e);
            throw e;
        }
    }

    static void splitStoreFile(Configuration conf, Path inFile, HColumnDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = new Reference(splitKey, Reference.Range.top);
        Reference bottomReference = new Reference(splitKey, Reference.Range.bottom);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, HColumnDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HalfStoreFileReader halfReader = null;
        StoreFile.Writer halfWriter = null;
        try {
            halfReader = new HalfStoreFileReader(fs, inFile, cacheConf, reference);
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompression();
            StoreFile.BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            halfWriter = new StoreFile.Writer(fs, outFile, blocksize, compression, conf, cacheConf, KeyValue.COMPARATOR, bloomFilterType, 0L);
            HFileScanner scanner = halfReader.getScanner(false, false);
            scanner.seekTo();
            do {
                KeyValue kv = scanner.getKeyValue();
                halfWriter.append(kv);
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfWriter != null) {
                halfWriter.close();
            }
            if (halfReader != null) {
                halfReader.close(cacheConf.shouldEvictOnClose());
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        return !HFile.isReservedFileInfoKey(key);
    }

    private boolean doesTableExist(String tableName) throws Exception {
        return this.hbAdmin.tableExists(tableName);
    }

    public static byte[][] inferBoundaries(TreeMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(String tableName, String dirPath) throws Exception {
        Path hfofDir = new Path(dirPath);
        FileSystem fs = hfofDir.getFileSystem(this.getConf());
        if (!fs.exists(hfofDir)) {
            throw new FileNotFoundException("HFileOutputFormat dir " + hfofDir + " not found");
        }
        FileStatus[] familyDirStatuses = fs.listStatus(hfofDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + hfofDir);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = null;
        byte[][] keys = null;
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (FileStatus stat : familyDirStatuses) {
            Path[] hfiles;
            if (!stat.isDir()) {
                LOG.warn((Object)("Skipping non-directory " + stat.getPath()));
                continue;
            }
            Path familyDir = stat.getPath();
            if (familyDir.getName().startsWith("_")) continue;
            byte[] family = familyDir.getName().getBytes();
            hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
            for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(familyDir))) {
                if (hfile.getName().startsWith("_")) continue;
                HFile.Reader reader = HFile.createReader(fs, hfile, new CacheConfig(this.getConf()));
                try {
                    reader.loadFileInfo();
                    byte[] first = reader.getFirstRowKey();
                    byte[] last = reader.getLastRowKey();
                    LOG.info((Object)("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last)));
                    Integer value = map.containsKey(first) ? map.get(first) : 0;
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? map.get(last) : 0;
                    map.put(last, value - 1);
                }
                finally {
                    reader.close();
                }
            }
        }
        keys = LoadIncrementalHFiles.inferBoundaries(map);
        this.hbAdmin.createTable(htd, keys);
        LOG.info((Object)("Table " + tableName + " is available!!"));
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.usage();
            return -1;
        }
        String dirPath = args[0];
        String tableName = args[1];
        boolean tableExists = this.doesTableExist(tableName);
        if (!tableExists) {
            this.createTable(tableName, dirPath);
        }
        Path hfofDir = new Path(dirPath);
        HTable table = new HTable(this.cfg, tableName);
        this.doBulkLoad(hfofDir, table);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new LoadIncrementalHFiles(HBaseConfiguration.create()), (String[])args);
        System.exit(ret);
    }

    static class LoadQueueItem {
        final byte[] family;
        final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }

        public String toString() {
            return "family:" + Bytes.toString(this.family) + " path:" + this.hfilePath.toString();
        }
    }
}

