/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class TableSplit
extends InputSplit
implements Writable,
Comparable<TableSplit> {
    private byte[] tableName;
    private byte[] startRow;
    private byte[] endRow;
    private String regionLocation;

    public TableSplit() {
        this(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, "");
    }

    public TableSplit(byte[] tableName, byte[] startRow, byte[] endRow, String location) {
        this.tableName = tableName;
        this.startRow = startRow;
        this.endRow = endRow;
        this.regionLocation = location;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getEndRow() {
        return this.endRow;
    }

    public String getRegionLocation() {
        return this.regionLocation;
    }

    public String[] getLocations() {
        return new String[]{this.regionLocation};
    }

    public long getLength() {
        return 0L;
    }

    public void readFields(DataInput in) throws IOException {
        this.tableName = Bytes.readByteArray(in);
        this.startRow = Bytes.readByteArray(in);
        this.endRow = Bytes.readByteArray(in);
        this.regionLocation = Bytes.toString(Bytes.readByteArray(in));
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.tableName);
        Bytes.writeByteArray(out, this.startRow);
        Bytes.writeByteArray(out, this.endRow);
        Bytes.writeByteArray(out, Bytes.toBytes(this.regionLocation));
    }

    public String toString() {
        return this.regionLocation + ":" + Bytes.toStringBinary(this.startRow) + "," + Bytes.toStringBinary(this.endRow);
    }

    @Override
    public int compareTo(TableSplit split) {
        return Bytes.compareTo(this.getStartRow(), split.getStartRow());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplit)) {
            return false;
        }
        return Bytes.equals(this.tableName, ((TableSplit)o).tableName) && Bytes.equals(this.startRow, ((TableSplit)o).startRow) && Bytes.equals(this.endRow, ((TableSplit)o).endRow) && this.regionLocation.equals(((TableSplit)o).regionLocation);
    }

    public int hashCode() {
        int result = this.tableName != null ? Arrays.hashCode(this.tableName) : 0;
        result = 31 * result + (this.startRow != null ? Arrays.hashCode(this.startRow) : 0);
        result = 31 * result + (this.endRow != null ? Arrays.hashCode(this.endRow) : 0);
        result = 31 * result + (this.regionLocation != null ? this.regionLocation.hashCode() : 0);
        return result;
    }
}

