/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class TsvImporterMapper
extends Mapper<LongWritable, Text, ImmutableBytesWritable, Put> {
    private long ts;
    private String separator;
    private boolean skipBadLines;
    private Counter badLineCount;
    private ImportTsv.TsvParser parser;

    public long getTs() {
        return this.ts;
    }

    public boolean getSkipBadLines() {
        return this.skipBadLines;
    }

    public Counter getBadLineCount() {
        return this.badLineCount;
    }

    public void incrementBadLineCount(int count) {
        this.badLineCount.increment((long)count);
    }

    protected void setup(Mapper.Context context) {
        this.doSetup(context);
        Configuration conf = context.getConfiguration();
        this.parser = new ImportTsv.TsvParser(conf.get("importtsv.columns"), this.separator);
        if (this.parser.getRowKeyColumnIndex() == -1) {
            throw new RuntimeException("No row key column specified");
        }
    }

    protected void doSetup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.separator = conf.get("importtsv.separator");
        this.separator = this.separator == null ? "\t" : new String(Base64.decode(this.separator));
        this.ts = conf.getLong("importtsv.timestamp", System.currentTimeMillis());
        this.skipBadLines = context.getConfiguration().getBoolean("importtsv.skip.bad.lines", true);
        this.badLineCount = context.getCounter("ImportTsv", "Bad Lines");
    }

    public void map(LongWritable offset, Text value, Mapper.Context context) throws IOException {
        byte[] lineBytes = value.getBytes();
        try {
            ImportTsv.TsvParser.ParsedLine parsed = this.parser.parse(lineBytes, value.getLength());
            ImmutableBytesWritable rowKey = new ImmutableBytesWritable(lineBytes, parsed.getRowKeyOffset(), parsed.getRowKeyLength());
            Put put = new Put(rowKey.copyBytes());
            for (int i = 0; i < parsed.getColumnCount(); ++i) {
                if (i == this.parser.getRowKeyColumnIndex()) continue;
                KeyValue kv = new KeyValue(lineBytes, parsed.getRowKeyOffset(), parsed.getRowKeyLength(), this.parser.getFamily(i), 0, this.parser.getFamily(i).length, this.parser.getQualifier(i), 0, this.parser.getQualifier(i).length, this.ts, KeyValue.Type.Put, lineBytes, parsed.getColumnOffset(i), parsed.getColumnLength(i));
                put.add(kv);
            }
            context.write((Object)rowKey, (Object)put);
        }
        catch (ImportTsv.TsvParser.BadTsvLineException badLine) {
            if (this.skipBadLines) {
                System.err.println("Bad line at offset: " + offset.get() + ":\n" + badLine.getMessage());
                this.incrementBadLineCount(1);
                return;
            }
            throw new IOException(badLine);
        }
        catch (IllegalArgumentException e) {
            if (this.skipBadLines) {
                System.err.println("Bad line at offset: " + offset.get() + ":\n" + e.getMessage());
                this.incrementBadLineCount(1);
                return;
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

