/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce.replication;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.zookeeper.KeeperException;

public class VerifyReplication {
    private static final Log LOG = LogFactory.getLog(VerifyReplication.class);
    public static final String NAME = "verifyrep";
    static long startTime = 0L;
    static long endTime = 0L;
    static String tableName = null;
    static String families = null;
    static String peerId = null;

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (!VerifyReplication.doCommandLine(args)) {
            return null;
        }
        if (!conf.getBoolean("hbase.replication", false)) {
            throw new IOException("Replication needs to be enabled to verify it.");
        }
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(conf){

            @Override
            public Void connect(HConnection conn) throws IOException {
                try {
                    ReplicationZookeeper zk = new ReplicationZookeeper(conn, this.conf, conn.getZooKeeperWatcher());
                    ReplicationPeer peer = zk.getPeer(peerId);
                    if (peer == null) {
                        throw new IOException("Couldn't get access to the slave cluster,please see the log");
                    }
                }
                catch (KeeperException ex) {
                    throw new IOException("Couldn't get access to the slave cluster because: ", ex);
                }
                return null;
            }
        });
        conf.set("verifyrep.peerId", peerId);
        conf.set("verifyrep.tableName", tableName);
        conf.setLong("verifyrep.startTime", startTime);
        conf.setLong("verifyrep.endTime", endTime);
        if (families != null) {
            conf.set("verifyrep.families", families);
        }
        Job job = new Job(conf, "verifyrep_" + tableName);
        job.setJarByClass(VerifyReplication.class);
        Scan scan = new Scan();
        if (startTime != 0L) {
            scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        }
        if (families != null) {
            String[] fams;
            for (String fam : fams = families.split(",")) {
                scan.addFamily(Bytes.toBytes(fam));
            }
        }
        TableMapReduceUtil.initTableMapperJob(tableName, scan, Verifier.class, null, null, job);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 2) {
            VerifyReplication.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    VerifyReplication.printUsage(null);
                    return false;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    startTime = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    endTime = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    families = cmd.substring("--families=".length());
                    continue;
                }
                if (i == args.length - 2) {
                    peerId = cmd;
                }
                if (i != args.length - 1) continue;
                tableName = cmd;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            VerifyReplication.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: verifyrep [--starttime=X] [--stoptime=Y] [--families=A] <peerid> <tablename>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" starttime    beginning of the time range");
        System.err.println("              without endtime means from starttime to forever");
        System.err.println(" stoptime     end of the time range");
        System.err.println(" families     comma-separated list of families to copy");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" peerid       Id of the peer used for verification, must match the one given for replication");
        System.err.println(" tablename    Name of the table to verify");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To verify the data replicated from TestTable for a 1 hour window with peer #5 ");
        System.err.println(" $ bin/hbase org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication --starttime=1265875194289 --stoptime=1265878794289 5 TestTable ");
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Job job = VerifyReplication.createSubmittableJob(conf, args);
        if (job != null) {
            System.exit(job.waitForCompletion(true) ? 0 : 1);
        }
    }

    public static class Verifier
    extends TableMapper<ImmutableBytesWritable, Put> {
        private ResultScanner replicatedScanner;

        public void map(ImmutableBytesWritable row, final Result value, Mapper.Context context) throws IOException {
            if (this.replicatedScanner == null) {
                Configuration conf = context.getConfiguration();
                final Scan scan = new Scan();
                scan.setCaching(conf.getInt("hbase.mapreduce.scan.cachedrows", 1));
                long startTime = conf.getLong("verifyrep.startTime", 0L);
                long endTime = conf.getLong("verifyrep.endTime", 0L);
                String families = conf.get("verifyrep.families", null);
                if (families != null) {
                    String[] fams;
                    for (String fam : fams = families.split(",")) {
                        scan.addFamily(Bytes.toBytes(fam));
                    }
                }
                if (startTime != 0L) {
                    scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
                }
                HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(conf){

                    @Override
                    public Void connect(HConnection conn) throws IOException {
                        try {
                            ReplicationZookeeper zk = new ReplicationZookeeper(conn, this.conf, conn.getZooKeeperWatcher());
                            ReplicationPeer peer = zk.getPeer(this.conf.get("verifyrep.peerId"));
                            HTable replicatedTable = new HTable(peer.getConfiguration(), this.conf.get("verifyrep.tableName"));
                            scan.setStartRow(value.getRow());
                            Verifier.this.replicatedScanner = replicatedTable.getScanner(scan);
                        }
                        catch (KeeperException e) {
                            throw new IOException("Got a ZK exception", e);
                        }
                        return null;
                    }
                });
            }
            Result res = this.replicatedScanner.next();
            try {
                Result.compareResults(value, res);
                context.getCounter((Enum)Counters.GOODROWS).increment(1L);
            }
            catch (Exception e) {
                LOG.warn((Object)"Bad row", (Throwable)e);
                context.getCounter((Enum)Counters.BADROWS).increment(1L);
            }
        }

        protected void cleanup(Mapper.Context context) {
            this.replicatedScanner.close();
        }

        public static enum Counters {
            GOODROWS,
            BADROWS;

        }
    }
}

