/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaMigrationRemovingHTD;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.LogCleaner;
import org.apache.hadoop.hbase.master.MXBeanImpl;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.ModifyTableHandler;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.master.handler.TableAddFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableDeleteFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableModifyFamilyHandler;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ClusterId;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.DrainingServerTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNS;
import org.apache.zookeeper.KeeperException;

public class HMaster
extends HasThread
implements HMasterInterface,
HMasterRegionInterface,
MasterServices,
Server {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final Configuration conf;
    private InfoServer infoServer;
    private ZooKeeperWatcher zooKeeper;
    private ActiveMasterManager activeMasterManager;
    private RegionServerTracker regionServerTracker;
    private DrainingServerTracker drainingServerTracker;
    private final RpcServer rpcServer;
    private final InetSocketAddress isa;
    private final MasterMetrics metrics;
    private MasterFileSystem fileSystemManager;
    private ServerManager serverManager;
    AssignmentManager assignmentManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean stopped = false;
    private volatile boolean abort = false;
    private volatile boolean isActiveMaster = false;
    private volatile boolean initialized = false;
    org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private LoadBalancer balancer;
    private Thread balancerChore;
    private volatile boolean balanceSwitch = true;
    private CatalogJanitor catalogJanitorChore;
    private LogCleaner logCleaner;
    private MasterCoprocessorHost cpHost;
    private final ServerName serverName;
    private TableDescriptors tableDescriptors;
    private long masterStartTime;
    private long masterActiveTime;
    private ObjectName mxBean = null;

    public HMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
        this.conf = new Configuration(conf);
        this.conf.setFloat("hfile.block.cache.size", 0.0f);
        HConnectionManager.setServerSideHConnectionRetries(this.conf, LOG);
        String hostname = DNS.getDefaultHost((String)conf.get("hbase.master.dns.interface", "default"), (String)conf.get("hbase.master.dns.nameserver", "default"));
        int port = conf.getInt("hbase.master.port", 60000);
        InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + this.isa);
        }
        int numHandlers = conf.getInt("hbase.master.handler.count", conf.getInt("hbase.regionserver.handler.count", 25));
        this.rpcServer = HBaseRPC.getServer(this, new Class[]{HMasterInterface.class, HMasterRegionInterface.class}, initialIsa.getHostName(), initialIsa.getPort(), numHandlers, 0, conf.getBoolean("hbase.rpc.verbose", false), conf, 0);
        this.isa = this.rpcServer.getListenerAddress();
        this.serverName = new ServerName(this.isa.getHostName(), this.isa.getPort(), System.currentTimeMillis());
        this.rsFatals = new MemoryBoundedLogMessageBuffer(conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
        User.login(conf, "hbase.master.keytab.file", "hbase.master.kerberos.principal", this.isa.getHostName());
        this.setName("master-" + this.serverName.toString());
        Replication.decorateMasterConfiguration(this.conf);
        if (this.conf.get("mapred.task.id") == null) {
            this.conf.set("mapred.task.id", "hb_m_" + this.serverName.toString());
        }
        this.zooKeeper = new ZooKeeperWatcher(conf, "master:" + this.isa.getPort(), this, true);
        this.rpcServer.startThreads();
        this.metrics = new MasterMetrics(this.getServerName().toString());
    }

    private static void stallIfBackupMaster(Configuration c, ActiveMasterManager amm) throws InterruptedException {
        if (!c.getBoolean("hbase.master.backup", false)) {
            return;
        }
        LOG.debug((Object)"HMaster started in backup mode.  Stalling until master znode is written.");
        while (!amm.isActiveMaster()) {
            LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
            Thread.sleep(c.getInt("zookeeper.session.timeout", 180000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MonitoredTask startupStatus = TaskMonitor.get().createStatus("Master startup");
        startupStatus.setDescription("Master startup");
        this.masterStartTime = System.currentTimeMillis();
        try {
            this.becomeActiveMaster(startupStatus);
            if (!this.stopped) {
                this.finishInitialization(startupStatus);
                this.loop();
            }
        }
        catch (Throwable t) {
            this.abort("Unhandled exception. Starting shutdown.", t);
        }
        finally {
            startupStatus.cleanup();
            this.stopChores();
            if (!this.abort && this.serverManager != null && this.serverManager.isClusterShutdown()) {
                this.serverManager.letRegionServersShutdown();
            }
            this.stopServiceThreads();
            if (this.activeMasterManager != null) {
                this.activeMasterManager.stop();
            }
            if (this.catalogTracker != null) {
                this.catalogTracker.stop();
            }
            if (this.serverManager != null) {
                this.serverManager.stop();
            }
            if (this.assignmentManager != null) {
                this.assignmentManager.stop();
            }
            if (this.fileSystemManager != null) {
                this.fileSystemManager.stop();
            }
            this.zooKeeper.close();
        }
        LOG.info((Object)"HMaster main thread exiting");
    }

    private boolean becomeActiveMaster(MonitoredTask startupStatus) throws InterruptedException {
        this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.serverName, this);
        this.zooKeeper.registerListener(this.activeMasterManager);
        HMaster.stallIfBackupMaster(this.conf, this.activeMasterManager);
        this.clusterStatusTracker = new ClusterStatusTracker(this.getZooKeeper(), this);
        this.clusterStatusTracker.start();
        return this.activeMasterManager.blockUntilBecomingActiveMaster(startupStatus, this.clusterStatusTracker);
    }

    private void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException {
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.conf, this, this.conf.getInt("hbase.master.catalog.timeout", Integer.MAX_VALUE));
        this.catalogTracker.start();
        this.assignmentManager = new AssignmentManager(this, this.serverManager, this.catalogTracker, this.executorService);
        this.balancer = LoadBalancerFactory.getLoadBalancer(this.conf);
        this.zooKeeper.registerListenerFirst(this.assignmentManager);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start();
        this.drainingServerTracker = new DrainingServerTracker(this.zooKeeper, this, this.serverManager);
        this.drainingServerTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master; " + this.serverName + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()) + ", cluster-up flag was=" + wasUp));
    }

    private void loop() {
        Sleeper sleeper = new Sleeper(1000, this);
        while (!this.stopped) {
            sleeper.sleep();
        }
    }

    private void finishInitialization(MonitoredTask status) throws IOException, InterruptedException, KeeperException {
        this.isActiveMaster = true;
        status.setStatus("Initializing Master file system");
        this.masterActiveTime = System.currentTimeMillis();
        this.fileSystemManager = new MasterFileSystem(this, this, this.metrics);
        this.tableDescriptors = new FSTableDescriptors(this.fileSystemManager.getFileSystem(), this.fileSystemManager.getRootDir());
        status.setStatus("Publishing Cluster ID in ZooKeeper");
        ClusterId.setClusterId(this.zooKeeper, this.fileSystemManager.getClusterId());
        this.executorService = new org.apache.hadoop.hbase.executor.ExecutorService(this.getServerName().toString());
        this.serverManager = new ServerManager(this, this);
        status.setStatus("Initializing ZK system trackers");
        this.initializeZKBasedSystemTrackers();
        status.setStatus("Initializing master coprocessors");
        this.cpHost = new MasterCoprocessorHost(this, this.conf);
        status.setStatus("Initializing master service threads");
        this.startServiceThreads();
        this.serverManager.waitForRegionServers(status);
        for (ServerName sn : this.regionServerTracker.getOnlineServers()) {
            if (this.serverManager.isServerOnline(sn)) continue;
            LOG.info((Object)("Registering server found up in zk but who has not yet reported in: " + sn));
            this.serverManager.recordNewServer(sn, HServerLoad.EMPTY_HSERVERLOAD);
        }
        status.setStatus("Splitting logs after master startup");
        this.fileSystemManager.splitLogAfterStartup(this.serverManager.getOnlineServers().keySet());
        this.assignRootAndMeta(status);
        MetaMigrationRemovingHTD.updateMetaWithNewHRI(this);
        status.setStatus("Starting assignment manager");
        this.assignmentManager.joinCluster();
        this.balancer.setClusterStatus(this.getClusterStatus());
        this.balancer.setMasterServices(this);
        status.setStatus("Fixing up missing daughters");
        this.fixupDaughters(status);
        status.setStatus("Starting balancer and catalog janitor");
        this.balancerChore = HMaster.getAndStartBalancerChore(this);
        this.catalogJanitorChore = new CatalogJanitor(this, this);
        Threads.setDaemonThreadRunning(this.catalogJanitorChore.getThread());
        this.registerMBean();
        status.markComplete("Initialization successful");
        LOG.info((Object)"Master has completed initialization");
        this.initialized = true;
        if (this.cpHost != null) {
            try {
                this.cpHost.postStartMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Coprocessor postStartMaster() hook failed", (Throwable)ioe);
            }
        }
    }

    int assignRootAndMeta(MonitoredTask status) throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        status.setStatus("Assigning ROOT region");
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.ROOT_REGIONINFO);
        ServerName expiredServer = null;
        if (!this.catalogTracker.verifyRootRegionLocation(timeout)) {
            ServerName currentRootServer = this.catalogTracker.getRootLocation();
            if (this.expireIfOnline(currentRootServer)) {
                expiredServer = currentRootServer;
            } else {
                this.assignmentManager.assignRoot();
            }
            this.catalogTracker.waitForRoot();
            this.assignmentManager.waitForAssignment(HRegionInfo.ROOT_REGIONINFO);
            ++assigned;
        } else {
            this.assignmentManager.regionOnline(HRegionInfo.ROOT_REGIONINFO, this.catalogTracker.getRootLocation());
        }
        LOG.info((Object)("-ROOT- assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getRootLocation()));
        status.setStatus("Assigning META region");
        rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.FIRST_META_REGIONINFO);
        if (!this.catalogTracker.verifyMetaRegionLocation(timeout)) {
            ServerName currentMetaServer = this.catalogTracker.getMetaLocationOrReadLocationFromRoot();
            if (currentMetaServer != null && currentMetaServer.equals(expiredServer)) {
                this.expireIfOnline(currentMetaServer);
            } else {
                this.assignmentManager.assignMeta();
            }
            this.catalogTracker.waitForMeta();
            this.assignmentManager.waitForAssignment(HRegionInfo.FIRST_META_REGIONINFO);
            ++assigned;
        } else {
            this.assignmentManager.regionOnline(HRegionInfo.FIRST_META_REGIONINFO, this.catalogTracker.getMetaLocation());
        }
        LOG.info((Object)(".META. assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getMetaLocation()));
        status.setStatus("META and ROOT assigned.");
        return assigned;
    }

    void fixupDaughters(MonitoredTask status) throws IOException {
        final HashMap offlineSplitParents = new HashMap();
        MetaReader.Visitor visitor = new MetaReader.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                HRegionInfo info = MetaReader.parseHRegionInfoFromCatalogResult(r, HConstants.REGIONINFO_QUALIFIER);
                if (info == null) {
                    return true;
                }
                if (info.isOffline() && info.isSplit()) {
                    offlineSplitParents.put(info, r);
                }
                return true;
            }
        };
        MetaReader.fullScan(this.catalogTracker, visitor);
        int fixups = 0;
        for (Map.Entry e : offlineSplitParents.entrySet()) {
            fixups += ServerShutdownHandler.fixupDaughters((Result)e.getValue(), this.assignmentManager, this.catalogTracker);
        }
        if (fixups != 0) {
            LOG.info((Object)("Scanned the catalog and fixed up " + fixups + " missing daughter region(s)"));
        }
    }

    private boolean expireIfOnline(ServerName sn) {
        if (sn == null) {
            return false;
        }
        if (!this.serverManager.isServerOnline(sn)) {
            return false;
        }
        LOG.info((Object)("Forcing expiration of " + sn));
        this.serverManager.expireServer(sn);
        return true;
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long version, int clientMethodsHashCode) throws IOException {
        if (HMasterInterface.class.getName().equals(protocol)) {
            return new ProtocolSignature(29L, null);
        }
        if (HMasterRegionInterface.class.getName().equals(protocol)) {
            return new ProtocolSignature(29L, null);
        }
        throw new IOException("Unknown protocol: " + protocol);
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        if (HMasterInterface.class.getName().equals(protocol)) {
            return 29L;
        }
        if (HMasterRegionInterface.class.getName().equals(protocol)) {
            return 29L;
        }
        LOG.warn((Object)("Version requested for unimplemented protocol: " + protocol));
        return -1L;
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public org.apache.hadoop.hbase.executor.ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    private void startServiceThreads() throws IOException {
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 3));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        String n = Thread.currentThread().getName();
        this.logCleaner = new LogCleaner(this.conf.getInt("hbase.master.cleaner.interval", 60000), this, this.conf, this.getMasterFileSystem().getFileSystem(), this.getMasterFileSystem().getOldLogDir());
        Threads.setDaemonThreadRunning(this.logCleaner.getThread(), n + ".oldLogCleaner");
        int port = this.conf.getInt("hbase.master.info.port", 60010);
        if (port >= 0) {
            String a = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
            this.infoServer = new InfoServer(MASTER, a, port, false, this.conf);
            this.infoServer.addServlet("status", "/master-status", MasterStatusServlet.class);
            this.infoServer.addServlet("dump", "/dump", MasterDumpServlet.class);
            this.infoServer.setAttribute(MASTER, this);
            this.infoServer.start();
        }
        this.rpcServer.openServer();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Started service threads");
        }
    }

    private void stopServiceThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.logCleaner != null) {
            this.logCleaner.interrupt();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private static Thread getAndStartBalancerChore(final HMaster master) {
        String name = master.getServerName() + "-BalancerChore";
        int balancerPeriod = master.getConfiguration().getInt("hbase.balancer.period", 300000);
        Chore chore = new Chore(name, balancerPeriod, master){

            @Override
            protected void chore() {
                master.balance();
            }
        };
        return Threads.setDaemonThreadRunning(chore.getThread());
    }

    private void stopChores() {
        if (this.balancerChore != null) {
            this.balancerChore.interrupt();
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.interrupt();
        }
    }

    @Override
    public MapWritable regionServerStartup(int port, long serverStartCode, long serverCurrentTime) throws IOException {
        InetAddress ia = HBaseServer.getRemoteIp();
        ServerName rs = this.serverManager.regionServerStartup(ia, port, serverStartCode, serverCurrentTime);
        MapWritable mw = this.createConfigurationSubset();
        mw.put((Writable)new Text("hbase.regionserver.hostname.seen.by.master"), (Writable)new Text(rs.getHostname()));
        return mw;
    }

    protected MapWritable createConfigurationSubset() {
        MapWritable mw = this.addConfig(new MapWritable(), "hbase.rootdir");
        return this.addConfig(mw, "fs.default.name");
    }

    private MapWritable addConfig(MapWritable mw, String key) {
        mw.put((Writable)new Text(key), (Writable)new Text(this.conf.get(key)));
        return mw;
    }

    @Override
    public void regionServerReport(byte[] sn, HServerLoad hsl) throws IOException {
        this.serverManager.regionServerReport(ServerName.parseVersionedServerName(sn), hsl);
        if (hsl != null && this.metrics != null) {
            this.metrics.incrementRequests(hsl.getTotalNumberOfRequests());
        }
    }

    @Override
    public void reportRSFatalError(byte[] sn, String errorText) {
        String msg = "Region server " + Bytes.toString(sn) + " reported a fatal error:\n" + errorText;
        LOG.error((Object)msg);
        this.rsFatals.add(msg);
    }

    @Override
    public boolean isMasterRunning() {
        return !this.isStopped();
    }

    private int getBalancerCutoffTime() {
        int balancerPeriod;
        int balancerCutoffTime = this.getConfiguration().getInt("hbase.balancer.max.balancing", -1);
        if (balancerCutoffTime == -1 && (balancerCutoffTime = (balancerPeriod = this.getConfiguration().getInt("hbase.balancer.period", 300000)) / 2) <= 0) {
            balancerCutoffTime = balancerPeriod;
        }
        return balancerCutoffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean balance() {
        boolean balancerRan;
        if (!this.balanceSwitch) {
            return false;
        }
        int maximumBalanceTime = this.getBalancerCutoffTime();
        long cutoffTime = System.currentTimeMillis() + (long)maximumBalanceTime;
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (this.assignmentManager.isRegionsInTransition()) {
                LOG.debug((Object)("Not running balancer because " + this.assignmentManager.getRegionsInTransition().size() + " region(s) in transition: " + StringUtils.abbreviate((String)this.assignmentManager.getRegionsInTransition().toString(), (int)256)));
                return false;
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.debug((Object)("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers()));
                return false;
            }
            if (this.cpHost != null) {
                try {
                    if (this.cpHost.preBalance()) {
                        LOG.debug((Object)"Coprocessor bypassing balancer request");
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor preBalance()", (Throwable)ioe);
                    return false;
                }
            }
            Map<ServerName, List<HRegionInfo>> assignments = this.assignmentManager.getAssignments();
            for (Map.Entry<ServerName, HServerLoad> e : this.serverManager.getOnlineServers().entrySet()) {
                if (assignments.containsKey(e.getKey())) continue;
                assignments.put(e.getKey(), new ArrayList());
            }
            List<RegionPlan> plans = this.balancer.balanceCluster(assignments);
            int rpCount = 0;
            long totalRegPlanExecTime = 0L;
            boolean bl = balancerRan = plans != null;
            if (plans != null && !plans.isEmpty()) {
                for (RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    long balStartTime = System.currentTimeMillis();
                    this.assignmentManager.balance(plan);
                    if (++rpCount >= plans.size() || System.currentTimeMillis() + (totalRegPlanExecTime += System.currentTimeMillis() - balStartTime) / (long)rpCount <= cutoffTime) continue;
                    LOG.debug((Object)("No more balancing till next balance run; maximumBalanceTime=" + maximumBalanceTime));
                    break;
                }
            }
            if (this.cpHost != null) {
                try {
                    this.cpHost.postBalance();
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor postBalance()", (Throwable)ioe);
                }
            }
        }
        return balancerRan;
    }

    @Override
    public boolean balanceSwitch(boolean b) {
        boolean oldValue = this.balanceSwitch;
        boolean newValue = b;
        try {
            if (this.cpHost != null) {
                newValue = this.cpHost.preBalanceSwitch(newValue);
            }
            this.balanceSwitch = newValue;
            LOG.info((Object)("Balance=" + newValue));
            if (this.cpHost != null) {
                this.cpHost.postBalanceSwitch(oldValue, newValue);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    public void setCatalogJanitorEnabled(boolean b) {
        this.catalogJanitorChore.setEnabled(b);
    }

    @Override
    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException {
        Pair<HRegionInfo, ServerName> p = this.assignmentManager.getAssignment(encodedRegionName);
        if (p == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(encodedRegionName));
        }
        HRegionInfo hri = p.getFirst();
        ServerName dest = null;
        if (destServerName == null || destServerName.length == 0) {
            LOG.info((Object)"Passed destination servername is null/empty so choosing a server at random");
            this.assignmentManager.clearRegionPlan(hri);
            this.assignmentManager.unassign(hri);
        } else {
            dest = new ServerName(Bytes.toString(destServerName));
            try {
                if (this.cpHost != null && this.cpHost.preMove(p.getFirst(), p.getSecond(), dest)) {
                    return;
                }
                RegionPlan rp = new RegionPlan(p.getFirst(), p.getSecond(), dest);
                LOG.info((Object)("Added move plan " + rp + ", running balancer"));
                this.assignmentManager.balance(rp);
                if (this.cpHost != null) {
                    this.cpHost.postMove(p.getFirst(), p.getSecond(), dest);
                }
            }
            catch (IOException ioe) {
                UnknownRegionException ure = new UnknownRegionException(Bytes.toStringBinary(encodedRegionName));
                ure.initCause(ioe);
                throw ure;
            }
        }
    }

    @Override
    public void createTable(HTableDescriptor hTableDescriptor, byte[][] splitKeys) throws IOException {
        if (!this.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        HRegionInfo[] newRegions = this.getHRegionInfos(hTableDescriptor, splitKeys);
        if (this.cpHost != null) {
            this.cpHost.preCreateTable(hTableDescriptor, newRegions);
        }
        this.executorService.submit(new CreateTableHandler(this, this.fileSystemManager, this.serverManager, hTableDescriptor, this.conf, newRegions, this.catalogTracker, this.assignmentManager));
        if (this.cpHost != null) {
            this.cpHost.postCreateTable(hTableDescriptor, newRegions);
        }
    }

    private HRegionInfo[] getHRegionInfos(HTableDescriptor hTableDescriptor, byte[][] splitKeys) {
        HRegionInfo[] hRegionInfos = null;
        if (splitKeys == null || splitKeys.length == 0) {
            hRegionInfos = new HRegionInfo[]{new HRegionInfo(hTableDescriptor.getName(), null, null)};
        } else {
            int numRegions = splitKeys.length + 1;
            hRegionInfos = new HRegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                hRegionInfos[i] = new HRegionInfo(hTableDescriptor.getName(), startKey, endKey);
                startKey = endKey;
            }
        }
        return hRegionInfos;
    }

    private static boolean isCatalogTable(byte[] tableName) {
        return Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME) || Bytes.equals(tableName, HConstants.META_TABLE_NAME);
    }

    @Override
    public void deleteTable(byte[] tableName) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preDeleteTable(tableName);
        }
        this.executorService.submit(new DeleteTableHandler(tableName, this, this));
        if (this.cpHost != null) {
            this.cpHost.postDeleteTable(tableName);
        }
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        try {
            return this.assignmentManager.getReopenStatus(tableName);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted", e);
        }
    }

    @Override
    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        if (this.cpHost != null && this.cpHost.preAddColumn(tableName, column)) {
            return;
        }
        new TableAddFamilyHandler(tableName, column, (Server)this, (MasterServices)this).process();
        if (this.cpHost != null) {
            this.cpHost.postAddColumn(tableName, column);
        }
    }

    @Override
    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        if (this.cpHost != null && this.cpHost.preModifyColumn(tableName, descriptor)) {
            return;
        }
        new TableModifyFamilyHandler(tableName, descriptor, (Server)this, (MasterServices)this).process();
        if (this.cpHost != null) {
            this.cpHost.postModifyColumn(tableName, descriptor);
        }
    }

    @Override
    public void deleteColumn(byte[] tableName, byte[] c) throws IOException {
        if (this.cpHost != null && this.cpHost.preDeleteColumn(tableName, c)) {
            return;
        }
        new TableDeleteFamilyHandler(tableName, c, (Server)this, (MasterServices)this).process();
        if (this.cpHost != null) {
            this.cpHost.postDeleteColumn(tableName, c);
        }
    }

    @Override
    public void enableTable(byte[] tableName) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preEnableTable(tableName);
        }
        this.executorService.submit(new EnableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager, false));
        if (this.cpHost != null) {
            this.cpHost.postEnableTable(tableName);
        }
    }

    @Override
    public void disableTable(byte[] tableName) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preDisableTable(tableName);
        }
        this.executorService.submit(new DisableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager, false));
        if (this.cpHost != null) {
            this.cpHost.postDisableTable(tableName);
        }
    }

    Pair<HRegionInfo, ServerName> getTableRegionForRow(final byte[] tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair<HRegionInfo, ServerName> pair = MetaReader.parseCatalogResult(data);
                if (pair == null) {
                    return false;
                }
                if (!Bytes.equals(pair.getFirst().getTableName(), tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaScanner.metaScan(this.conf, visitor, tableName, rowKey, 1);
        return result.get();
    }

    @Override
    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preModifyTable(tableName, htd);
        }
        this.executorService.submit(new ModifyTableHandler(tableName, htd, (Server)this, (MasterServices)this));
        if (this.cpHost != null) {
            this.cpHost.postModifyTable(tableName, htd);
        }
    }

    @Override
    public void checkTableModifiable(byte[] tableName) throws IOException {
        String tableNameStr = Bytes.toString(tableName);
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaReader.tableExists(this.getCatalogTracker(), tableNameStr)) {
            throw new TableNotFoundException(tableNameStr);
        }
        if (!this.getAssignmentManager().getZKTable().isDisabledTable(Bytes.toString(tableName))) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public void clearFromTransition(HRegionInfo hri) {
        if (this.assignmentManager.isRegionInTransition(hri) != null) {
            this.assignmentManager.regionOffline(hri);
        }
    }

    @Override
    public ClusterStatus getClusterStatus() {
        List<String> backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenNoWatch(this.zooKeeper, this.zooKeeper.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = new ArrayList<String>(0);
        }
        ArrayList<ServerName> backupMasters = new ArrayList<ServerName>(backupMasterStrings.size());
        for (String s : backupMasterStrings) {
            try {
                byte[] bytes = ZKUtil.getData(this.zooKeeper, ZKUtil.joinZNode(this.zooKeeper.backupMasterAddressesZNode, s));
                if (bytes == null) continue;
                backupMasters.add(ServerName.parseVersionedServerName(bytes));
            }
            catch (KeeperException e) {
                LOG.warn((Object)this.zooKeeper.prefix("Unable to get information about backup servers"), (Throwable)e);
            }
        }
        Collections.sort(backupMasters, new Comparator<ServerName>(){

            @Override
            public int compare(ServerName s1, ServerName s2) {
                return s1.getServerName().compareTo(s2.getServerName());
            }
        });
        return new ClusterStatus(VersionInfo.getVersion(), this.fileSystemManager.getClusterId(), this.serverManager.getOnlineServers(), this.serverManager.getDeadServers(), this.serverName, backupMasters, this.assignmentManager.getRegionsInTransition(), this.getCoprocessors());
    }

    public String getClusterId() {
        return this.fileSystemManager.getClusterId();
    }

    public static String getLoadedCoprocessors() {
        return CoprocessorHost.getLoadedCoprocessors().toString();
    }

    public long getMasterStartTime() {
        return this.masterStartTime;
    }

    public long getMasterActiveTime() {
        return this.masterActiveTime;
    }

    public String[] getCoprocessors() {
        Set<String> masterCoprocessors = this.getCoprocessorHost().getCoprocessors();
        return masterCoprocessors.toArray(new String[0]);
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (this.cpHost != null) {
            LOG.fatal((Object)("Master server abort: loaded coprocessors are: " + HMaster.getLoadedCoprocessors()));
        }
        if (this.abortNow(msg, t)) {
            if (t != null) {
                LOG.fatal((Object)msg, t);
            } else {
                LOG.fatal((Object)msg);
            }
            this.abort = true;
            this.stop("Aborting");
        }
    }

    private boolean tryRecoveringExpiredZKSession() throws InterruptedException, IOException, KeeperException, ExecutionException {
        Boolean recovered;
        this.zooKeeper = new ZooKeeperWatcher(this.conf, "master:" + this.serverName.getPort(), this, true);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws InterruptedException, IOException, KeeperException {
                MonitoredTask status = TaskMonitor.get().createStatus("Recovering expired ZK session");
                try {
                    if (!HMaster.this.becomeActiveMaster(status)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    HMaster.this.initializeZKBasedSystemTrackers();
                    HMaster.this.assignRootAndMeta(status);
                    HMaster.this.assignmentManager.processDeadServersAndRegionsInTransition();
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                finally {
                    status.cleanup();
                }
            }
        };
        long timeout = this.conf.getLong("hbase.master.zksession.recover.timeout", 300000L);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> result = executor.submit(callable);
        executor.shutdown();
        if (executor.awaitTermination(timeout, TimeUnit.MILLISECONDS) && result.isDone() && (recovered = result.get()) != null) {
            return recovered;
        }
        executor.shutdownNow();
        return false;
    }

    private boolean abortNow(String msg, Throwable t) {
        if (!this.isActiveMaster) {
            return true;
        }
        if (t != null && t instanceof KeeperException.SessionExpiredException) {
            try {
                LOG.info((Object)"Primary Master trying to recover from ZooKeeper session expiry.");
                return !this.tryRecoveringExpiredZKSession();
            }
            catch (Throwable newT) {
                LOG.error((Object)"Primary master encountered unexpected exception while trying to recover from ZooKeeper session expiry. Proceeding with server abort.", newT);
            }
        }
        return true;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    public MasterCoprocessorHost getCoprocessorHost() {
        return this.cpHost;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    @Override
    public void shutdown() {
        if (this.cpHost != null) {
            try {
                this.cpHost.preShutdown();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error call master coprocessor preShutdown()", (Throwable)ioe);
            }
        }
        if (this.mxBean != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mxBean);
            this.mxBean = null;
        }
        this.assignmentManager.shutdown();
        this.serverManager.shutdownCluster();
        try {
            this.clusterStatusTracker.setClusterDown();
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
        }
    }

    @Override
    public void stopMaster() {
        if (this.cpHost != null) {
            try {
                this.cpHost.preStopMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error call master coprocessor preStopMaster()", (Throwable)ioe);
            }
        }
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String why) {
        LOG.info((Object)why);
        this.stopped = true;
        if (this.activeMasterManager != null) {
            AtomicBoolean atomicBoolean = this.activeMasterManager.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                this.activeMasterManager.clusterHasActiveMaster.notifyAll();
            }
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isAborted() {
        return this.abort;
    }

    public boolean isActiveMaster() {
        return this.isActiveMaster;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    @Deprecated
    public void assign(byte[] regionName, boolean force) throws IOException {
        this.assign(regionName);
    }

    @Override
    public void assign(byte[] regionName) throws IOException {
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toString(regionName));
        }
        if (this.cpHost != null && this.cpHost.preAssign(pair.getFirst())) {
            return;
        }
        this.assignRegion(pair.getFirst());
        if (this.cpHost != null) {
            this.cpHost.postAssign(pair.getFirst());
        }
    }

    public void assignRegion(HRegionInfo hri) {
        this.assignmentManager.assign(hri, true);
    }

    @Override
    public void unassign(byte[] regionName, boolean force) throws IOException {
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toString(regionName));
        }
        HRegionInfo hri = pair.getFirst();
        if (this.cpHost != null && this.cpHost.preUnassign(hri, force)) {
            return;
        }
        if (force) {
            this.assignmentManager.regionOffline(hri);
            this.assignRegion(hri);
        } else {
            this.assignmentManager.unassign(hri, force);
        }
        if (this.cpHost != null) {
            this.cpHost.postUnassign(hri, force);
        }
    }

    @Override
    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) {
        ArrayList<HTableDescriptor> list = new ArrayList<HTableDescriptor>(tableNames.size());
        for (String s : tableNames) {
            HTableDescriptor htd = null;
            try {
                htd = this.tableDescriptors.get(s);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed getting descriptor for " + s), (Throwable)e);
            }
            if (htd == null) continue;
            list.add(htd);
        }
        return list.toArray(new HTableDescriptor[0]);
    }

    @Override
    public HTableDescriptor[] getHTableDescriptors() {
        Map<String, HTableDescriptor> descriptors = null;
        try {
            descriptors = this.tableDescriptors.getAll();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed getting all descriptors", (Throwable)e);
        }
        return descriptors == null ? null : descriptors.values().toArray(new HTableDescriptor[0]);
    }

    public double getAverageLoad() {
        return this.assignmentManager.getAverageLoad();
    }

    @Override
    public void offline(byte[] regionName) throws IOException {
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(this.catalogTracker, regionName);
        if (pair == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(regionName));
        }
        HRegionInfo hri = pair.getFirst();
        this.assignmentManager.regionOffline(hri);
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (InvocationTargetException ite) {
            Throwable target;
            Throwable throwable = target = ite.getTargetException() != null ? ite.getTargetException() : ite;
            if (target.getCause() != null) {
                target = target.getCause();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString(), target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + (e.getCause() != null ? e.getCause().getMessage() : ""), e);
        }
    }

    public static void main(String[] args) throws Exception {
        VersionInfo.logVersion();
        new HMasterCommandLine(HMaster.class).doMain(args);
    }

    void registerMBean() {
        MXBeanImpl mxBeanInfo = MXBeanImpl.init(this);
        MBeanUtil.registerMBean((String)"Master", (String)"Master", (Object)mxBeanInfo);
        LOG.info((Object)"Registered HMaster MXBean");
    }
}

