/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.LogCleanerDelegate;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.FSUtils;

public class LogCleaner
extends Chore {
    static final Log LOG = LogFactory.getLog((String)LogCleaner.class.getName());
    private final FileSystem fs;
    private final Path oldLogDir;
    private List<LogCleanerDelegate> logCleanersChain;
    private final Configuration conf;

    public LogCleaner(int p, Stoppable s, Configuration conf, FileSystem fs, Path oldLogDir) {
        super("LogsCleaner", p, s);
        this.fs = fs;
        this.oldLogDir = oldLogDir;
        this.conf = conf;
        this.logCleanersChain = new LinkedList<LogCleanerDelegate>();
        this.initLogCleanersChain();
    }

    private void initLogCleanersChain() {
        String[] logCleaners = this.conf.getStrings("hbase.master.logcleaner.plugins");
        if (logCleaners != null) {
            for (String className : logCleaners) {
                LogCleanerDelegate logCleaner = LogCleaner.newLogCleaner(className, this.conf);
                this.addLogCleaner(logCleaner);
            }
        }
    }

    public static LogCleanerDelegate newLogCleaner(String className, Configuration conf) {
        try {
            Class<?> c = Class.forName(className);
            LogCleanerDelegate cleaner = (LogCleanerDelegate)c.newInstance();
            cleaner.setConf(conf);
            return cleaner;
        }
        catch (Exception e) {
            LOG.warn((Object)("Can NOT create LogCleanerDelegate: " + className), (Throwable)e);
            return null;
        }
    }

    public void addLogCleaner(LogCleanerDelegate logCleaner) {
        if (logCleaner != null && !this.logCleanersChain.contains(logCleaner)) {
            this.logCleanersChain.add(logCleaner);
            LOG.debug((Object)("Add log cleaner in chain: " + logCleaner.getClass().getName()));
        }
    }

    @Override
    protected void chore() {
        try {
            FileStatus[] files = FSUtils.listStatus(this.fs, this.oldLogDir, null);
            if (files == null) {
                return;
            }
            block2: for (FileStatus file : files) {
                Path filePath = file.getPath();
                if (HLog.validateHLogFilename(filePath.getName())) {
                    for (LogCleanerDelegate logCleaner : this.logCleanersChain) {
                        if (logCleaner.isStopped()) {
                            LOG.warn((Object)"A log cleaner is stopped, won't delete any log.");
                            return;
                        }
                        if (logCleaner.isLogDeletable(filePath)) continue;
                        continue block2;
                    }
                    this.fs.delete(filePath, true);
                    continue;
                }
                LOG.warn((Object)("Found a wrongly formated file: " + file.getPath().getName()));
                this.fs.delete(filePath, true);
            }
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            LOG.warn((Object)"Error while cleaning the logs", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            for (LogCleanerDelegate lc : this.logCleanersChain) {
                try {
                    lc.stop("Exiting");
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Stopping", t);
                }
            }
        }
    }
}

