/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;

public class MasterCoprocessorHost
extends CoprocessorHost<MasterEnvironment> {
    private static final Log LOG = LogFactory.getLog(MasterCoprocessorHost.class);
    private MasterServices masterServices;

    MasterCoprocessorHost(MasterServices services, Configuration conf) {
        this.masterServices = services;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.master.classes");
    }

    @Override
    public MasterEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        return new MasterEnvironment(implClass, instance, priority, seq, conf, this.masterServices);
    }

    @Override
    protected void abortServer(CoprocessorEnvironment env, Throwable e) {
        this.abortServer("master", this.masterServices, env, e);
    }

    void preCreateTable(HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preCreateTable(ctx, htd, regions);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void postCreateTable(HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postCreateTable(ctx, htd, regions);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void preDeleteTable(byte[] tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preDeleteTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void postDeleteTable(byte[] tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postDeleteTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void preModifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preModifyTable(ctx, tableName, htd);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void postModifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postModifyTable(ctx, tableName, htd);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preAddColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preAddColumn(ctx, tableName, column);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postAddColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postAddColumn(ctx, tableName, column);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preModifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preModifyColumn(ctx, tableName, descriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postModifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postModifyColumn(ctx, tableName, descriptor);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preDeleteColumn(byte[] tableName, byte[] c) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preDeleteColumn(ctx, tableName, c);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postDeleteColumn(byte[] tableName, byte[] c) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postDeleteColumn(ctx, tableName, c);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void preEnableTable(byte[] tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preEnableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void postEnableTable(byte[] tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postEnableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void preDisableTable(byte[] tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preDisableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void postDisableTable(byte[] tableName) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postDisableTable(ctx, tableName);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preMove(HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preMove(ctx, region, srcServer, destServer);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postMove(HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postMove(ctx, region, srcServer, destServer);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preAssign(HRegionInfo regionInfo) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preAssign(ctx, regionInfo);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postAssign(HRegionInfo regionInfo) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postAssign(ctx, regionInfo);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preUnassign(HRegionInfo regionInfo, boolean force) throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preUnassign(ctx, regionInfo, force);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postUnassign(HRegionInfo regionInfo, boolean force) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postUnassign(ctx, regionInfo, force);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preBalance() throws IOException {
        boolean bypass = false;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preBalance(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    void postBalance() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postBalance(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    boolean preBalanceSwitch(boolean b) throws IOException {
        boolean balance = b;
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                balance = ((MasterObserver)env.getInstance()).preBalanceSwitch(ctx, balance);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return balance;
    }

    void postBalanceSwitch(boolean oldValue, boolean newValue) throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postBalanceSwitch(ctx, oldValue, newValue);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void preShutdown() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preShutdown(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void preStopMaster() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).preStopMaster(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    void postStartMaster() throws IOException {
        ObserverContext<MasterCoprocessorEnvironment> ctx = null;
        for (MasterEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((MasterObserver)env.getInstance()).postStartMaster(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    static class MasterEnvironment
    extends CoprocessorHost.Environment
    implements MasterCoprocessorEnvironment {
        private MasterServices masterServices;

        public MasterEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, MasterServices services) {
            super(impl, priority, seq, conf);
            this.masterServices = services;
        }

        @Override
        public MasterServices getMasterServices() {
            return this.masterServices;
        }
    }
}

