/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.tmpl.master.MasterStatusTmpl;

public class MasterStatusServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(MasterStatusServlet.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HMaster master = (HMaster)this.getServletContext().getAttribute("master");
        assert (master != null) : "No Master in context!";
        Configuration conf = master.getConfiguration();
        HBaseAdmin admin = new HBaseAdmin(conf);
        Map<String, Integer> frags = this.getFragmentationInfo(master, conf);
        ServerName rootLocation = this.getRootLocationOrNull(master);
        ServerName metaLocation = master.getCatalogTracker().getMetaLocation();
        List<ServerName> servers = master.getServerManager().getOnlineServersList();
        Set<ServerName> deadServers = master.getServerManager().getDeadServers();
        response.setContentType("text/html");
        MasterStatusTmpl tmpl = new MasterStatusTmpl().setFrags(frags).setShowSyncWarning(MasterStatusServlet.shouldShowSyncWarning(conf)).setShowHflushWarning(MasterStatusServlet.shouldShowHflushWarning(conf)).setRootLocation(rootLocation).setMetaLocation(metaLocation).setServers(servers).setDeadServers(deadServers);
        if (request.getParameter("filter") != null) {
            tmpl.setFilter(request.getParameter("filter"));
        }
        if (request.getParameter("format") != null) {
            tmpl.setFormat(request.getParameter("format"));
        }
        tmpl.render(response.getWriter(), master, admin);
    }

    private ServerName getRootLocationOrNull(HMaster master) {
        try {
            return master.getCatalogTracker().getRootLocation();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Unable to get root location", (Throwable)e);
            return null;
        }
    }

    private Map<String, Integer> getFragmentationInfo(HMaster master, Configuration conf) throws IOException {
        boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
        if (showFragmentation) {
            return FSUtils.getTableFragmentation(master);
        }
        return null;
    }

    static boolean shouldShowSyncWarning(Configuration conf) {
        try {
            return !FSUtils.isSyncSupported() && FSUtils.isHDFS(conf);
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to determine if sync is supported", (Throwable)e);
            return false;
        }
    }

    static boolean shouldShowHflushWarning(Configuration conf) {
        try {
            return !FSUtils.isHflushSupported() && FSUtils.isHDFS(conf);
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to determine if hflush is supported", (Throwable)e);
            return false;
        }
    }
}

