/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.zookeeper.KeeperException;

public class CreateTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CreateTableHandler.class);
    private MasterFileSystem fileSystemManager;
    private final HTableDescriptor hTableDescriptor;
    private Configuration conf;
    private final AssignmentManager assignmentManager;
    private final CatalogTracker catalogTracker;
    private final ServerManager serverManager;
    private final HRegionInfo[] newRegions;

    public CreateTableHandler(Server server, MasterFileSystem fileSystemManager, ServerManager serverManager, HTableDescriptor hTableDescriptor, Configuration conf, HRegionInfo[] newRegions, CatalogTracker catalogTracker, AssignmentManager assignmentManager) throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        super(server, EventHandler.EventType.C_M_CREATE_TABLE);
        this.fileSystemManager = fileSystemManager;
        this.serverManager = serverManager;
        this.hTableDescriptor = hTableDescriptor;
        this.conf = conf;
        this.newRegions = newRegions;
        this.catalogTracker = catalogTracker;
        this.assignmentManager = assignmentManager;
        int timeout = conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (catalogTracker.waitForMeta(timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            throw new IOException(e);
        }
        String tableName = this.hTableDescriptor.getNameAsString();
        if (MetaReader.tableExists(catalogTracker, tableName)) {
            throw new TableExistsException(tableName);
        }
        try {
            if (!this.assignmentManager.getZKTable().checkAndSetEnablingTable(tableName)) {
                throw new TableExistsException(tableName);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.hTableDescriptor.getNameAsString();
    }

    @Override
    public void process() {
        String tableName = this.hTableDescriptor.getNameAsString();
        try {
            LOG.info((Object)("Attemping to create the table " + tableName));
            this.handleCreateTable();
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to create the table " + tableName), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error trying to create the table " + tableName), (Throwable)e);
        }
    }

    private void handleCreateTable() throws IOException, KeeperException {
        FSTableDescriptors.createTableDescriptor(this.hTableDescriptor, this.conf);
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        int batchSize = this.conf.getInt("hbase.master.createtable.batchsize", 100);
        HLog hlog = null;
        for (int regionIdx = 0; regionIdx < this.newRegions.length; ++regionIdx) {
            HRegionInfo newRegion = this.newRegions[regionIdx];
            HRegion region = HRegion.createHRegion(newRegion, this.fileSystemManager.getRootDir(), this.conf, this.hTableDescriptor, hlog);
            if (hlog == null) {
                hlog = region.getLog();
            }
            regionInfos.add(region.getRegionInfo());
            if (regionIdx % batchSize == 0) {
                MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
                regionInfos.clear();
            }
            region.close();
        }
        hlog.closeAndDelete();
        if (regionInfos.size() > 0) {
            MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
        }
        List<ServerName> servers = this.serverManager.getOnlineServersList();
        try {
            this.assignmentManager.assignUserRegions(Arrays.asList(this.newRegions), servers);
        }
        catch (InterruptedException ie) {
            LOG.error((Object)("Caught " + ie + " during round-robin assignment"));
            throw new IOException(ie);
        }
        try {
            this.assignmentManager.getZKTable().setEnabledTable(this.hTableDescriptor.getNameAsString());
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabled because of a ZooKeeper issue", e);
        }
    }
}

