/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;

public class TableDeleteFamilyHandler
extends TableEventHandler {
    private final byte[] familyName;

    public TableDeleteFamilyHandler(byte[] tableName, byte[] familyName, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_ADD_FAMILY, tableName, server, masterServices);
        HTableDescriptor htd = this.getTableDescriptor();
        this.familyName = this.hasColumnFamily(htd, familyName);
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        HTableDescriptor htd = this.masterServices.getMasterFileSystem().deleteColumn(this.tableName, this.familyName);
        this.masterServices.getTableDescriptors().add(htd);
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String family = "UnknownFamily";
        if (this.familyName != null) {
            family = Bytes.toString(this.familyName);
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableNameStr + "-" + family;
    }
}

