/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.histogram;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.metrics.histogram.Sample;
import org.apache.hadoop.hbase.metrics.histogram.Snapshot;
import org.apache.hadoop.hbase.util.Threads;

public class ExponentiallyDecayingSample
implements Sample {
    private static final Random RANDOM = new Random();
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    private static final ScheduledExecutorService TICK_SERVICE = Executors.newScheduledThreadPool(1, Threads.getNamedThreadFactory(Thread.currentThread().getName() + ".decayingSampleTick.", true));
    private static volatile long CURRENT_TICK = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    private final ConcurrentSkipListMap<Double, Long> values = new ConcurrentSkipListMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong nextScaleTime = new AtomicLong(0L);
    private final double alpha;
    private final int reservoirSize;
    private volatile long startTime;

    public ExponentiallyDecayingSample(int reservoirSize, double alpha) {
        this.alpha = alpha;
        this.reservoirSize = reservoirSize;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lockForRescale();
        try {
            this.values.clear();
            this.count.set(0L);
            this.startTime = CURRENT_TICK;
            this.nextScaleTime.set(System.nanoTime() + RESCALE_THRESHOLD);
        }
        finally {
            this.unlockForRescale();
        }
    }

    @Override
    public int size() {
        return (int)Math.min((long)this.reservoirSize, this.count.get());
    }

    @Override
    public void update(long value) {
        this.update(value, CURRENT_TICK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value, long timestamp) {
        this.lockForRegularUsage();
        try {
            double priority = this.weight(timestamp - this.startTime) / RANDOM.nextDouble();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.reservoirSize) {
                this.values.put(priority, value);
            } else {
                Double first = this.values.firstKey();
                if (first < priority && this.values.putIfAbsent(priority, value) == null) {
                    while (this.values.remove(first) == null) {
                        first = this.values.firstKey();
                    }
                }
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
        long now = System.nanoTime();
        long next = this.nextScaleTime.get();
        if (now >= next) {
            this.rescale(now, next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot getSnapshot() {
        this.lockForRegularUsage();
        try {
            Snapshot snapshot = new Snapshot(this.values.values());
            return snapshot;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this.startTime;
                this.startTime = CURRENT_TICK;
                ArrayList keys = new ArrayList(this.values.keySet());
                for (Double key : keys) {
                    Long value = this.values.remove(key);
                    this.values.put(key * Math.exp(-this.alpha * (double)(this.startTime - oldStartTime)), value);
                }
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    private void unlockForRescale() {
        this.lock.writeLock().unlock();
    }

    private void lockForRescale() {
        this.lock.writeLock().lock();
    }

    private void lockForRegularUsage() {
        this.lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this.lock.readLock().unlock();
    }

    static {
        TICK_SERVICE.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CURRENT_TICK = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }
}

