/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.Store;

class ConstantSizeRegionSplitPolicy
extends RegionSplitPolicy {
    private long desiredMaxFileSize;

    ConstantSizeRegionSplitPolicy() {
    }

    @Override
    void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        long maxFileSize = region.getTableDesc().getMaxFileSize();
        if (maxFileSize == 0x40000000L) {
            maxFileSize = this.getConf().getLong("hbase.hregion.max.filesize", 0x40000000L);
        }
        this.desiredMaxFileSize = maxFileSize;
    }

    @Override
    boolean shouldSplit() {
        boolean force = this.region.shouldForceSplit();
        boolean foundABigStore = false;
        for (Store store : this.region.getStores().values()) {
            if (!store.canSplit()) {
                return false;
            }
            if (store.getSize() <= this.desiredMaxFileSize) continue;
            foundABigStore = true;
        }
        return foundABigStore || force;
    }

    long getDesiredMaxFileSize() {
        return this.desiredMaxFileSize;
    }
}

