/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class ExplicitColumnTracker
implements ColumnTracker {
    private final int maxVersions;
    private final int minVersions;
    private final List<ColumnCount> columns;
    private final List<ColumnCount> columnsToReuse;
    private int index;
    private ColumnCount column;
    private long latestTSOfCurrentColumn;
    private long oldestStamp;

    public ExplicitColumnTracker(NavigableSet<byte[]> columns, int minVersions, int maxVersions, long ttl) {
        this.maxVersions = maxVersions;
        this.minVersions = minVersions;
        this.oldestStamp = System.currentTimeMillis() - ttl;
        this.columns = new ArrayList<ColumnCount>(columns.size());
        this.columnsToReuse = new ArrayList<ColumnCount>(columns.size());
        for (byte[] column : columns) {
            this.columnsToReuse.add(new ColumnCount(column));
        }
        this.reset();
    }

    @Override
    public boolean done() {
        return this.columns.size() == 0;
    }

    @Override
    public ColumnCount getColumnHint() {
        return this.column;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length, long timestamp, boolean ignoreCount) {
        while (this.columns.size() != 0) {
            if (this.column == null) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            int ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
            if (ret == 0) {
                if (ignoreCount) {
                    return ScanQueryMatcher.MatchCode.INCLUDE;
                }
                if (this.sameAsPreviousTS(timestamp)) {
                    return ScanQueryMatcher.MatchCode.SKIP;
                }
                int count = this.column.increment();
                if (count >= this.maxVersions || count >= this.minVersions && this.isExpired(timestamp)) {
                    this.columns.remove(this.index);
                    this.resetTS();
                    if (this.columns.size() == this.index) {
                        this.column = null;
                        return ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW;
                    }
                    this.column = this.columns.get(this.index);
                    return ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL;
                }
                this.setTS(timestamp);
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            this.resetTS();
            if (ret > 0) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
            if (ret > -1) continue;
            if (++this.index >= this.columns.size()) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
            }
            this.column = this.columns.get(this.index);
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
    }

    @Override
    public void update() {
        if (this.columns.size() != 0) {
            this.index = 0;
            this.column = this.columns.get(this.index);
        } else {
            this.index = -1;
            this.column = null;
        }
    }

    @Override
    public void reset() {
        this.buildColumnList();
        this.index = 0;
        this.column = this.columns.get(this.index);
        this.resetTS();
    }

    private void resetTS() {
        this.latestTSOfCurrentColumn = Long.MAX_VALUE;
    }

    private void setTS(long timestamp) {
        this.latestTSOfCurrentColumn = timestamp;
    }

    private boolean sameAsPreviousTS(long timestamp) {
        return timestamp == this.latestTSOfCurrentColumn;
    }

    private boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    private void buildColumnList() {
        this.columns.clear();
        this.columns.addAll(this.columnsToReuse);
        for (ColumnCount col : this.columns) {
            col.setCount(0);
        }
    }

    public void doneWithColumn(byte[] bytes, int offset, int length) {
        while (this.column != null) {
            int compare = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
            this.resetTS();
            if (compare == 0) {
                this.columns.remove(this.index);
                this.column = this.columns.size() == this.index ? null : this.columns.get(this.index);
                return;
            }
            if (compare <= -1) {
                if (++this.index != this.columns.size()) {
                    this.column = this.columns.get(this.index);
                    continue;
                }
                this.column = null;
                continue;
            }
            return;
        }
    }

    @Override
    public ScanQueryMatcher.MatchCode getNextRowOrNextColumn(byte[] bytes, int offset, int qualLength) {
        this.doneWithColumn(bytes, offset, qualLength);
        if (this.getColumnHint() == null) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public boolean isDone(long timestamp) {
        return this.minVersions <= 0 && this.isExpired(timestamp);
    }
}

