/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HashedBytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.cliffc.high_scale_lib.Counter;

public class HRegion
implements HeapSize {
    public static final Log LOG = LogFactory.getLog(HRegion.class);
    static final String MERGEDIR = "merges";
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    private final ConcurrentHashMap<HashedBytes, CountDownLatch> lockedRows = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, HashedBytes> lockIds = new ConcurrentHashMap();
    private final AtomicInteger lockIdGenerator = new AtomicInteger(1);
    private static Random rand = new Random();
    protected final Map<byte[], Store> stores = new ConcurrentSkipListMap<byte[], Store>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private ClassToInstanceMap<CoprocessorProtocol> protocolHandlers = MutableClassToInstanceMap.create();
    private Map<String, Class<? extends CoprocessorProtocol>> protocolHandlerNames = Maps.newHashMap();
    final AtomicLong memstoreSize = new AtomicLong(0L);
    final AtomicLong numPutsWithoutWAL = new AtomicLong(0L);
    final AtomicLong dataInMemoryWithoutWAL = new AtomicLong(0L);
    final Counter readRequestsCount = new Counter();
    final Counter writeRequestsCount = new Counter();
    final Path tableDir;
    final HLog log;
    final FileSystem fs;
    final Configuration conf;
    final int rowLockWaitDuration;
    static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    final HRegionInfo regionInfo;
    final Path regiondir;
    KeyValue.KVComparator comparator;
    private ConcurrentHashMap<RegionScanner, Long> scannerReadPoints;
    final WriteState writestate = new WriteState();
    long memstoreFlushSize;
    private volatile long lastFlushTime;
    final RegionServerServices rsServices;
    private List<Pair<Long, Long>> recentFlushes = new ArrayList<Pair<Long, Long>>();
    private long blockingMemStoreSize;
    final long threadWakeFrequency;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private boolean splitRequest;
    private byte[] explicitSplitPoint = null;
    private final MultiVersionConsistencyControl mvcc = new MultiVersionConsistencyControl();
    private RegionCoprocessorHost coprocessorHost;
    public static final String REGIONINFO_FILE = ".regioninfo";
    private HTableDescriptor htableDescriptor = null;
    private RegionSplitPolicy splitPolicy;
    private final Object closeLock = new Object();
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + ClassSize.ARRAY + 32 * ClassSize.REFERENCE + 4 + 32 + 1);
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)(3 * ClassSize.ATOMIC_LONG) + (long)ClassSize.ATOMIC_INTEGER + (long)(3 * ClassSize.CONCURRENT_HASHMAP) + WriteState.HEAP_SIZE + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)(2 * ClassSize.REENTRANT_LOCK) + (long)ClassSize.ARRAYLIST + MultiVersionConsistencyControl.FIXED_SIZE;
    private static final List<KeyValue> MOCKED_LIST = new AbstractList<KeyValue>(){

        @Override
        public void add(int index, KeyValue element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends KeyValue> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSmallestReadPoint() {
        long minimumReadPoint;
        ConcurrentHashMap<RegionScanner, Long> concurrentHashMap = this.scannerReadPoints;
        synchronized (concurrentHashMap) {
            minimumReadPoint = this.mvcc.memstoreReadPoint();
            for (Long readPoint : this.scannerReadPoints.values()) {
                if (readPoint >= minimumReadPoint) continue;
                minimumReadPoint = readPoint;
            }
        }
        return minimumReadPoint;
    }

    public HRegion() {
        this.tableDir = null;
        this.blockingMemStoreSize = 0L;
        this.conf = null;
        this.rowLockWaitDuration = 30000;
        this.rsServices = null;
        this.fs = null;
        this.memstoreFlushSize = 0L;
        this.log = null;
        this.regiondir = null;
        this.regionInfo = null;
        this.htableDescriptor = null;
        this.threadWakeFrequency = 0L;
        this.coprocessorHost = null;
        this.scannerReadPoints = new ConcurrentHashMap();
    }

    public HRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        this.tableDir = tableDir;
        this.comparator = regionInfo.getComparator();
        this.log = log;
        this.fs = fs;
        this.conf = conf;
        this.rowLockWaitDuration = conf.getInt("hbase.rowlock.wait.duration", 30000);
        this.regionInfo = regionInfo;
        this.htableDescriptor = htd;
        this.rsServices = rsServices;
        this.threadWakeFrequency = conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        String encodedNameStr = this.regionInfo.getEncodedName();
        this.setHTableSpecificConf();
        this.regiondir = HRegion.getRegionDir(this.tableDir, encodedNameStr);
        this.scannerReadPoints = new ConcurrentHashMap();
        if (rsServices != null) {
            this.coprocessorHost = new RegionCoprocessorHost(this, rsServices, conf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiated " + this));
        }
    }

    void setHTableSpecificConf() {
        if (this.htableDescriptor == null) {
            return;
        }
        LOG.info((Object)"Setting up tabledescriptor config now ...");
        long flushSize = this.htableDescriptor.getMemStoreFlushSize();
        if (flushSize == 0x8000000L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        this.memstoreFlushSize = flushSize;
        this.blockingMemStoreSize = this.memstoreFlushSize * this.conf.getLong("hbase.hregion.memstore.block.multiplier", 2L);
    }

    public long initialize() throws IOException {
        return this.initialize(null);
    }

    public long initialize(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-open hook");
            this.coprocessorHost.preOpen();
        }
        status.setStatus("Writing region info on filesystem");
        this.checkRegioninfoOnFilesystem();
        status.setStatus("Cleaning up temporary data from old regions");
        this.cleanupTmpDir();
        long minSeqId = -1L;
        long maxSeqId = -1L;
        long maxMemstoreTS = -1L;
        for (HColumnDescriptor c : this.htableDescriptor.getFamilies()) {
            long maxStoreMemstoreTS;
            status.setStatus("Instantiating store for column family " + c);
            Store store = this.instantiateHStore(this.tableDir, c);
            this.stores.put(c.getName(), store);
            long storeSeqId = store.getMaxSequenceId();
            if (minSeqId == -1L || storeSeqId < minSeqId) {
                minSeqId = storeSeqId;
            }
            if (maxSeqId == -1L || storeSeqId > maxSeqId) {
                maxSeqId = storeSeqId;
            }
            if ((maxStoreMemstoreTS = store.getMaxMemstoreTS()) <= maxMemstoreTS) continue;
            maxMemstoreTS = maxStoreMemstoreTS;
        }
        this.mvcc.initialize(maxMemstoreTS + 1L);
        maxSeqId = Math.max(maxSeqId, this.replayRecoveredEditsIfAny(this.regiondir, minSeqId, reporter, status));
        status.setStatus("Cleaning up detritus from prior splits");
        SplitTransaction.cleanupAnySplitDetritus(this);
        FSUtils.deleteDirectory(this.fs, new Path(this.regiondir, MERGEDIR));
        this.writestate.setReadOnly(this.htableDescriptor.isReadOnly());
        this.writestate.flushRequested = false;
        this.writestate.compacting = 0;
        this.splitPolicy = RegionSplitPolicy.create(this, this.conf);
        this.lastFlushTime = EnvironmentEdgeManager.currentTimeMillis();
        long nextSeqid = maxSeqId + 1L;
        LOG.info((Object)("Onlined " + this.toString() + "; next sequenceid=" + nextSeqid));
        this.closing.set(false);
        this.closed.set(false);
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor post-open hooks");
            this.coprocessorHost.postOpen();
        }
        status.markComplete("Region opened successfully");
        return nextSeqid;
    }

    static void moveInitialFilesIntoPlace(FileSystem fs, Path initialFiles, Path regiondir) throws IOException {
        if (initialFiles != null && fs.exists(initialFiles) && !fs.rename(initialFiles, regiondir)) {
            LOG.warn((Object)("Unable to rename " + initialFiles + " to " + regiondir));
        }
    }

    public boolean hasReferences() {
        for (Store store : this.stores.values()) {
            for (StoreFile sf : store.getStorefiles()) {
                if (!sf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDFSBlocksDistribution getHDFSBlocksDistribution() {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        Map<byte[], Store> map = this.stores;
        synchronized (map) {
            for (Store store : this.stores.values()) {
                for (StoreFile sf : store.getStorefiles()) {
                    HDFSBlocksDistribution storeFileBlocksDistribution = sf.getHDFSBlockDistribution();
                    hdfsBlocksDistribution.add(storeFileBlocksDistribution);
                }
            }
        }
        return hdfsBlocksDistribution;
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, HTableDescriptor tableDescriptor, String regionEncodedName) throws IOException {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        Path tablePath = FSUtils.getTablePath(FSUtils.getRootDir(conf), tableDescriptor.getName());
        FileSystem fs = tablePath.getFileSystem(conf);
        for (HColumnDescriptor family : tableDescriptor.getFamilies()) {
            Path storeHomeDir = Store.getStoreHomedir(tablePath, regionEncodedName, family.getName());
            if (!fs.exists(storeHomeDir)) continue;
            FileStatus[] hfilesStatus = null;
            for (FileStatus hfileStatus : hfilesStatus = fs.listStatus(storeHomeDir)) {
                HDFSBlocksDistribution storeFileBlocksDistribution = FSUtils.computeHDFSBlocksDistribution(fs, hfileStatus, 0L, hfileStatus.getLen());
                hdfsBlocksDistribution.add(storeFileBlocksDistribution);
            }
        }
        return hdfsBlocksDistribution;
    }

    public AtomicLong getMemstoreSize() {
        return this.memstoreSize;
    }

    public long addAndGetGlobalMemstoreSize(long memStoreSize) {
        RegionServerAccounting rsAccounting;
        if (this.rsServices != null && (rsAccounting = this.rsServices.getRegionServerAccounting()) != null) {
            rsAccounting.addAndGetGlobalMemstoreSize(memStoreSize);
        }
        return this.memstoreSize.getAndAdd(memStoreSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRegioninfoOnFilesystem() throws IOException {
        Path regioninfoPath = new Path(this.regiondir, REGIONINFO_FILE);
        if (this.fs.exists(regioninfoPath) && this.fs.getFileStatus(regioninfoPath).getLen() > 0L) {
            return;
        }
        Path tmpPath = new Path(this.getTmpDir(), REGIONINFO_FILE);
        FSDataOutputStream out = this.fs.create(tmpPath, true);
        try {
            this.regionInfo.write((DataOutput)out);
            out.write(10);
            out.write(10);
            out.write(Bytes.toBytes(this.regionInfo.toString()));
        }
        finally {
            out.close();
        }
        if (!this.fs.rename(tmpPath, regioninfoPath)) {
            throw new IOException("Unable to rename " + tmpPath + " to " + regioninfoPath);
        }
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public long getRequestsCount() {
        return this.readRequestsCount.get() + this.writeRequestsCount.get();
    }

    public long getReadRequestsCount() {
        return this.readRequestsCount.get();
    }

    public long getWriteRequestsCount() {
        return this.writeRequestsCount.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isAvailable() {
        return !this.isClosed() && !this.isClosing();
    }

    public boolean isSplittable() {
        return this.isAvailable() && !this.hasReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areWritesEnabled() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            return this.writestate.writesEnabled;
        }
    }

    public MultiVersionConsistencyControl getMVCC() {
        return this.mvcc;
    }

    public List<StoreFile> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreFile> close(boolean abort) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Closing region " + this + (abort ? " due to abort" : ""));
        status.setStatus("Waiting for close lock");
        try {
            Object object = this.closeLock;
            synchronized (object) {
                List<StoreFile> list = this.doClose(abort, status);
                return list;
            }
        }
        finally {
            status.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StoreFile> doClose(boolean abort, MonitoredTask status) throws IOException {
        if (this.isClosed()) {
            LOG.warn((Object)("Region " + this + " already closed"));
            return null;
        }
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-close hooks");
            this.coprocessorHost.preClose(abort);
        }
        status.setStatus("Disabling compacts and flushes for region");
        boolean wasFlushing = false;
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            this.writestate.writesEnabled = false;
            wasFlushing = this.writestate.flushing;
            LOG.debug((Object)("Closing " + this + ": disabling compactions & flushes"));
            while (this.writestate.compacting > 0 || this.writestate.flushing) {
                LOG.debug((Object)("waiting for " + this.writestate.compacting + " compactions" + (this.writestate.flushing ? " & cache flush" : "") + " to complete for region " + this));
                try {
                    this.writestate.wait();
                }
                catch (InterruptedException iex) {}
            }
        }
        if (!abort && !wasFlushing && this.worthPreFlushing()) {
            status.setStatus("Pre-flushing region before close");
            LOG.info((Object)("Running close preflush of " + this.getRegionNameAsString()));
            this.internalFlushcache(status);
        }
        this.closing.set(true);
        status.setStatus("Disabling writes for close");
        this.lock.writeLock().lock();
        try {
            if (this.isClosed()) {
                status.abort("Already got closed by another process");
                writeState = null;
                return writeState;
            }
            LOG.debug((Object)("Updates disabled for region " + this));
            if (!abort) {
                this.internalFlushcache(status);
            }
            ArrayList<StoreFile> result = new ArrayList<StoreFile>();
            for (Store store : this.stores.values()) {
                result.addAll((Collection<StoreFile>)store.close());
            }
            this.closed.set(true);
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor post-close hooks");
                this.coprocessorHost.postClose(abort);
            }
            status.markComplete("Closed");
            LOG.info((Object)("Closed " + this));
            ArrayList<StoreFile> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean worthPreFlushing() {
        return this.memstoreSize.get() > this.conf.getLong("hbase.hregion.preclose.flush.size", 0x500000L);
    }

    public byte[] getStartKey() {
        return this.regionInfo.getStartKey();
    }

    public byte[] getEndKey() {
        return this.regionInfo.getEndKey();
    }

    public long getRegionId() {
        return this.regionInfo.getRegionId();
    }

    public byte[] getRegionName() {
        return this.regionInfo.getRegionName();
    }

    public String getRegionNameAsString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public HTableDescriptor getTableDesc() {
        return this.htableDescriptor;
    }

    public HLog getLog() {
        return this.log;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Path getRegionDir() {
        return this.regiondir;
    }

    public static Path getRegionDir(Path tabledir, String name) {
        return new Path(tabledir, name);
    }

    public FileSystem getFilesystem() {
        return this.fs;
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public List<Pair<Long, Long>> getRecentFlushInfo() {
        this.lock.readLock().lock();
        List<Pair<Long, Long>> ret = this.recentFlushes;
        this.recentFlushes = new ArrayList<Pair<Long, Long>>();
        this.lock.readLock().unlock();
        return ret;
    }

    public long getLargestHStoreSize() {
        long size = 0L;
        for (Store h : this.stores.values()) {
            long storeSize = h.getSize();
            if (storeSize <= size) continue;
            size = storeSize;
        }
        return size;
    }

    void doRegionCompactionPrep() throws IOException {
    }

    private void cleanupTmpDir() throws IOException {
        FSUtils.deleteDirectory(this.fs, this.getTmpDir());
    }

    Path getTmpDir() {
        return new Path(this.getRegionDir(), ".tmp");
    }

    void triggerMajorCompaction() {
        for (Store h : this.stores.values()) {
            h.triggerMajorCompaction();
        }
    }

    void compactStores(boolean majorCompaction) throws IOException {
        if (majorCompaction) {
            this.triggerMajorCompaction();
        }
        this.compactStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactStores() throws IOException {
        for (Store s : this.getStores().values()) {
            CompactionRequest cr = s.requestCompaction();
            if (cr == null) continue;
            try {
                this.compact(cr);
            }
            finally {
                s.finishRequest(cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(CompactionRequest cr) throws IOException {
        if (cr == null) {
            return false;
        }
        if (this.closing.get() || this.closed.get()) {
            LOG.debug((Object)("Skipping compaction on " + this + " because closing/closed"));
            return false;
        }
        Preconditions.checkArgument((boolean)cr.getHRegion().equals(this));
        this.lock.readLock().lock();
        MonitoredTask status = TaskMonitor.get().createStatus("Compacting " + cr.getStore() + " in " + this);
        try {
            if (this.closed.get()) {
                LOG.debug((Object)("Skipping compaction on " + this + " because closed"));
                boolean bl = false;
                return bl;
            }
            boolean decr = true;
            try {
                WriteState writeState = this.writestate;
                synchronized (writeState) {
                    if (!this.writestate.writesEnabled) {
                        String msg = "NOT compacting region " + this + ". Writes disabled.";
                        LOG.info((Object)msg);
                        status.abort(msg);
                        decr = false;
                        boolean bl = false;
                        return bl;
                    }
                    ++this.writestate.compacting;
                }
                LOG.info((Object)("Starting compaction on " + cr.getStore() + " in region " + this));
                this.doRegionCompactionPrep();
                try {
                    status.setStatus("Compacting store " + cr.getStore());
                    cr.getStore().compact(cr);
                }
                catch (InterruptedIOException iioe) {
                    String msg = "compaction interrupted";
                    LOG.info((Object)msg, (Throwable)iioe);
                    status.abort(msg);
                    boolean bl = false;
                    if (decr) {
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            --this.writestate.compacting;
                            if (this.writestate.compacting <= 0) {
                                this.writestate.notifyAll();
                            }
                        }
                    }
                    status.cleanup();
                    this.lock.readLock().unlock();
                    return bl;
                }
            }
            finally {
                if (decr) {
                    WriteState writeState = this.writestate;
                    synchronized (writeState) {
                        --this.writestate.compacting;
                        if (this.writestate.compacting <= 0) {
                            this.writestate.notifyAll();
                        }
                    }
                }
            }
            status.markComplete("Compaction complete");
            boolean bl = true;
            return bl;
        }
        finally {
            status.cleanup();
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean flushcache() throws IOException {
        if (this.closing.get()) {
            HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closing"));
            return false;
        }
        status = TaskMonitor.get().createStatus("Flushing " + this);
        status.setStatus("Acquiring readlock on region");
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closed"));
                status.abort("Skipped: closed");
                var2_2 = false;
                return var2_2;
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor pre-flush hooks");
                this.coprocessorHost.preFlush();
            }
            if (this.numPutsWithoutWAL.get() > 0L) {
                this.numPutsWithoutWAL.set(0L);
                this.dataInMemoryWithoutWAL.set(0L);
            }
            var2_3 = this.writestate;
            synchronized (var2_3) {
                if (!this.writestate.flushing && this.writestate.writesEnabled) {
                    this.writestate.flushing = true;
                    ** break block29
                }
                if (HRegion.LOG.isDebugEnabled()) {
                    HRegion.LOG.debug((Object)("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled));
                }
                status.abort("Not flushing since " + (this.writestate.flushing != false ? "already flushing" : "writes not enabled"));
                var3_5 = false;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 11] lbl30 : MonitorExitStatement: MONITOREXIT : var2_3
                var4_7 = this.writestate;
            }
            synchronized (var4_7) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var3_5;
lbl-1000:
            // 1 sources

            {
                // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 11] lbl45 : MonitorExitStatement: MONITOREXIT : var2_3
                {
                    catch (Throwable var6_10) {
                        throw var6_10;
                    }
                }
                result = this.internalFlushcache(status);
                if (this.coprocessorHost != null) {
                    status.setStatus("Running post-flush coprocessor hooks");
                    this.coprocessorHost.postFlush();
                }
                status.markComplete("Flush successful");
                var3_6 = result;
                var4_8 = this.writestate;
            }
            synchronized (var4_8) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var3_6;
            {
                catch (Throwable var8_12) {
                    var9_13 = this.writestate;
                    synchronized (var9_13) {
                        this.writestate.flushing = false;
                        this.writestate.flushRequested = false;
                        this.writestate.notifyAll();
                    }
                    throw var8_12;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
            status.cleanup();
        }
    }

    protected boolean internalFlushcache(MonitoredTask status) throws IOException {
        return this.internalFlushcache(this.log, -1L, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalFlushcache(HLog wal, long myseqid, MonitoredTask status) throws IOException {
        long startTime;
        this.lastFlushTime = startTime = EnvironmentEdgeManager.currentTimeMillis();
        if (this.memstoreSize.get() <= 0L) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Started memstore flush for " + this + ", current region memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + (wal != null ? "" : "; wal is null, using passed sequenceid=" + myseqid)));
        }
        long sequenceId = -1L;
        long completeSequenceId = -1L;
        MultiVersionConsistencyControl.WriteEntry w = null;
        status.setStatus("Obtaining lock to block concurrent updates");
        this.updatesLock.writeLock().lock();
        long flushsize = this.memstoreSize.get();
        status.setStatus("Preparing to flush by snapshotting stores");
        ArrayList<StoreFlusher> storeFlushers = new ArrayList<StoreFlusher>(this.stores.size());
        try {
            w = this.mvcc.beginMemstoreInsert();
            this.mvcc.advanceMemstore(w);
            sequenceId = wal == null ? myseqid : wal.startCacheFlush(this.regionInfo.getEncodedNameAsBytes());
            completeSequenceId = this.getCompleteCacheFlushSequenceId(sequenceId);
            for (Store s : this.stores.values()) {
                storeFlushers.add(s.getStoreFlusher(completeSequenceId));
            }
            for (StoreFlusher flusher : storeFlushers) {
                flusher.prepare();
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        String s = "Finished snapshotting " + this + ", commencing wait for mvcc, flushsize=" + flushsize;
        status.setStatus(s);
        LOG.debug((Object)s);
        this.mvcc.waitForRead(w);
        boolean compactionRequested = false;
        try {
            for (StoreFlusher flusher : storeFlushers) {
                flusher.flushCache(status);
            }
            for (StoreFlusher flusher : storeFlushers) {
                boolean needsCompaction = flusher.commit();
                if (!needsCompaction) continue;
                compactionRequested = true;
            }
            storeFlushers.clear();
            this.addAndGetGlobalMemstoreSize(-flushsize);
        }
        catch (Throwable t) {
            if (wal != null) {
                wal.abortCacheFlush(this.regionInfo.getEncodedNameAsBytes());
            }
            DroppedSnapshotException dse = new DroppedSnapshotException("region: " + Bytes.toStringBinary(this.getRegionName()));
            dse.initCause(t);
            status.abort("Flush failed: " + StringUtils.stringifyException((Throwable)t));
            throw dse;
        }
        if (wal != null) {
            wal.completeCacheFlush(this.regionInfo.getEncodedNameAsBytes(), this.regionInfo.getTableName(), completeSequenceId, this.getRegionInfo().isMetaRegion());
        }
        HRegion t = this;
        synchronized (t) {
            this.notifyAll();
        }
        long time = EnvironmentEdgeManager.currentTimeMillis() - startTime;
        long memstoresize = this.memstoreSize.get();
        String msg = "Finished memstore flush of ~" + StringUtils.humanReadableInt((long)flushsize) + "/" + flushsize + ", currentsize=" + StringUtils.humanReadableInt((long)memstoresize) + "/" + memstoresize + " for region " + this + " in " + time + "ms, sequenceid=" + sequenceId + ", compaction requested=" + compactionRequested + (wal == null ? "; wal=null" : "");
        LOG.info((Object)msg);
        status.setStatus(msg);
        this.recentFlushes.add(new Pair<Long, Long>(time / 1000L, flushsize));
        return compactionRequested;
    }

    protected long getCompleteCacheFlushSequenceId(long currentSequenceId) {
        return currentSequenceId;
    }

    Result getClosestRowBefore(byte[] row) throws IOException {
        return this.getClosestRowBefore(row, HConstants.CATALOG_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        Result result;
        if (this.coprocessorHost != null && this.coprocessorHost.preGetClosestRowBefore(row, family, result = new Result())) {
            return result;
        }
        this.checkRow(row, "getClosestRowBefore");
        this.startRegionOperation();
        this.readRequestsCount.increment();
        try {
            Store store = this.getStore(family);
            KeyValue key = store.getRowKeyAtOrBefore(row);
            Result result2 = null;
            if (key != null) {
                Get get2 = new Get(key.getRow());
                get2.addFamily(family);
                result2 = this.get(get2, null);
            }
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postGetClosestRowBefore(row, family, result2);
            }
            Result result3 = result2;
            return result3;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public RegionScanner getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, null);
    }

    void prepareScanner(Scan scan) throws IOException {
        if (!scan.hasFamilies()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                scan.addFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegionScanner getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        this.startRegionOperation();
        this.readRequestsCount.increment();
        try {
            this.prepareScanner(scan);
            if (scan.hasFamilies()) {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            }
            RegionScanner regionScanner = this.instantiateRegionScanner(scan, additionalScanners);
            return regionScanner;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    protected RegionScanner instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        return new RegionScannerImpl(scan, additionalScanners);
    }

    private void prepareDelete(Delete delete) throws IOException {
        if (delete.getFamilyMap().isEmpty()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                delete.deleteFamily(family, delete.getTimeStamp());
            }
        } else {
            for (byte[] family : delete.getFamilyMap().keySet()) {
                if (family == null) {
                    throw new NoSuchColumnFamilyException("Empty family is invalid");
                }
                this.checkFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Delete delete, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        Integer lid = null;
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        try {
            byte[] row = delete.getRow();
            lid = this.getLock(lockid, row, true);
            try {
                this.prepareDelete(delete);
                this.internalDelete(delete, delete.getClusterId(), writeToWAL);
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public void delete(Map<byte[], List<KeyValue>> familyMap, UUID clusterId, boolean writeToWAL) throws IOException {
        Delete delete = new Delete();
        delete.setFamilyMap(familyMap);
        delete.setClusterId(clusterId);
        delete.setWriteToWAL(writeToWAL);
        this.internalDelete(delete, clusterId, writeToWAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDelete(Delete delete, UUID clusterId, boolean writeToWAL) throws IOException {
        Map<byte[], List<KeyValue>> familyMap = delete.getFamilyMap();
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null && this.coprocessorHost.preDelete(delete, walEdit, writeToWAL)) {
            return;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.updatesLock.readLock().lock();
        try {
            for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<KeyValue> kvs = e.getValue();
                TreeMap<byte[], Integer> kvCount = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                for (KeyValue kv : kvs) {
                    if (kv.isLatestTimestamp() && kv.isDeleteType()) {
                        Integer count;
                        byte[] qual = kv.getQualifier();
                        if (qual == null) {
                            qual = HConstants.EMPTY_BYTE_ARRAY;
                        }
                        if ((count = (Integer)kvCount.get(qual)) == null) {
                            kvCount.put(qual, 1);
                        } else {
                            kvCount.put(qual, count + 1);
                        }
                        count = (Integer)kvCount.get(qual);
                        Get get2 = new Get(kv.getRow());
                        get2.setMaxVersions(count);
                        get2.addColumn(family, qual);
                        List<KeyValue> result = this.get(get2, false);
                        if (result.size() < count) {
                            kv.updateLatestStamp(byteNow);
                            continue;
                        }
                        if (result.size() > count) {
                            throw new RuntimeException("Unexpected size: " + result.size());
                        }
                        KeyValue getkv = result.get(count - 1);
                        Bytes.putBytes(kv.getBuffer(), kv.getTimestampOffset(), getkv.getBuffer(), getkv.getTimestampOffset(), 8);
                        continue;
                    }
                    kv.updateLatestStamp(byteNow);
                }
            }
            if (writeToWAL) {
                this.addFamilyMapToWALEdit(familyMap, walEdit);
                this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdit, clusterId, now, this.htableDescriptor);
            }
            long addedSize = this.applyFamilyMapToMemstore(familyMap);
            flush = this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize));
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postDelete(delete, walEdit, writeToWAL);
            }
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (flush) {
            this.requestFlush();
        }
    }

    public void put(Put put) throws IOException {
        this.put(put, null, put.getWriteToWAL());
    }

    public void put(Put put, boolean writeToWAL) throws IOException {
        this.put(put, null, writeToWAL);
    }

    public void put(Put put, Integer lockid) throws IOException {
        this.put(put, lockid, put.getWriteToWAL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Put put, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        try {
            byte[] row = put.getRow();
            Integer lid = this.getLock(lockid, row, true);
            try {
                this.internalPut(put, put.getClusterId(), writeToWAL);
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public OperationStatus[] put(Put[] puts) throws IOException {
        Pair[] putsAndLocks = new Pair[puts.length];
        for (int i = 0; i < puts.length; ++i) {
            putsAndLocks[i] = new Pair<Put, Object>(puts[i], null);
        }
        return this.put(putsAndLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus[] put(Pair<Put, Integer>[] putsAndLocks) throws IOException {
        BatchOperationInProgress<Pair<Put, Integer>> batchOp = new BatchOperationInProgress<Pair<Put, Integer>>(putsAndLocks);
        while (!batchOp.isDone()) {
            long newSize;
            this.checkReadOnly();
            this.checkResources();
            this.startRegionOperation();
            this.writeRequestsCount.increment();
            try {
                long addedSize = this.doMiniBatchPut(batchOp);
                newSize = this.addAndGetGlobalMemstoreSize(addedSize);
            }
            finally {
                this.closeRegionOperation();
            }
            if (!this.isFlushSize(newSize)) continue;
            this.requestFlush();
        }
        return batchOp.retCodeDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doMiniBatchPut(BatchOperationInProgress<Pair<Put, Integer>> batchOp) throws IOException {
        long l;
        boolean success;
        int lastIndexExclusive;
        int firstIndex;
        Map[] familyMaps;
        ArrayList acquiredLocks;
        boolean locked;
        byte[] byteNow;
        long now;
        WALEdit walEdit;
        block30: {
            walEdit = new WALEdit();
            if (this.coprocessorHost != null) {
                for (int i = 0; i < ((Pair[])batchOp.operations).length; ++i) {
                    Pair nextPair = ((Pair[])batchOp.operations)[i];
                    Put put = (Put)nextPair.getFirst();
                    if (!this.coprocessorHost.prePut(put, walEdit, put.getWriteToWAL())) continue;
                    batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                }
            }
            now = EnvironmentEdgeManager.currentTimeMillis();
            byteNow = Bytes.toBytes(now);
            locked = false;
            acquiredLocks = Lists.newArrayListWithCapacity((int)((Pair[])batchOp.operations).length);
            familyMaps = new Map[((Pair[])batchOp.operations).length];
            lastIndexExclusive = firstIndex = batchOp.nextIndexToProcess;
            success = false;
            int numReadyToWrite = 0;
            while (lastIndexExclusive < ((Pair[])batchOp.operations).length) {
                Map<byte[], List<KeyValue>> familyMap;
                Pair nextPair = ((Pair[])batchOp.operations)[lastIndexExclusive];
                Put put = (Put)nextPair.getFirst();
                Integer providedLockId = (Integer)nextPair.getSecond();
                familyMaps[lastIndexExclusive] = familyMap = put.getFamilyMap();
                if (batchOp.retCodeDetails[lastIndexExclusive].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) {
                    ++lastIndexExclusive;
                    continue;
                }
                try {
                    this.checkFamilies(familyMap.keySet());
                }
                catch (NoSuchColumnFamilyException nscf) {
                    LOG.warn((Object)"No such column family in batch put", (Throwable)nscf);
                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.BAD_FAMILY, nscf.getMessage());
                    ++lastIndexExclusive;
                    continue;
                }
                boolean shouldBlock = numReadyToWrite == 0;
                Integer acquiredLockId = this.getLock(providedLockId, put.getRow(), shouldBlock);
                if (acquiredLockId == null) {
                    assert (!shouldBlock) : "Should never fail to get lock when blocking";
                    break;
                }
                if (providedLockId == null) {
                    acquiredLocks.add(acquiredLockId);
                }
                ++lastIndexExclusive;
                ++numReadyToWrite;
            }
            if (numReadyToWrite > 0) break block30;
            long nextPair = 0L;
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
            for (Integer toRelease : acquiredLocks) {
                this.releaseRowLock(toRelease);
            }
            if (!success) {
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                }
            }
            batchOp.nextIndexToProcess = lastIndexExclusive;
            return nextPair;
        }
        try {
            int i;
            int i2;
            for (i2 = firstIndex; i2 < lastIndexExclusive; ++i2) {
                if (batchOp.retCodeDetails[i2].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                this.updateKVTimestamps(familyMaps[i2].values(), byteNow);
            }
            this.updatesLock.readLock().lock();
            locked = true;
            for (i2 = firstIndex; i2 < lastIndexExclusive; ++i2) {
                if (batchOp.retCodeDetails[i2].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                Put p = (Put)((Pair[])batchOp.operations)[i2].getFirst();
                if (!p.getWriteToWAL()) {
                    this.recordPutWithoutWal(p.getFamilyMap());
                    continue;
                }
                this.addFamilyMapToWALEdit(familyMaps[i2], walEdit);
            }
            Put first = (Put)((Pair[])batchOp.operations)[firstIndex].getFirst();
            this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdit, first.getClusterId(), now, this.htableDescriptor);
            long addedSize = 0L;
            for (i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                addedSize += this.applyFamilyMapToMemstore(familyMaps[i]);
                batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
            }
            if (this.coprocessorHost != null) {
                for (i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
                    Put p = (Put)((Pair[])batchOp.operations)[i].getFirst();
                    this.coprocessorHost.postPut(p, walEdit, p.getWriteToWAL());
                }
            }
            success = true;
            l = addedSize;
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
        }
        catch (Throwable throwable) {
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
            for (Integer toRelease : acquiredLocks) {
                this.releaseRowLock(toRelease);
            }
            if (!success) {
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                }
            }
            batchOp.nextIndexToProcess = lastIndexExclusive;
            throw throwable;
        }
        for (Integer toRelease : acquiredLocks) {
            this.releaseRowLock(toRelease);
        }
        if (!success) {
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
            }
        }
        batchOp.nextIndexToProcess = lastIndexExclusive;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Writable w, Integer lockId, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        boolean isPut = w instanceof Put;
        if (!isPut && !(w instanceof Delete)) {
            throw new DoNotRetryIOException("Action must be Put or Delete");
        }
        Row r = (Row)w;
        if (!Bytes.equals(row, r.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        try {
            boolean bl;
            Integer lid;
            block28: {
                RowLock lock = isPut ? ((Put)w).getRowLock() : ((Delete)w).getRowLock();
                Get get2 = new Get(row, lock);
                this.checkFamily(family);
                get2.addColumn(family, qualifier);
                lid = this.getLock(lockId, get2.getRow(), true);
                List<Object> result = new ArrayList();
                try {
                    result = this.get(get2, false);
                    boolean valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                    boolean matches = false;
                    if (result.size() == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() > 0 && ((KeyValue)result.get(0)).getValue().length == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() == 1 && !valueIsNull) {
                        int compareResult = comparator.compareTo(((KeyValue)result.get(0)).getValue());
                        switch (compareOp) {
                            case LESS: {
                                matches = compareResult <= 0;
                                break;
                            }
                            case LESS_OR_EQUAL: {
                                matches = compareResult < 0;
                                break;
                            }
                            case EQUAL: {
                                matches = compareResult == 0;
                                break;
                            }
                            case NOT_EQUAL: {
                                matches = compareResult != 0;
                                break;
                            }
                            case GREATER_OR_EQUAL: {
                                matches = compareResult > 0;
                                break;
                            }
                            case GREATER: {
                                matches = compareResult >= 0;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown Compare op " + compareOp.name());
                            }
                        }
                    }
                    if (!matches) break block28;
                    if (isPut) {
                        this.internalPut((Put)w, HConstants.DEFAULT_CLUSTER_ID, writeToWAL);
                    } else {
                        Delete d = (Delete)w;
                        this.prepareDelete(d);
                        this.internalDelete(d, HConstants.DEFAULT_CLUSTER_ID, writeToWAL);
                    }
                    bl = true;
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    throw throwable;
                }
            }
            bl = false;
            if (lockId == null) {
                this.releaseRowLock(lid);
            }
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void updateKVTimestamps(Iterable<List<KeyValue>> keyLists, byte[] now) {
        for (List<KeyValue> keys : keyLists) {
            if (keys == null) continue;
            for (KeyValue key : keys) {
                key.updateLatestStamp(now);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResources() {
        if (this.getRegionInfo().isMetaRegion()) {
            return;
        }
        boolean blocked = false;
        while (this.memstoreSize.get() > this.blockingMemStoreSize) {
            this.requestFlush();
            if (!blocked) {
                LOG.info((Object)("Blocking updates for '" + Thread.currentThread().getName() + "' on region " + Bytes.toStringBinary(this.getRegionName()) + ": memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + " is >= than blocking " + StringUtils.humanReadableInt((long)this.blockingMemStoreSize) + " size"));
            }
            blocked = true;
            HRegion hRegion = this;
            synchronized (hRegion) {
                try {
                    this.wait(this.threadWakeFrequency);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (blocked) {
            LOG.info((Object)("Unblocking updates for region " + this + " '" + Thread.currentThread().getName() + "'"));
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.writestate.isReadOnly()) {
            throw new IOException("region is read only");
        }
    }

    private void put(byte[] family, List<KeyValue> edits) throws IOException {
        HashMap<byte[], List<KeyValue>> familyMap = new HashMap<byte[], List<KeyValue>>();
        familyMap.put(family, edits);
        Put p = new Put();
        p.setFamilyMap(familyMap);
        p.setClusterId(HConstants.DEFAULT_CLUSTER_ID);
        p.setWriteToWAL(true);
        this.internalPut(p, HConstants.DEFAULT_CLUSTER_ID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPut(Put put, UUID clusterId, boolean writeToWAL) throws IOException {
        Map<byte[], List<KeyValue>> familyMap = put.getFamilyMap();
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null && this.coprocessorHost.prePut(put, walEdit, writeToWAL)) {
            return;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.updatesLock.readLock().lock();
        try {
            this.checkFamilies(familyMap.keySet());
            this.updateKVTimestamps(familyMap.values(), byteNow);
            if (writeToWAL) {
                this.addFamilyMapToWALEdit(familyMap, walEdit);
                this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdit, clusterId, now, this.htableDescriptor);
            } else {
                this.recordPutWithoutWal(familyMap);
            }
            long addedSize = this.applyFamilyMapToMemstore(familyMap);
            flush = this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize));
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postPut(put, walEdit, writeToWAL);
        }
        if (flush) {
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyFamilyMapToMemstore(Map<byte[], List<KeyValue>> familyMap) {
        MultiVersionConsistencyControl.WriteEntry w = null;
        long size = 0L;
        try {
            w = this.mvcc.beginMemstoreInsert();
            for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<KeyValue> edits = e.getValue();
                Store store = this.getStore(family);
                for (KeyValue kv : edits) {
                    kv.setMemstoreTS(w.getWriteNumber());
                    size += store.add(kv);
                }
            }
        }
        finally {
            this.mvcc.completeMemstoreInsert(w);
        }
        return size;
    }

    private void checkFamilies(Collection<byte[]> families) throws NoSuchColumnFamilyException {
        for (byte[] family : families) {
            this.checkFamily(family);
        }
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<KeyValue>> familyMap, WALEdit walEdit) {
        for (List<KeyValue> edits : familyMap.values()) {
            for (KeyValue kv : edits) {
                walEdit.add(kv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush() {
        if (this.rsServices == null) {
            return;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.isFlushRequested()) {
                return;
            }
            this.writestate.flushRequested = true;
        }
        this.rsServices.getFlushRequester().requestFlush(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Flush requested on " + this));
        }
    }

    private boolean isFlushSize(long size) {
        return size > this.memstoreFlushSize;
    }

    protected long replayRecoveredEditsIfAny(Path regiondir, long minSeqId, CancelableProgressable reporter, MonitoredTask status) throws UnsupportedEncodingException, IOException {
        long seqid = minSeqId;
        NavigableSet<Path> files = HLog.getSplitEditFilesSorted(this.fs, regiondir);
        if (files == null || files.isEmpty()) {
            return seqid;
        }
        boolean checkSafeToSkip = true;
        for (Path edits : files) {
            if (edits == null || !this.fs.exists(edits)) {
                LOG.warn((Object)("Null or non-existent edits file: " + edits));
                continue;
            }
            if (HRegion.isZeroLengthThenDelete(this.fs, edits)) continue;
            if (checkSafeToSkip) {
                Path higher = files.higher(edits);
                long maxSeqId = Long.MAX_VALUE;
                if (higher != null) {
                    String fileName = higher.getName();
                    maxSeqId = Math.abs(Long.parseLong(fileName));
                }
                if (maxSeqId <= minSeqId) {
                    String msg = "Maximum possible sequenceid for this log is " + maxSeqId + ", skipped the whole file, path=" + edits;
                    LOG.debug((Object)msg);
                    continue;
                }
                checkSafeToSkip = false;
            }
            try {
                seqid = this.replayRecoveredEdits(edits, seqid, reporter);
            }
            catch (IOException e) {
                boolean skipErrors = this.conf.getBoolean("hbase.skip.errors", false);
                if (skipErrors) {
                    Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                    LOG.error((Object)("hbase.skip.errors=true so continuing. Renamed " + edits + " as " + p), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        if (seqid > minSeqId) {
            this.internalFlushcache(null, seqid, status);
        }
        for (Path file : files) {
            if (!this.fs.delete(file, false)) {
                LOG.error((Object)("Failed delete of " + file));
                continue;
            }
            LOG.debug((Object)("Deleted recovered.edits file=" + file));
        }
        return seqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replayRecoveredEdits(Path edits, long minSeqId, CancelableProgressable reporter) throws IOException {
        String msg = "Replaying edits from " + edits + "; minSequenceid=" + minSeqId + "; path=" + edits;
        LOG.info((Object)msg);
        MonitoredTask status = TaskMonitor.get().createStatus(msg);
        status.setStatus("Opening logs");
        HLog.Reader reader = null;
        try {
            reader = HLog.getReader(this.fs, edits, this.conf);
            long currentEditSeqId = minSeqId;
            long firstSeqIdInLog = -1L;
            long skippedEdits = 0L;
            long editsCount = 0L;
            long intervalEdits = 0L;
            Store store = null;
            boolean reported_once = false;
            try {
                HLog.Entry entry;
                int interval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
                int period = this.conf.getInt("hbase.hstore.report.period", this.conf.getInt("hbase.master.assignment.timeoutmonitor.timeout", 180000) / 2);
                long lastReport = EnvironmentEdgeManager.currentTimeMillis();
                while ((entry = reader.next()) != null) {
                    HLogKey key = entry.getKey();
                    WALEdit val = entry.getEdit();
                    if (reporter != null && (intervalEdits += (long)val.size()) >= (long)interval) {
                        intervalEdits = 0L;
                        long cur = EnvironmentEdgeManager.currentTimeMillis();
                        if (lastReport + (long)period <= cur) {
                            status.setStatus("Replaying edits... skipped=" + skippedEdits + " edits=" + editsCount);
                            if (!reporter.progress()) {
                                msg = "Progressable reporter failed, stopping replay";
                                LOG.warn((Object)msg);
                                status.abort(msg);
                                throw new IOException(msg);
                            }
                            reported_once = true;
                            lastReport = cur;
                        }
                    }
                    if (this.coprocessorHost != null) {
                        status.setStatus("Running pre-WAL-restore hook in coprocessors");
                        if (this.coprocessorHost.preWALRestore(this.getRegionInfo(), key, val)) continue;
                    }
                    if (firstSeqIdInLog == -1L) {
                        firstSeqIdInLog = key.getLogSeqNum();
                    }
                    if (key.getLogSeqNum() <= currentEditSeqId) {
                        ++skippedEdits;
                        continue;
                    }
                    currentEditSeqId = key.getLogSeqNum();
                    boolean flush = false;
                    for (KeyValue kv : val.getKeyValues()) {
                        if (kv.matchingFamily(HLog.METAFAMILY) || !Bytes.equals(key.getEncodedRegionName(), this.regionInfo.getEncodedNameAsBytes())) {
                            ++skippedEdits;
                            continue;
                        }
                        if (store == null || !kv.matchingFamily(store.getFamily().getName())) {
                            store = this.stores.get(kv.getFamily());
                        }
                        if (store == null) {
                            LOG.warn((Object)("No family for " + kv));
                            ++skippedEdits;
                            continue;
                        }
                        flush = this.restoreEdit(store, kv);
                        ++editsCount;
                    }
                    if (flush) {
                        this.internalFlushcache(null, currentEditSeqId, status);
                    }
                    if (this.coprocessorHost == null) continue;
                    this.coprocessorHost.postWALRestore(this.getRegionInfo(), key, val);
                }
            }
            catch (EOFException eof) {
                Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                msg = "Encountered EOF. Most likely due to Master failure during log spliting, so we have this data in another edit.  Continuing, but renaming " + edits + " as " + p;
                LOG.warn((Object)msg, (Throwable)eof);
                status.abort(msg);
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof ParseException) {
                    Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                    msg = "File corruption encountered!  Continuing, but renaming " + edits + " as " + p;
                    LOG.warn((Object)msg, (Throwable)ioe);
                    status.setStatus(msg);
                }
                status.abort(StringUtils.stringifyException((Throwable)ioe));
                throw ioe;
            }
            if (reporter != null && !reported_once) {
                reporter.progress();
            }
            msg = "Applied " + editsCount + ", skipped " + skippedEdits + ", firstSequenceidInLog=" + firstSeqIdInLog + ", maxSequenceidInLog=" + currentEditSeqId + ", path=" + edits;
            status.markComplete(msg);
            LOG.debug((Object)msg);
            long l = currentEditSeqId;
            return l;
        }
        finally {
            status.cleanup();
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected boolean restoreEdit(Store s, KeyValue kv) {
        return this.isFlushSize(this.addAndGetGlobalMemstoreSize(s.add(kv)));
    }

    private static boolean isZeroLengthThenDelete(FileSystem fs, Path p) throws IOException {
        FileStatus stat = fs.getFileStatus(p);
        if (stat.getLen() > 0L) {
            return false;
        }
        LOG.warn((Object)("File " + p + " is zero-length, deleting."));
        fs.delete(p, false);
        return true;
    }

    protected Store instantiateHStore(Path tableDir, HColumnDescriptor c) throws IOException {
        return new Store(tableDir, this, c, this.fs, this.conf);
    }

    public Store getStore(byte[] column) {
        return this.stores.get(column);
    }

    public Map<byte[], Store> getStores() {
        return this.stores;
    }

    void checkRow(byte[] row, String op) throws IOException {
        if (!HRegion.rowIsInRange(this.regionInfo, row)) {
            throw new WrongRegionException("Requested row out of range for " + op + " on HRegion " + this + ", startKey='" + Bytes.toStringBinary(this.regionInfo.getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary(this.regionInfo.getEndKey()) + "', row='" + Bytes.toStringBinary(row) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer obtainRowLock(byte[] row) throws IOException {
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        try {
            Integer n = this.internalObtainRowLock(row, true);
            return n;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer internalObtainRowLock(byte[] row, boolean waitForLock) throws IOException {
        this.checkRow(row, "row lock");
        this.startRegionOperation();
        try {
            rowKey = new HashedBytes(row);
            rowLatch = new CountDownLatch(1);
            while ((existingLatch = this.lockedRows.putIfAbsent(rowKey, rowLatch)) != null) {
                if (!waitForLock) {
                    var6_7 = null;
                    this.closeRegionOperation();
                    return var6_7;
                }
                if (existingLatch.await(this.rowLockWaitDuration, TimeUnit.MILLISECONDS)) continue;
                var6_8 = null;
                this.closeRegionOperation();
                return var6_8;
            }
            while (true) {
                if ((existingRowKey = this.lockIds.putIfAbsent(lockId = Integer.valueOf(this.lockIdGenerator.incrementAndGet()), rowKey)) != null) ** break block9
                var7_10 = lockId;
                this.closeRegionOperation();
                return var7_10;
            }
        }
        catch (Throwable var8_11) {
            this.closeRegionOperation();
            throw var8_11;
        }
        {
            this.lockIdGenerator.set(HRegion.rand.nextInt());
            continue;
        }
    }

    byte[] getRowFromLock(Integer lockid) {
        HashedBytes rowKey = this.lockIds.get(lockid);
        return rowKey == null ? null : rowKey.getBytes();
    }

    public void releaseRowLock(Integer lockId) {
        HashedBytes rowKey = this.lockIds.remove(lockId);
        if (rowKey == null) {
            LOG.warn((Object)("Release unknown lockId: " + lockId));
            return;
        }
        CountDownLatch rowLatch = this.lockedRows.remove(rowKey);
        if (rowLatch == null) {
            LOG.error((Object)("Releases row not locked, lockId: " + lockId + " row: " + rowKey));
            return;
        }
        rowLatch.countDown();
    }

    boolean isRowLocked(Integer lockId) {
        return this.lockIds.containsKey(lockId);
    }

    private Integer getLock(Integer lockid, byte[] row, boolean waitForLock) throws IOException {
        Integer lid = null;
        if (lockid == null) {
            lid = this.internalObtainRowLock(row, waitForLock);
        } else {
            if (!this.isRowLocked(lockid)) {
                throw new IOException("Invalid row lock");
            }
            lid = lockid;
        }
        return lid;
    }

    private static boolean hasMultipleColumnFamilies(List<Pair<byte[], String>> familyPaths) {
        boolean multipleFamilies = false;
        byte[] family = null;
        for (Pair<byte[], String> pair : familyPaths) {
            byte[] fam = pair.getFirst();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals(family, fam)) continue;
            multipleFamilies = true;
            break;
        }
        return multipleFamilies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths) throws IOException {
        Preconditions.checkNotNull(familyPaths);
        this.startBulkRegionOperation(HRegion.hasMultipleColumnFamilies(familyPaths));
        try {
            Store store;
            String path;
            this.writeRequestsCount.increment();
            ArrayList<IOException> ioes = new ArrayList<IOException>();
            ArrayList<Pair<byte[], String>> failures = new ArrayList<Pair<byte[], String>>();
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = p.getFirst();
                path = p.getSecond();
                store = this.getStore(byArray);
                if (store == null) {
                    DoNotRetryIOException ioe = new DoNotRetryIOException("No such column family " + Bytes.toStringBinary(byArray));
                    ioes.add(ioe);
                    failures.add(p);
                    continue;
                }
                try {
                    store.assertBulkLoadHFileOk(new Path(path));
                }
                catch (WrongRegionException wre) {
                    failures.add(p);
                }
                catch (IOException ioe) {
                    ioes.add(ioe);
                }
            }
            if (failures.size() != 0) {
                StringBuilder list = new StringBuilder();
                for (Pair pair : failures) {
                    list.append("\n").append(Bytes.toString((byte[])pair.getFirst())).append(" : ").append((String)pair.getSecond());
                }
                LOG.warn((Object)("There was a recoverable bulk load failure likely due to a split.  These (family, HFile) pairs were not loaded: " + list));
                boolean i$ = false;
                return i$;
            }
            if (ioes.size() != 0) {
                LOG.error((Object)"There were IO errors when checking if bulk load is ok.  throwing exception!");
                throw MultipleIOException.createIOException(ioes);
            }
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = p.getFirst();
                path = p.getSecond();
                store = this.getStore(byArray);
                try {
                    store.bulkLoadHFile(path);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("There was a partial failure due to IO when attempting to load " + Bytes.toString(p.getFirst()) + " : " + p.getSecond()));
                    throw ioe;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeBulkRegionOperation();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HRegion)) {
            return false;
        }
        return Bytes.equals(this.getRegionName(), ((HRegion)o).getRegionName());
    }

    public int hashCode() {
        return Bytes.hashCode(this.getRegionName());
    }

    public String toString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public Path getTableDir() {
        return this.tableDir;
    }

    public static HRegion newHRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, HLog.class, FileSystem.class, Configuration.class, HRegionInfo.class, HTableDescriptor.class, RegionServerServices.class);
            return (HRegion)c.newInstance(new Object[]{tableDir, log, fs, conf, regionInfo, htd, rsServices});
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, null);
    }

    public static void closeHRegion(HRegion r) throws IOException {
        if (r == null) {
            return;
        }
        r.close();
        if (r.getLog() == null) {
            return;
        }
        r.getLog().closeAndDelete();
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog) throws IOException {
        LOG.info((Object)("creating HRegion " + info.getTableNameAsString() + " HTD == " + hTableDescriptor + " RootDir = " + rootDir + " Table name == " + info.getTableNameAsString()));
        Path tableDir = HTableDescriptor.getTableDir(rootDir, info.getTableName());
        Path regionDir = HRegion.getRegionDir(tableDir, info.getEncodedName());
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(regionDir);
        HLog effectiveHLog = hlog;
        if (hlog == null) {
            effectiveHLog = new HLog(fs, new Path(regionDir, ".logs"), new Path(regionDir, ".oldlogs"), conf);
        }
        HRegion region = HRegion.newHRegion(tableDir, effectiveHLog, fs, conf, info, hTableDescriptor, null);
        region.initialize();
        return region;
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + (Object)((Object)info)));
        }
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        Path dir = HTableDescriptor.getTableDir(FSUtils.getRootDir(conf), info.getTableName());
        HRegion r = HRegion.newHRegion(dir, wal, FileSystem.get((Configuration)conf), conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    public static HRegion openHRegion(Path tableDir, HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(tableDir, info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(Path tableDir, HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        LOG.info((Object)("HRegion.openHRegion Region name ==" + info.getRegionNameAsString()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + (Object)((Object)info)));
        }
        Path dir = HTableDescriptor.getTableDir(tableDir, info.getTableName());
        HRegion r = HRegion.newHRegion(dir, wal, FileSystem.get((Configuration)conf), conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    protected HRegion openHRegion(CancelableProgressable reporter) throws IOException {
        this.checkCompressionCodecs();
        long seqid = this.initialize(reporter);
        if (this.log != null) {
            this.log.setSequenceNumber(seqid);
        }
        return this;
    }

    private void checkCompressionCodecs() throws IOException {
        for (HColumnDescriptor fam : this.htableDescriptor.getColumnFamilies()) {
            CompressionTest.testCompression(fam.getCompression());
            CompressionTest.testCompression(fam.getCompactionCompression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionName();
        Integer lid = meta.obtainRowLock(row);
        try {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            ArrayList<KeyValue> edits = new ArrayList<KeyValue>(2);
            edits.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, now, Writables.getBytes((Writable)r.getRegionInfo())));
            edits.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, now, Bytes.toBytes((short)0)));
            meta.put(HConstants.CATALOG_FAMILY, edits);
        }
        finally {
            meta.releaseRowLock(lid);
        }
    }

    public static void deleteRegion(FileSystem fs, Path rootdir, HRegionInfo info) throws IOException {
        HRegion.deleteRegion(fs, HRegion.getRegionDir(rootdir, info));
    }

    private static void deleteRegion(FileSystem fs, Path regiondir) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETING region " + regiondir.toString()));
        }
        if (!fs.delete(regiondir, true)) {
            LOG.warn((Object)("Failed delete of " + regiondir));
        }
    }

    public static Path getRegionDir(Path rootdir, HRegionInfo info) {
        return new Path(HTableDescriptor.getTableDir(rootdir, info.getTableName()), info.getEncodedName());
    }

    public static boolean rowIsInRange(HRegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo(info.getStartKey(), row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo(info.getEndKey(), row) <= 0);
    }

    public static void makeColumnFamilyDirs(FileSystem fs, Path tabledir, HRegionInfo hri, byte[] colFamily) throws IOException {
        Path dir = Store.getStoreHomedir(tabledir, hri.getEncodedName(), colFamily);
        if (!fs.mkdirs(dir)) {
            LOG.warn((Object)("Failed to create " + dir));
        }
    }

    public static HRegion mergeAdjacent(HRegion srcA, HRegion srcB) throws IOException {
        HRegion a = srcA;
        HRegion b = srcB;
        if (srcA.getStartKey() == null) {
            if (srcB.getStartKey() == null) {
                throw new IOException("Cannot merge two regions with null start key");
            }
        } else if (srcB.getStartKey() == null || Bytes.compareTo(srcA.getStartKey(), srcB.getStartKey()) > 0) {
            a = srcB;
            b = srcA;
        }
        if (Bytes.compareTo(a.getEndKey(), b.getStartKey()) != 0) {
            throw new IOException("Cannot merge non-adjacent regions");
        }
        return HRegion.merge(a, b);
    }

    public static HRegion merge(HRegion a, HRegion b) throws IOException {
        byte[] startKey;
        if (!a.getRegionInfo().getTableNameAsString().equals(b.getRegionInfo().getTableNameAsString())) {
            throw new IOException("Regions do not belong to the same table");
        }
        FileSystem fs = a.getFilesystem();
        a.flushcache();
        b.flushcache();
        a.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + a));
            HRegion.listPaths(fs, a.getRegionDir());
        }
        b.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + b));
            HRegion.listPaths(fs, b.getRegionDir());
        }
        Configuration conf = a.getConf();
        HTableDescriptor tabledesc = a.getTableDesc();
        HLog log = a.getLog();
        Path tableDir = a.getTableDir();
        byte[] byArray = a.comparator.matchingRows(a.getStartKey(), 0, a.getStartKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) || b.comparator.matchingRows(b.getStartKey(), 0, b.getStartKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) ? HConstants.EMPTY_BYTE_ARRAY : (startKey = a.comparator.compareRows(a.getStartKey(), 0, a.getStartKey().length, b.getStartKey(), 0, b.getStartKey().length) <= 0 ? a.getStartKey() : b.getStartKey());
        byte[] endKey = a.comparator.matchingRows(a.getEndKey(), 0, a.getEndKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) || a.comparator.matchingRows(b.getEndKey(), 0, b.getEndKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) ? HConstants.EMPTY_BYTE_ARRAY : (a.comparator.compareRows(a.getEndKey(), 0, a.getEndKey().length, b.getEndKey(), 0, b.getEndKey().length) <= 0 ? b.getEndKey() : a.getEndKey());
        HRegionInfo newRegionInfo = new HRegionInfo(tabledesc.getName(), startKey, endKey);
        LOG.info((Object)("Creating new region " + newRegionInfo.toString()));
        String encodedName = newRegionInfo.getEncodedName();
        Path newRegionDir = HRegion.getRegionDir(a.getTableDir(), encodedName);
        if (fs.exists(newRegionDir)) {
            throw new IOException("Cannot merge; target file collision at " + newRegionDir);
        }
        fs.mkdirs(newRegionDir);
        LOG.info((Object)("starting merge of regions: " + a + " and " + b + " into new region " + newRegionInfo.toString() + " with start key <" + Bytes.toStringBinary(startKey) + "> and end key <" + Bytes.toStringBinary(endKey) + ">"));
        Map<byte[], List<StoreFile>> byFamily = new TreeMap<byte[], List<StoreFile>>(Bytes.BYTES_COMPARATOR);
        byFamily = HRegion.filesByFamily(byFamily, a.close());
        byFamily = HRegion.filesByFamily(byFamily, b.close());
        for (Map.Entry<byte[], List<StoreFile>> es : byFamily.entrySet()) {
            long seqB;
            long seqA;
            byte[] colFamily = es.getKey();
            HRegion.makeColumnFamilyDirs(fs, tableDir, newRegionInfo, colFamily);
            List<StoreFile> srcFiles = es.getValue();
            if (srcFiles.size() == 2 && (seqA = srcFiles.get(0).getMaxSequenceId()) == (seqB = srcFiles.get(1).getMaxSequenceId())) {
                throw new IOException("Files have same sequenceid: " + seqA);
            }
            for (StoreFile hsf : srcFiles) {
                StoreFile.rename(fs, hsf.getPath(), StoreFile.getUniqueFile(fs, Store.getStoreHomedir(tableDir, newRegionInfo.getEncodedName(), colFamily)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, newRegionDir);
        }
        HRegion dstRegion = HRegion.newHRegion(tableDir, log, fs, conf, newRegionInfo, a.getTableDesc(), null);
        dstRegion.readRequestsCount.set(a.readRequestsCount.get() + b.readRequestsCount.get());
        dstRegion.writeRequestsCount.set(a.writeRequestsCount.get() + b.writeRequestsCount.get());
        dstRegion.initialize();
        dstRegion.compactStores();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, dstRegion.getRegionDir());
        }
        HRegion.deleteRegion(fs, a.getRegionDir());
        HRegion.deleteRegion(fs, b.getRegionDir());
        LOG.info((Object)("merge completed. New region is " + dstRegion));
        return dstRegion;
    }

    private static Map<byte[], List<StoreFile>> filesByFamily(Map<byte[], List<StoreFile>> byFamily, List<StoreFile> storeFiles) {
        for (StoreFile src : storeFiles) {
            byte[] family = src.getFamily();
            List<StoreFile> v = byFamily.get(family);
            if (v == null) {
                v = new ArrayList<StoreFile>();
                byFamily.put(family, v);
            }
            v.add(src);
        }
        return byFamily;
    }

    boolean isMajorCompaction() throws IOException {
        for (Store store : this.stores.values()) {
            if (!store.isMajorCompaction()) continue;
            return true;
        }
        return false;
    }

    private static void listPaths(FileSystem fs, Path dir) throws IOException {
        if (LOG.isDebugEnabled()) {
            FileStatus[] stats = FSUtils.listStatus(fs, dir, null);
            if (stats == null || stats.length == 0) {
                return;
            }
            for (int i = 0; i < stats.length; ++i) {
                String path = stats[i].getPath().toString();
                if (stats[i].isDir()) {
                    LOG.debug((Object)("d " + path));
                    HRegion.listPaths(fs, stats[i].getPath());
                    continue;
                }
                LOG.debug((Object)("f " + path + " size=" + stats[i].getLen()));
            }
        }
    }

    public Result get(Get get2, Integer lockid) throws IOException {
        this.checkRow(get2.getRow(), "Get");
        if (get2.hasFamilies()) {
            for (byte[] family : get2.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                get2.addFamily(family);
            }
        }
        List<KeyValue> results = this.get(get2, true);
        return new Result(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValue> getLastIncrement(Get get2) throws IOException {
        InternalScan iscan = new InternalScan(get2);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        iscan.checkOnlyMemStore();
        RegionScanner scanner = null;
        try {
            scanner = this.getScanner(iscan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        int expected = 0;
        Map<byte[], NavigableSet<byte[]>> familyMap = get2.getFamilyMap();
        for (NavigableSet<byte[]> qfs : familyMap.values()) {
            expected += qfs.size();
        }
        if (results.size() == expected) {
            return results;
        }
        if (results != null && !results.isEmpty()) {
            for (KeyValue kv : results) {
                byte[] family = kv.getFamily();
                NavigableSet<byte[]> qfs = familyMap.get(family);
                qfs.remove(kv.getQualifier());
                if (qfs.isEmpty()) {
                    familyMap.remove(family);
                }
                --expected;
            }
            Get newGet = new Get(get2.getRow());
            for (Map.Entry<byte[], NavigableSet<byte[]>> f : familyMap.entrySet()) {
                byte[] family = f.getKey();
                for (byte[] qualifier : f.getValue()) {
                    newGet.addColumn(family, qualifier);
                }
            }
            newGet.setTimeRange(get2.getTimeRange().getMin(), get2.getTimeRange().getMax());
            iscan = new InternalScan(newGet);
        }
        ArrayList<KeyValue> fileResults = new ArrayList<KeyValue>();
        iscan.checkOnlyStoreFiles();
        scanner = null;
        try {
            scanner = this.getScanner(iscan);
            scanner.next(fileResults);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        results.addAll(fileResults);
        Collections.sort(results, KeyValue.COMPARATOR);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValue> get(Get get2, boolean withCoprocessor) throws IOException {
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        if (withCoprocessor && this.coprocessorHost != null && this.coprocessorHost.preGet(get2, results)) {
            return results;
        }
        Scan scan = new Scan(get2);
        RegionScanner scanner = null;
        try {
            scanner = this.getScanner(scan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        if (withCoprocessor && this.coprocessorHost != null) {
            this.coprocessorHost.postGet(get2, results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result increment(Increment increment, Integer lockid, boolean writeToWAL) throws IOException {
        byte[] row = increment.getRow();
        this.checkRow(row, "increment");
        TimeRange tr = increment.getTimeRange();
        boolean flush = false;
        WALEdit walEdits = null;
        ArrayList<KeyValue> allKVs = new ArrayList<KeyValue>(increment.numColumns());
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(increment.numColumns());
        long now = EnvironmentEdgeManager.currentTimeMillis();
        long size = 0L;
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        try {
            Integer lid = this.getLock(lockid, row, true);
            this.updatesLock.readLock().lock();
            try {
                for (Map.Entry<byte[], NavigableMap<byte[], Long>> family : increment.getFamilyMap().entrySet()) {
                    Store store = this.stores.get(family.getKey());
                    Get get2 = new Get(row);
                    for (Map.Entry column : family.getValue().entrySet()) {
                        get2.addColumn(family.getKey(), (byte[])column.getKey());
                    }
                    get2.setTimeRange(tr.getMin(), tr.getMax());
                    List<KeyValue> results = this.getLastIncrement(get2);
                    int idx = 0;
                    for (Map.Entry column : family.getValue().entrySet()) {
                        long amount = (Long)column.getValue();
                        if (idx < results.size() && results.get(idx).matchingQualifier((byte[])column.getKey())) {
                            amount += Bytes.toLong(results.get(idx).getValue());
                            ++idx;
                        }
                        KeyValue newKV = new KeyValue(row, family.getKey(), (byte[])column.getKey(), now, Bytes.toBytes(amount));
                        kvs.add(newKV);
                        if (!writeToWAL) continue;
                        if (walEdits == null) {
                            walEdits = new WALEdit();
                        }
                        walEdits.add(newKV);
                    }
                    size += store.upsert(kvs);
                    allKVs.addAll(kvs);
                    kvs.clear();
                }
                if (writeToWAL) {
                    this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdits, HConstants.DEFAULT_CLUSTER_ID, now, this.htableDescriptor);
                }
                size = this.addAndGetGlobalMemstoreSize(size);
                flush = this.isFlushSize(size);
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
        }
        finally {
            this.closeRegionOperation();
        }
        if (flush) {
            this.requestFlush();
        }
        return new Result(allKVs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkRow(row, "increment");
        boolean flush = false;
        boolean wrongLength = false;
        long result = amount;
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        try {
            Integer lid = this.obtainRowLock(row);
            this.updatesLock.readLock().lock();
            try {
                Store store = this.stores.get(family);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                List<KeyValue> results = this.getLastIncrement(get2);
                if (!results.isEmpty()) {
                    KeyValue kv = results.get(0);
                    if (kv.getValueLength() == 8) {
                        byte[] buffer = kv.getBuffer();
                        int valueOffset = kv.getValueOffset();
                        result += Bytes.toLong(buffer, valueOffset, 8);
                    } else {
                        wrongLength = true;
                    }
                }
                if (!wrongLength) {
                    KeyValue newKv = new KeyValue(row, family, qualifier, EnvironmentEdgeManager.currentTimeMillis(), Bytes.toBytes(result));
                    if (writeToWAL) {
                        long now = EnvironmentEdgeManager.currentTimeMillis();
                        WALEdit walEdit = new WALEdit();
                        walEdit.add(newKv);
                        this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdit, HConstants.DEFAULT_CLUSTER_ID, now, this.htableDescriptor);
                    }
                    long size = store.updateColumnValue(row, family, qualifier, result);
                    size = this.addAndGetGlobalMemstoreSize(size);
                    flush = this.isFlushSize(size);
                }
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
        }
        finally {
            this.closeRegionOperation();
        }
        if (flush) {
            this.requestFlush();
        }
        if (wrongLength) {
            throw new IOException("Attempted to increment field that isn't 64 bits wide");
        }
        return result;
    }

    private void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.htableDescriptor.hasFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString(family) + " does not exist in region " + this + " in table " + this.htableDescriptor);
        }
    }

    @Override
    public long heapSize() {
        long heapSize = DEEP_OVERHEAD;
        for (Store store : this.stores.values()) {
            heapSize += store.heapSize();
        }
        return heapSize;
    }

    private void recordPutWithoutWal(Map<byte[], List<KeyValue>> familyMap) {
        if (this.numPutsWithoutWAL.getAndIncrement() == 0L) {
            LOG.info((Object)("writing data to region " + this + " with WAL disabled. Data may be lost in the event of a crash."));
        }
        long putSize = 0L;
        for (List<KeyValue> edits : familyMap.values()) {
            for (KeyValue kv : edits) {
                putSize += kv.heapSize();
            }
        }
        this.dataInMemoryWithoutWAL.addAndGet(putSize);
    }

    private static void printUsageAndExit(String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println("Usage: HRegion CATLALOG_TABLE_DIR [major_compact]");
        System.out.println("Options:");
        System.out.println(" major_compact  Pass this option to major compact passed region.");
        System.out.println("Default outputs scan of passed region.");
        System.exit(1);
    }

    public <T extends CoprocessorProtocol> boolean registerProtocol(Class<T> protocol, T handler) {
        if (this.protocolHandlers.containsKey(protocol)) {
            LOG.error((Object)("Protocol " + protocol.getName() + " already registered, rejecting request from " + handler));
            return false;
        }
        this.protocolHandlers.putInstance(protocol, handler);
        this.protocolHandlerNames.put(protocol.getName(), protocol);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered protocol handler: region=" + Bytes.toStringBinary(this.getRegionName()) + " protocol=" + protocol.getName()));
        }
        return true;
    }

    public ExecResult exec(Exec call) throws IOException {
        Object value;
        Class<? extends CoprocessorProtocol> protocol = call.getProtocol();
        if (protocol == null) {
            String protocolName = call.getProtocolName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received dynamic protocol exec call with protocolName " + protocolName));
            }
            if ((protocol = this.protocolHandlerNames.get(protocolName)) == null) {
                throw new HBaseRPC.UnknownProtocolException(protocol, "No matching handler for protocol " + protocolName + " in region " + Bytes.toStringBinary(this.getRegionName()));
            }
        }
        if (!this.protocolHandlers.containsKey(protocol)) {
            throw new HBaseRPC.UnknownProtocolException(protocol, "No matching handler for protocol " + protocol.getName() + " in region " + Bytes.toStringBinary(this.getRegionName()));
        }
        CoprocessorProtocol handler = (CoprocessorProtocol)this.protocolHandlers.getInstance(protocol);
        try {
            Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
            method.setAccessible(true);
            value = method.invoke((Object)handler, call.getParameters());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            IOException ioe = new IOException(target.toString());
            ioe.setStackTrace(target.getStackTrace());
            throw ioe;
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                LOG.error((Object)"Unexpected throwable object ", e);
            }
            IOException ioe = new IOException(e.toString());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        return new ExecResult(this.getRegionName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTable(FileSystem fs, Path p, HLog log, Configuration c, boolean majorCompact2) throws IOException {
        block12: {
            HRegion region = null;
            String rootStr = Bytes.toString(HConstants.ROOT_TABLE_NAME);
            String metaStr = Bytes.toString(HConstants.META_TABLE_NAME);
            if (p.getName().startsWith(rootStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.ROOT_REGIONINFO, HTableDescriptor.ROOT_TABLEDESC, null);
            } else if (p.getName().startsWith(metaStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.FIRST_META_REGIONINFO, HTableDescriptor.META_TABLEDESC, null);
            } else {
                throw new IOException("Not a known catalog table: " + p.toString());
            }
            try {
                region.initialize();
                if (majorCompact2) {
                    region.compactStores(true);
                    break block12;
                }
                Scan scan = new Scan();
                RegionScanner scanner = region.getScanner(scan);
                try {
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                    boolean done = false;
                    do {
                        kvs.clear();
                        done = scanner.next(kvs);
                        if (kvs.size() <= 0) continue;
                        LOG.info(kvs);
                    } while (done);
                }
                finally {
                    scanner.close();
                }
            }
            finally {
                region.close();
            }
        }
    }

    boolean shouldForceSplit() {
        return this.splitRequest;
    }

    byte[] getExplicitSplitPoint() {
        return this.explicitSplitPoint;
    }

    void forceSplit(byte[] sp) {
        this.splitRequest = true;
        if (sp != null) {
            this.explicitSplitPoint = sp;
        }
    }

    void clearSplit_TESTS_ONLY() {
        this.splitRequest = false;
    }

    protected void prepareToSplit() {
    }

    public byte[] checkSplit() {
        if (this.getRegionInfo().isMetaRegion()) {
            if (this.shouldForceSplit()) {
                LOG.warn((Object)"Cannot split meta regions in HBase 0.20 and above");
            }
            return null;
        }
        if (this.explicitSplitPoint != null) {
            return this.explicitSplitPoint;
        }
        if (!this.splitPolicy.shouldSplit()) {
            return null;
        }
        byte[] ret = this.splitPolicy.getSplitPoint();
        if (ret != null) {
            try {
                this.checkRow(ret, "calculated split");
            }
            catch (IOException e) {
                LOG.error((Object)"Ignoring invalid split", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public int getCompactPriority() {
        int count = Integer.MAX_VALUE;
        for (Store store : this.stores.values()) {
            count = Math.min(count, store.getCompactPriority());
        }
        return count;
    }

    public boolean needsCompaction() {
        for (Store store : this.stores.values()) {
            if (!store.needsCompaction()) continue;
            return true;
        }
        return false;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public void setCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    private void startRegionOperation() throws NotServingRegionException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closing");
        }
        this.lock.readLock().lock();
        if (this.closed.get()) {
            this.lock.readLock().unlock();
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closed");
        }
    }

    private void closeRegionOperation() {
        this.lock.readLock().unlock();
    }

    private void startBulkRegionOperation(boolean writeLockNeeded) throws NotServingRegionException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closing");
        }
        if (writeLockNeeded) {
            this.lock.writeLock().lock();
        } else {
            this.lock.readLock().lock();
        }
        if (this.closed.get()) {
            if (writeLockNeeded) {
                this.lock.writeLock().unlock();
            } else {
                this.lock.readLock().unlock();
            }
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closed");
        }
    }

    private void closeBulkRegionOperation() {
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            HRegion.printUsageAndExit(null);
        }
        boolean majorCompact2 = false;
        if (args.length > 1) {
            if (!args[1].toLowerCase().startsWith("major")) {
                HRegion.printUsageAndExit("ERROR: Unrecognized option <" + args[1] + ">");
            }
            majorCompact2 = true;
        }
        Path tableDir = new Path(args[0]);
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        Path logdir = new Path(c.get("hbase.tmp.dir"), "hlog" + tableDir.getName() + EnvironmentEdgeManager.currentTimeMillis());
        Path oldLogDir = new Path(c.get("hbase.tmp.dir"), ".oldlogs");
        HLog log = new HLog(fs, logdir, oldLogDir, c);
        try {
            HRegion.processTable(fs, tableDir, log, c, majorCompact2);
        }
        finally {
            log.close();
            BlockCache bc = new CacheConfig(c).getBlockCache();
            if (bc != null) {
                bc.shutdown();
            }
        }
    }

    class RegionScannerImpl
    implements RegionScanner {
        KeyValueHeap storeHeap = null;
        private final byte[] stopRow;
        private Filter filter;
        private List<KeyValue> results = new ArrayList<KeyValue>();
        private int batch;
        private int isScan;
        private boolean filterClosed = false;
        private long readPt;

        @Override
        public HRegionInfo getRegionInfo() {
            return HRegion.this.regionInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
            this.filter = scan.getFilter();
            this.batch = scan.getBatch();
            this.stopRow = (byte[])(Bytes.equals(scan.getStopRow(), HConstants.EMPTY_END_ROW) ? null : scan.getStopRow());
            this.isScan = scan.isGetScan() ? -1 : 0;
            ConcurrentHashMap concurrentHashMap = HRegion.this.scannerReadPoints;
            synchronized (concurrentHashMap) {
                this.readPt = MultiVersionConsistencyControl.resetThreadReadPoint(HRegion.this.mvcc);
                HRegion.this.scannerReadPoints.put(this, this.readPt);
            }
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null) {
                scanners.addAll(additionalScanners);
            }
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
                Store store = HRegion.this.stores.get(entry.getKey());
                StoreScanner scanner = store.getScanner(scan, entry.getValue());
                scanners.add(scanner);
            }
            this.storeHeap = new KeyValueHeap(scanners, HRegion.this.comparator);
        }

        RegionScannerImpl(Scan scan) throws IOException {
            this(scan, null);
        }

        protected void resetFilters() {
            if (this.filter != null) {
                this.filter.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean next(List<KeyValue> outResults, int limit) throws IOException {
            if (this.filterClosed) {
                throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
            }
            HRegion.this.startRegionOperation();
            HRegion.this.readRequestsCount.increment();
            try {
                MultiVersionConsistencyControl.setThreadReadPoint(this.readPt);
                this.results.clear();
                boolean returnResult = this.nextInternal(limit);
                outResults.addAll(this.results);
                this.resetFilters();
                if (this.isFilterDone()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = returnResult;
                return bl;
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
        }

        @Override
        public synchronized boolean next(List<KeyValue> outResults) throws IOException {
            return this.next(outResults, this.batch);
        }

        @Override
        public synchronized boolean isFilterDone() {
            return this.filter != null && this.filter.filterAllRemaining();
        }

        private boolean nextInternal(int limit) throws IOException {
            boolean stopRow;
            RpcCallContext rpcCall = HBaseServer.getCurrentCall();
            while (true) {
                byte[] nextRow;
                byte[] currentRow;
                if (rpcCall != null) {
                    rpcCall.throwExceptionIfCallerDisconnected();
                }
                if (this.isStopRow(currentRow = this.peekRow())) {
                    if (this.filter != null && this.filter.hasFilterRow()) {
                        this.filter.filterRow(this.results);
                    }
                    if (this.filter != null && this.filter.filterRow()) {
                        this.results.clear();
                    }
                    return false;
                }
                if (this.filterRowKey(currentRow)) {
                    this.nextRow(currentRow);
                    continue;
                }
                do {
                    this.storeHeap.next(this.results, limit - this.results.size());
                    if (limit <= 0 || this.results.size() != limit) continue;
                    if (this.filter != null && this.filter.hasFilterRow()) {
                        throw new IncompatibleFilterException("Filter with filterRow(List<KeyValue>) incompatible with scan with limit!");
                    }
                    return true;
                } while (Bytes.equals(currentRow, nextRow = this.peekRow()));
                stopRow = this.isStopRow(nextRow);
                if (this.filter != null && this.filter.hasFilterRow()) {
                    this.filter.filterRow(this.results);
                }
                if (!this.results.isEmpty() && !this.filterRow()) break;
                this.nextRow(currentRow);
                if (stopRow) break;
            }
            return !stopRow;
        }

        private boolean filterRow() {
            return this.filter != null && this.filter.filterRow();
        }

        private boolean filterRowKey(byte[] row) {
            return this.filter != null && this.filter.filterRowKey(row, 0, row.length);
        }

        protected void nextRow(byte[] currentRow) throws IOException {
            while (Bytes.equals(currentRow, this.peekRow())) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.results.clear();
            this.resetFilters();
        }

        private byte[] peekRow() {
            KeyValue kv = this.storeHeap.peek();
            return kv == null ? null : kv.getRow();
        }

        private boolean isStopRow(byte[] currentRow) {
            return currentRow == null || this.stopRow != null && HRegion.this.comparator.compareRows(this.stopRow, 0, this.stopRow.length, currentRow, 0, currentRow.length) <= this.isScan;
        }

        @Override
        public synchronized void close() {
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
            }
            HRegion.this.scannerReadPoints.remove(this);
            this.filterClosed = true;
        }

        KeyValueHeap getStoreHeapForTesting() {
            return this.storeHeap;
        }
    }

    private static class BatchOperationInProgress<T> {
        T[] operations;
        int nextIndexToProcess = 0;
        OperationStatus[] retCodeDetails;

        public BatchOperationInProgress(T[] operations) {
            this.operations = operations;
            this.retCodeDetails = new OperationStatus[operations.length];
            Arrays.fill(this.retCodeDetails, OperationStatus.NOT_RUN);
        }

        public boolean isDone() {
            return this.nextIndexToProcess == this.operations.length;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        volatile int compacting = 0;
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;
        static final long HEAP_SIZE = ClassSize.align(ClassSize.OBJECT + 5);

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }
    }
}

