/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;

public class KeyValueHeap
implements KeyValueScanner,
InternalScanner {
    private PriorityQueue<KeyValueScanner> heap = null;
    private KeyValueScanner current = null;
    private KVScannerComparator comparator;

    public KeyValueHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) {
        this.comparator = new KVScannerComparator(comparator);
        if (!scanners.isEmpty()) {
            this.heap = new PriorityQueue<KeyValueScanner>(scanners.size(), this.comparator);
            for (KeyValueScanner keyValueScanner : scanners) {
                if (keyValueScanner.peek() != null) {
                    this.heap.add(keyValueScanner);
                    continue;
                }
                keyValueScanner.close();
            }
            this.current = this.heap.poll();
        }
    }

    @Override
    public KeyValue peek() {
        if (this.current == null) {
            return null;
        }
        return this.current.peek();
    }

    @Override
    public KeyValue next() throws IOException {
        if (this.current == null) {
            return null;
        }
        KeyValue kvReturn = this.current.next();
        KeyValue kvNext = this.current.peek();
        if (kvNext == null) {
            this.current.close();
            this.current = this.heap.poll();
        } else {
            KeyValueScanner topScanner = this.heap.peek();
            if (topScanner == null || this.comparator.compare(kvNext, topScanner.peek()) >= 0) {
                this.heap.add(this.current);
                this.current = this.heap.poll();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean next(List<KeyValue> result, int limit) throws IOException {
        if (this.current == null) {
            return false;
        }
        InternalScanner currentAsInternal = (InternalScanner)((Object)this.current);
        boolean mayContainMoreRows = currentAsInternal.next(result, limit);
        KeyValue pee = this.current.peek();
        if (pee == null || !mayContainMoreRows) {
            this.current.close();
        } else {
            this.heap.add(this.current);
        }
        this.current = this.heap.poll();
        return this.current != null;
    }

    @Override
    public boolean next(List<KeyValue> result) throws IOException {
        return this.next(result, -1);
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current.close();
        }
        if (this.heap != null) {
            KeyValueScanner scanner;
            while ((scanner = this.heap.poll()) != null) {
                scanner.close();
            }
        }
    }

    @Override
    public boolean seek(KeyValue seekKey) throws IOException {
        return this.generalizedSeek(seekKey, SeekType.NORMAL, false);
    }

    @Override
    public boolean reseek(KeyValue seekKey) throws IOException {
        return this.generalizedSeek(seekKey, SeekType.NORMAL, true);
    }

    @Override
    public boolean seekExactly(KeyValue seekKey, boolean forward) throws IOException {
        return this.generalizedSeek(seekKey, SeekType.EXACT, forward);
    }

    private boolean generalizedSeek(KeyValue seekKey, SeekType seekType, boolean forward) throws IOException {
        KeyValueScanner scanner;
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = this.heap.poll()) != null) {
            KeyValue topKey = scanner.peek();
            if (this.comparator.getComparator().compare(seekKey, topKey) <= 0) {
                this.current = scanner;
                return true;
            }
            if (!seekType.seek(scanner, seekKey, forward)) {
                scanner.close();
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    public PriorityQueue<KeyValueScanner> getHeap() {
        return this.heap;
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    KeyValueScanner getCurrentForTesting() {
        return this.current;
    }

    private static class KVScannerComparator
    implements Comparator<KeyValueScanner> {
        private KeyValue.KVComparator kvComparator;

        public KVScannerComparator(KeyValue.KVComparator kvComparator) {
            this.kvComparator = kvComparator;
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            long rightSequenceID;
            int comparison = this.compare(left.peek(), right.peek());
            if (comparison != 0) {
                return comparison;
            }
            long leftSequenceID = left.getSequenceID();
            if (leftSequenceID > (rightSequenceID = right.getSequenceID())) {
                return -1;
            }
            if (leftSequenceID < rightSequenceID) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(KeyValue left, KeyValue right) {
            return this.kvComparator.compare(left, right);
        }

        public KeyValue.KVComparator getComparator() {
            return this.kvComparator;
        }
    }

    public static enum SeekType {
        NORMAL{

            @Override
            public boolean seek(KeyValueScanner scanner, KeyValue kv, boolean forward) throws IOException {
                return forward ? scanner.reseek(kv) : scanner.seek(kv);
            }
        }
        ,
        EXACT{

            @Override
            public boolean seek(KeyValueScanner scanner, KeyValue kv, boolean forward) throws IOException {
                return scanner.seekExactly(kv, forward);
            }
        };


        public abstract boolean seek(KeyValueScanner var1, KeyValue var2, boolean var3) throws IOException;
    }
}

