/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HasThread;

class LogRoller
extends HasThread
implements WALActionsListener {
    static final Log LOG = LogFactory.getLog(LogRoller.class);
    private final ReentrantLock rollLock = new ReentrantLock();
    private final AtomicBoolean rollLog = new AtomicBoolean(false);
    private final Server server;
    private final RegionServerServices services;
    private volatile long lastrolltime = System.currentTimeMillis();
    private final long rollperiod;
    private final int threadWakeFrequency;

    public LogRoller(Server server, RegionServerServices services) {
        this.server = server;
        this.services = services;
        this.rollperiod = this.server.getConfiguration().getLong("hbase.regionserver.logroll.period", 3600000L);
        this.threadWakeFrequency = this.server.getConfiguration().getInt("hbase.server.thread.wakefrequency", 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.server.isStopped()) {
            long now = System.currentTimeMillis();
            boolean periodic = false;
            if (!this.rollLog.get()) {
                boolean bl = periodic = now - this.lastrolltime > this.rollperiod;
                if (!periodic) {
                    AtomicBoolean atomicBoolean = this.rollLog;
                    synchronized (atomicBoolean) {
                        try {
                            this.rollLog.wait(this.threadWakeFrequency);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Hlog roll period " + this.rollperiod + "ms elapsed"));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"HLog roll requested");
            }
            this.rollLock.lock();
            try {
                this.lastrolltime = now;
                byte[][] regionsToFlush = this.services.getWAL().rollWriter(this.rollLog.get());
                if (regionsToFlush == null) continue;
                for (byte[] r : regionsToFlush) {
                    this.scheduleFlush(r);
                }
            }
            catch (FailedLogCloseException e) {
                this.server.abort("Failed log close in log roller", e);
            }
            catch (ConnectException e) {
                this.server.abort("Failed log close in log roller", e);
            }
            catch (IOException ex) {
                this.server.abort("IOE in log roller", RemoteExceptionHandler.checkIOException(ex));
            }
            catch (Exception ex) {
                LOG.error((Object)"Log rolling failed", (Throwable)ex);
                this.server.abort("Log rolling failed", ex);
            }
            finally {
                this.rollLog.set(false);
                this.rollLock.unlock();
            }
        }
        LOG.info((Object)"LogRoller exiting.");
    }

    private void scheduleFlush(byte[] encodedRegionName) {
        boolean scheduled = false;
        HRegion r = this.services.getFromOnlineRegions(Bytes.toString(encodedRegionName));
        FlushRequester requester = null;
        if (r != null && (requester = this.services.getFlushRequester()) != null) {
            requester.requestFlush(r);
            scheduled = true;
        }
        if (!scheduled) {
            LOG.warn((Object)("Failed to schedule flush of " + Bytes.toString(encodedRegionName) + ", region=" + r + ", requester=" + requester));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logRollRequested() {
        AtomicBoolean atomicBoolean = this.rollLog;
        synchronized (atomicBoolean) {
            this.rollLog.set(true);
            this.rollLog.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptIfNecessary() {
        try {
            this.rollLock.lock();
            this.interrupt();
        }
        finally {
            this.rollLock.unlock();
        }
    }

    @Override
    public void logRolled(Path newFile) {
    }

    @Override
    public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
    }

    @Override
    public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
    }

    @Override
    public void logCloseRequested() {
    }
}

