/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanWildcardColumnTracker
implements ColumnTracker {
    private static final Log LOG = LogFactory.getLog(ScanWildcardColumnTracker.class);
    private byte[] columnBuffer = null;
    private int columnOffset = 0;
    private int columnLength = 0;
    private int currentCount = 0;
    private int maxVersions;
    private int minVersions;
    private long latestTSOfCurrentColumn;
    private long oldestStamp;

    public ScanWildcardColumnTracker(int minVersion, int maxVersion, long ttl) {
        this.maxVersions = maxVersion;
        this.minVersions = minVersion;
        this.oldestStamp = System.currentTimeMillis() - ttl;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length, long timestamp, boolean ignoreCount) throws IOException {
        if (this.columnBuffer == null) {
            this.resetBuffer(bytes, offset, length);
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            return this.checkVersion(++this.currentCount, timestamp);
        }
        int cmp = Bytes.compareTo(bytes, offset, length, this.columnBuffer, this.columnOffset, this.columnLength);
        if (cmp == 0) {
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            if (this.sameAsPreviousTS(timestamp)) {
                return ScanQueryMatcher.MatchCode.SKIP;
            }
            return this.checkVersion(++this.currentCount, timestamp);
        }
        this.resetTS();
        if (cmp > 0) {
            this.resetBuffer(bytes, offset, length);
            if (ignoreCount) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            return this.checkVersion(++this.currentCount, timestamp);
        }
        throw new IOException("ScanWildcardColumnTracker.checkColumn ran into a column actually smaller than the previous column: " + Bytes.toStringBinary(bytes, offset, length));
    }

    private void resetBuffer(byte[] bytes, int offset, int length) {
        this.columnBuffer = bytes;
        this.columnOffset = offset;
        this.columnLength = length;
        this.currentCount = 0;
    }

    private ScanQueryMatcher.MatchCode checkVersion(int version, long timestamp) {
        if (version > this.maxVersions) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        if (version <= this.minVersions || !this.isExpired(timestamp)) {
            this.setTS(timestamp);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("ScanWildcardColumnTracker.update should never be called!");
    }

    @Override
    public void reset() {
        this.columnBuffer = null;
        this.resetTS();
    }

    private void resetTS() {
        this.latestTSOfCurrentColumn = Long.MAX_VALUE;
    }

    private void setTS(long timestamp) {
        this.latestTSOfCurrentColumn = timestamp;
    }

    private boolean sameAsPreviousTS(long timestamp) {
        return timestamp == this.latestTSOfCurrentColumn;
    }

    private boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    @Override
    public ColumnCount getColumnHint() {
        return null;
    }

    @Override
    public boolean done() {
        return false;
    }

    @Override
    public ScanQueryMatcher.MatchCode getNextRowOrNextColumn(byte[] bytes, int offset, int qualLength) {
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public boolean isDone(long timestamp) {
        return this.minVersions <= 0 && this.isExpired(timestamp);
    }
}

