/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;

class StoreFileScanner
implements KeyValueScanner {
    static final Log LOG = LogFactory.getLog(Store.class);
    private final StoreFile.Reader reader;
    private final HFileScanner hfs;
    private KeyValue cur = null;
    private boolean enforceMVCC = false;

    public StoreFileScanner(StoreFile.Reader reader, HFileScanner hfs, boolean useMVCC) {
        this.reader = reader;
        this.hfs = hfs;
        this.enforceMVCC = useMVCC;
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> filesToCompact, boolean cacheBlocks, boolean usePread) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(filesToCompact, cacheBlocks, usePread, false);
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction) throws IOException {
        ArrayList<StoreFileScanner> scanners = new ArrayList<StoreFileScanner>(files.size());
        for (StoreFile file : files) {
            StoreFile.Reader r = file.createReader();
            scanners.add(r.getStoreFileScanner(cacheBlocks, usePread, isCompaction));
        }
        return scanners;
    }

    public String toString() {
        return "StoreFileScanner[" + this.hfs.toString() + ", cur=" + this.cur + "]";
    }

    @Override
    public KeyValue peek() {
        return this.cur;
    }

    @Override
    public KeyValue next() throws IOException {
        KeyValue retKey = this.cur;
        try {
            if (this.cur != null) {
                this.hfs.next();
                this.cur = this.hfs.getKeyValue();
                this.skipKVsNewerThanReadpoint();
            }
        }
        catch (IOException e) {
            throw new IOException("Could not iterate " + this, e);
        }
        return retKey;
    }

    @Override
    public boolean seek(KeyValue key) throws IOException {
        try {
            if (!StoreFileScanner.seekAtOrAfter(this.hfs, key)) {
                this.close();
                return false;
            }
            this.cur = this.hfs.getKeyValue();
            return this.skipKVsNewerThanReadpoint();
        }
        catch (IOException ioe) {
            throw new IOException("Could not seek " + this, ioe);
        }
    }

    @Override
    public boolean reseek(KeyValue key) throws IOException {
        try {
            if (!StoreFileScanner.reseekAtOrAfter(this.hfs, key)) {
                this.close();
                return false;
            }
            this.cur = this.hfs.getKeyValue();
            return this.skipKVsNewerThanReadpoint();
        }
        catch (IOException ioe) {
            throw new IOException("Could not seek " + this, ioe);
        }
    }

    protected boolean skipKVsNewerThanReadpoint() throws IOException {
        long readPoint = MultiVersionConsistencyControl.getThreadReadPoint();
        while (this.enforceMVCC && this.cur != null && this.cur.getMemstoreTS() > readPoint) {
            this.hfs.next();
            this.cur = this.hfs.getKeyValue();
        }
        if (this.cur == null) {
            this.close();
            return false;
        }
        if (this.cur.getMemstoreTS() <= readPoint) {
            this.cur.setMemstoreTS(0L);
        }
        return true;
    }

    @Override
    public void close() {
        this.cur = null;
    }

    public static boolean seekAtOrAfter(HFileScanner s, KeyValue k) throws IOException {
        int result = s.seekTo(k.getBuffer(), k.getKeyOffset(), k.getKeyLength());
        if (result < 0) {
            return s.seekTo();
        }
        if (result > 0) {
            return s.next();
        }
        return true;
    }

    static boolean reseekAtOrAfter(HFileScanner s, KeyValue k) throws IOException {
        int result = s.reseekTo(k.getBuffer(), k.getKeyOffset(), k.getKeyLength());
        if (result <= 0) {
            return true;
        }
        return s.next();
    }

    public boolean shouldSeek(Scan scan, SortedSet<byte[]> columns) {
        return this.reader.shouldSeek(scan, columns);
    }

    @Override
    public long getSequenceID() {
        return this.reader.getSequenceID();
    }

    @Override
    public boolean seekExactly(KeyValue kv, boolean forward) throws IOException {
        if (this.reader.getBloomFilterType() != StoreFile.BloomType.ROWCOL || kv.getRowLength() == 0 || kv.getQualifierLength() == 0) {
            return forward ? this.reseek(kv) : this.seek(kv);
        }
        boolean isInBloom = this.reader.passesBloomFilter(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
        if (isInBloom) {
            return forward ? this.reseek(kv) : this.seek(kv);
        }
        this.cur = kv.createLastOnRowCol();
        return true;
    }

    StoreFile.Reader getReaderForTesting() {
        return this.reader;
    }
}

