/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;

class StoreScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    static final Log LOG = LogFactory.getLog(StoreScanner.class);
    private Store store;
    private ScanQueryMatcher matcher;
    private KeyValueHeap heap;
    private boolean cacheBlocks;
    private boolean closing = false;
    private final boolean isGet;
    private KeyValue lastTop = null;

    StoreScanner(Store store, Scan scan, NavigableSet<byte[]> columns) throws IOException {
        this.store = store;
        this.cacheBlocks = scan.getCacheBlocks();
        this.matcher = new ScanQueryMatcher(scan, store.getFamily().getName(), columns, store.ttl, store.comparator.getRawComparator(), store.minVersions, store.versionsToReturn(scan.getMaxVersions()), false, Long.MAX_VALUE);
        this.isGet = scan.isGetScan();
        List<KeyValueScanner> scanners = this.getScanners(scan, columns);
        if (this.matcher.isExactColumnQuery()) {
            for (KeyValueScanner scanner : scanners) {
                scanner.seekExactly(this.matcher.getStartKey(), false);
            }
        } else {
            for (KeyValueScanner scanner : scanners) {
                scanner.seek(this.matcher.getStartKey());
            }
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
        this.store.addChangedReaderObserver(this);
    }

    StoreScanner(Store store, Scan scan, List<? extends KeyValueScanner> scanners, boolean retainDeletesInOutput, long smallestReadPoint) throws IOException {
        this.store = store;
        this.cacheBlocks = false;
        this.isGet = false;
        this.matcher = new ScanQueryMatcher(scan, store.getFamily().getName(), null, store.ttl, store.comparator.getRawComparator(), store.minVersions, store.versionsToReturn(scan.getMaxVersions()), retainDeletesInOutput, smallestReadPoint);
        for (KeyValueScanner keyValueScanner : scanners) {
            keyValueScanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
    }

    StoreScanner(Scan scan, byte[] colFamily, long ttl, KeyValue.KVComparator comparator, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners) throws IOException {
        this.store = null;
        this.isGet = false;
        this.cacheBlocks = scan.getCacheBlocks();
        this.matcher = new ScanQueryMatcher(scan, colFamily, columns, ttl, comparator.getRawComparator(), 0, scan.getMaxVersions(), false, Long.MAX_VALUE);
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, comparator);
    }

    private List<KeyValueScanner> getScanners() throws IOException {
        return this.store.getScanners(this.cacheBlocks, this.isGet, false);
    }

    private List<KeyValueScanner> getScanners(Scan scan, NavigableSet<byte[]> columns) throws IOException {
        boolean filesOnly;
        boolean memOnly;
        if (scan instanceof InternalScan) {
            InternalScan iscan = (InternalScan)scan;
            memOnly = iscan.isCheckOnlyMemStore();
            filesOnly = iscan.isCheckOnlyStoreFiles();
        } else {
            memOnly = false;
            filesOnly = false;
        }
        List<KeyValueScanner> allStoreScanners = this.store.getScanners(this.cacheBlocks, this.isGet, false);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(allStoreScanners.size());
        for (KeyValueScanner kvs : allStoreScanners) {
            if (kvs instanceof StoreFileScanner) {
                if (memOnly || !((StoreFileScanner)kvs).shouldSeek(scan, columns)) continue;
                scanners.add(kvs);
                continue;
            }
            if (filesOnly || !this.store.memstore.shouldSeek(scan)) continue;
            scanners.add(kvs);
        }
        return scanners;
    }

    @Override
    public synchronized KeyValue peek() {
        if (this.heap == null) {
            return this.lastTop;
        }
        return this.heap.peek();
    }

    @Override
    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    @Override
    public synchronized void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.store != null) {
            this.store.deleteChangedReaderObserver(this);
        }
        if (this.heap != null) {
            this.heap.close();
        }
        this.heap = null;
        this.lastTop = null;
    }

    @Override
    public synchronized boolean seek(KeyValue key) throws IOException {
        if (this.heap == null) {
            List<KeyValueScanner> scanners = this.getScanners();
            this.heap = new KeyValueHeap(scanners, this.store.comparator);
        }
        return this.heap.seek(key);
    }

    @Override
    public synchronized boolean next(List<KeyValue> outResult, int limit) throws IOException {
        KeyValue kv;
        KeyValue.KVComparator comparator;
        if (this.checkReseek()) {
            return true;
        }
        if (this.heap == null) {
            this.close();
            return false;
        }
        KeyValue peeked = this.heap.peek();
        if (peeked == null) {
            this.close();
            return false;
        }
        if (this.matcher.row == null || !peeked.matchingRow(this.matcher.row)) {
            this.matcher.setRow(peeked.getRow());
        }
        KeyValue prevKV = null;
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        KeyValue.KVComparator kVComparator = comparator = this.store != null ? this.store.getComparator() : null;
        block9: while ((kv = this.heap.peek()) != null) {
            if (prevKV != null && comparator != null && comparator.compare(prevKV, kv) > 0) {
                throw new IOException("Key " + prevKV + " followed by a " + "smaller key " + kv + " in cf " + this.store);
            }
            prevKV = kv;
            ScanQueryMatcher.MatchCode qcode = this.matcher.match(kv);
            switch (qcode) {
                case INCLUDE: 
                case INCLUDE_AND_SEEK_NEXT_ROW: 
                case INCLUDE_AND_SEEK_NEXT_COL: {
                    Filter f = this.matcher.getFilter();
                    results.add(f == null ? kv : f.transform(kv));
                    if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) {
                        if (!this.matcher.moreRowsMayExistAfter(kv)) {
                            outResult.addAll(results);
                            return false;
                        }
                        this.reseek(this.matcher.getKeyForNextRow(kv));
                    } else if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                        this.reseek(this.matcher.getKeyForNextColumn(kv));
                    } else {
                        this.heap.next();
                    }
                    if (limit <= 0 || results.size() != limit) continue block9;
                    break block9;
                }
                case DONE: {
                    outResult.addAll(results);
                    return true;
                }
                case DONE_SCAN: {
                    this.close();
                    outResult.addAll(results);
                    return false;
                }
                case SEEK_NEXT_ROW: {
                    if (!this.matcher.moreRowsMayExistAfter(kv)) {
                        outResult.addAll(results);
                        return false;
                    }
                    this.reseek(this.matcher.getKeyForNextRow(kv));
                    break;
                }
                case SEEK_NEXT_COL: {
                    this.reseek(this.matcher.getKeyForNextColumn(kv));
                    break;
                }
                case SKIP: {
                    this.heap.next();
                    break;
                }
                case SEEK_NEXT_USING_HINT: {
                    KeyValue nextKV = this.matcher.getNextKeyHint(kv);
                    if (nextKV != null) {
                        this.reseek(nextKV);
                        break;
                    }
                    this.heap.next();
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED");
                }
            }
        }
        if (!results.isEmpty()) {
            outResult.addAll(results);
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public synchronized boolean next(List<KeyValue> outResult) throws IOException {
        return this.next(outResult, -1);
    }

    @Override
    public synchronized void updateReaders() throws IOException {
        if (this.closing) {
            return;
        }
        if (this.heap == null) {
            return;
        }
        this.lastTop = this.peek();
        this.heap.close();
        this.heap = null;
    }

    private boolean checkReseek() throws IOException {
        if (this.heap == null && this.lastTop != null) {
            this.resetScannerStack(this.lastTop);
            if (this.heap.peek() == null || this.store.comparator.compare(this.lastTop, this.heap.peek()) != 0) {
                LOG.debug((Object)("Storescanner.peek() is changed where before = " + this.lastTop.toString() + ",and after = " + this.heap.peek()));
                this.lastTop = null;
                return true;
            }
            this.lastTop = null;
        }
        return false;
    }

    private void resetScannerStack(KeyValue lastTopKey) throws IOException {
        if (this.heap != null) {
            throw new RuntimeException("StoreScanner.reseek run on an existing heap!");
        }
        List<KeyValueScanner> scanners = this.getScanners();
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(lastTopKey);
        }
        this.heap = new KeyValueHeap(scanners, this.store.comparator);
        KeyValue kv = this.heap.peek();
        if (kv == null) {
            kv = lastTopKey;
        }
        if (this.matcher.row == null || !kv.matchingRow(this.matcher.row)) {
            this.matcher.reset();
            this.matcher.setRow(kv.getRow());
        }
    }

    @Override
    public synchronized boolean reseek(KeyValue kv) throws IOException {
        return this.matcher.isExactColumnQuery() ? this.heap.seekExactly(kv, true) : this.heap.reseek(kv);
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    @Override
    public boolean seekExactly(KeyValue kv, boolean forward) throws IOException {
        throw new NotImplementedException();
    }

    List<KeyValueScanner> getAllScannersForTesting() {
        ArrayList<KeyValueScanner> allScanners = new ArrayList<KeyValueScanner>();
        KeyValueScanner current = this.heap.getCurrentForTesting();
        if (current != null) {
            allScanners.add(current);
        }
        for (KeyValueScanner scanner : this.heap.getHeap()) {
            allScanners.add(scanner);
        }
        return allScanners;
    }
}

