/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.metrics.ExactCounterMetric;
import org.apache.hadoop.hbase.metrics.HBaseInfo;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.metrics.PersistentMetricsTimeVaryingRate;
import org.apache.hadoop.hbase.metrics.histogram.MetricsHistogram;
import org.apache.hadoop.hbase.metrics.histogram.Snapshot;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerStatistics;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;
import org.apache.hadoop.util.StringUtils;

public class RegionServerMetrics
implements Updater {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final MetricsRecord metricsRecord;
    private long lastUpdate = System.currentTimeMillis();
    private long lastExtUpdate = System.currentTimeMillis();
    private long extendedPeriod = 0L;
    private static final int MB = 0x100000;
    private MetricsRegistry registry = new MetricsRegistry();
    private final RegionServerStatistics statistics;
    public final MetricsTimeVaryingRate atomicIncrementTime = new MetricsTimeVaryingRate("atomicIncrementTime", this.registry);
    public final MetricsIntValue regions = new MetricsIntValue("regions", this.registry);
    public final MetricsLongValue blockCacheSize = new MetricsLongValue("blockCacheSize", this.registry);
    public final MetricsLongValue blockCacheFree = new MetricsLongValue("blockCacheFree", this.registry);
    public final MetricsLongValue blockCacheCount = new MetricsLongValue("blockCacheCount", this.registry);
    public final MetricsLongValue blockCacheHitCount = new MetricsLongValue("blockCacheHitCount", this.registry);
    public final MetricsLongValue blockCacheMissCount = new MetricsLongValue("blockCacheMissCount", this.registry);
    public final MetricsLongValue blockCacheEvictedCount = new MetricsLongValue("blockCacheEvictedCount", this.registry);
    public final MetricsIntValue blockCacheHitRatio = new MetricsIntValue("blockCacheHitRatio", this.registry);
    public final MetricsIntValue blockCacheHitCachingRatio = new MetricsIntValue("blockCacheHitCachingRatio", this.registry);
    public final MetricsHistogram getLatencies = new MetricsHistogram("getRequestLatency", this.registry);
    public final MetricsHistogram deleteLatencies = new MetricsHistogram("deleteRequestLatency", this.registry);
    public final MetricsHistogram putLatencies = new MetricsHistogram("putRequestLatency", this.registry);
    public final MetricsRate requests = new MetricsRate("requests", this.registry);
    public final MetricsIntValue stores = new MetricsIntValue("stores", this.registry);
    public final MetricsIntValue storefiles = new MetricsIntValue("storefiles", this.registry);
    public final MetricsLongValue readRequestsCount = new MetricsLongValue("readRequestsCount", this.registry);
    public final MetricsLongValue writeRequestsCount = new MetricsLongValue("writeRequestsCount", this.registry);
    public final MetricsIntValue storefileIndexSizeMB = new MetricsIntValue("storefileIndexSizeMB", this.registry);
    public final MetricsIntValue rootIndexSizeKB = new MetricsIntValue("rootIndexSizeKB", this.registry);
    public final MetricsIntValue totalStaticIndexSizeKB = new MetricsIntValue("totalStaticIndexSizeKB", this.registry);
    public final MetricsIntValue totalStaticBloomSizeKB = new MetricsIntValue("totalStaticBloomSizeKB", this.registry);
    public final MetricsIntValue hdfsBlocksLocalityIndex = new MetricsIntValue("hdfsBlocksLocalityIndex", this.registry);
    public final MetricsIntValue memstoreSizeMB = new MetricsIntValue("memstoreSizeMB", this.registry);
    public final MetricsLongValue numPutsWithoutWAL = new MetricsLongValue("numPutsWithoutWAL", this.registry);
    public final MetricsIntValue mbInMemoryWithoutWAL = new MetricsIntValue("mbInMemoryWithoutWAL", this.registry);
    public final MetricsIntValue compactionQueueSize = new MetricsIntValue("compactionQueueSize", this.registry);
    public final MetricsIntValue flushQueueSize = new MetricsIntValue("flushQueueSize", this.registry);
    public final MetricsHistogram fsReadLatencyHistogram = new MetricsHistogram("fsReadLatencyHistogram", this.registry);
    public final MetricsHistogram fsWriteLatencyHistogram = new MetricsHistogram("fsWriteLatencyHistogram", this.registry);
    public final ExactCounterMetric regionAccessCounter = new ExactCounterMetric("regionAccessCounter", this.registry);
    public final MetricsTimeVaryingRate fsReadLatency = new MetricsTimeVaryingRate("fsReadLatency", this.registry);
    public final MetricsTimeVaryingRate fsWriteLatency = new MetricsTimeVaryingRate("fsWriteLatency", this.registry);
    public final MetricsTimeVaryingRate fsSyncLatency = new MetricsTimeVaryingRate("fsSyncLatency", this.registry);
    public final MetricsIntValue hlogFileCount = new MetricsIntValue("hlogFileCount", this.registry);
    protected final PersistentMetricsTimeVaryingRate compactionTime = new PersistentMetricsTimeVaryingRate("compactionTime", this.registry);
    protected final PersistentMetricsTimeVaryingRate compactionSize = new PersistentMetricsTimeVaryingRate("compactionSize", this.registry);
    protected final PersistentMetricsTimeVaryingRate flushTime = new PersistentMetricsTimeVaryingRate("flushTime", this.registry);
    protected final PersistentMetricsTimeVaryingRate flushSize = new PersistentMetricsTimeVaryingRate("flushSize", this.registry);

    public RegionServerMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"regionserver");
        String name = Thread.currentThread().getName();
        this.metricsRecord.setTag("RegionServer", name);
        context.registerUpdater((Updater)this);
        JvmMetrics.init((String)"RegionServer", (String)name);
        HBaseInfo.init();
        this.statistics = new RegionServerStatistics(this.registry, name);
        try {
            Object m = ContextFactory.getFactory().getAttribute("hbase.extendedperiod");
            if (m instanceof String) {
                this.extendedPeriod = Long.parseLong((String)m) * 1000L;
            }
        }
        catch (IOException ioe) {
            this.LOG.info((Object)"Couldn't load ContextFactory for Metrics config info");
        }
        this.LOG.info((Object)"Initialized");
    }

    public void shutdown() {
        if (this.statistics != null) {
            this.statistics.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext caller) {
        RegionServerMetrics regionServerMetrics = this;
        synchronized (regionServerMetrics) {
            this.lastUpdate = System.currentTimeMillis();
            if (this.extendedPeriod > 0L && this.lastUpdate - this.lastExtUpdate >= this.extendedPeriod) {
                this.lastExtUpdate = this.lastUpdate;
                this.compactionTime.resetMinMaxAvg();
                this.compactionSize.resetMinMaxAvg();
                this.flushTime.resetMinMaxAvg();
                this.flushSize.resetMinMaxAvg();
                this.resetAllMinMax();
            }
            this.stores.pushMetric(this.metricsRecord);
            this.storefiles.pushMetric(this.metricsRecord);
            this.storefileIndexSizeMB.pushMetric(this.metricsRecord);
            this.rootIndexSizeKB.pushMetric(this.metricsRecord);
            this.totalStaticIndexSizeKB.pushMetric(this.metricsRecord);
            this.totalStaticBloomSizeKB.pushMetric(this.metricsRecord);
            this.memstoreSizeMB.pushMetric(this.metricsRecord);
            this.mbInMemoryWithoutWAL.pushMetric(this.metricsRecord);
            this.numPutsWithoutWAL.pushMetric(this.metricsRecord);
            this.readRequestsCount.pushMetric(this.metricsRecord);
            this.writeRequestsCount.pushMetric(this.metricsRecord);
            this.regions.pushMetric(this.metricsRecord);
            this.requests.pushMetric(this.metricsRecord);
            this.compactionQueueSize.pushMetric(this.metricsRecord);
            this.flushQueueSize.pushMetric(this.metricsRecord);
            this.blockCacheSize.pushMetric(this.metricsRecord);
            this.blockCacheFree.pushMetric(this.metricsRecord);
            this.blockCacheCount.pushMetric(this.metricsRecord);
            this.blockCacheHitCount.pushMetric(this.metricsRecord);
            this.blockCacheMissCount.pushMetric(this.metricsRecord);
            this.blockCacheEvictedCount.pushMetric(this.metricsRecord);
            this.blockCacheHitRatio.pushMetric(this.metricsRecord);
            this.blockCacheHitCachingRatio.pushMetric(this.metricsRecord);
            this.hdfsBlocksLocalityIndex.pushMetric(this.metricsRecord);
            this.putLatencies.pushMetric(this.metricsRecord);
            this.deleteLatencies.pushMetric(this.metricsRecord);
            this.getLatencies.pushMetric(this.metricsRecord);
            int ops = (int)HFile.getReadOps();
            if (ops != 0) {
                this.fsReadLatency.inc(ops, HFile.getReadTimeMs());
            }
            if ((ops = (int)HFile.getWriteOps()) != 0) {
                this.fsWriteLatency.inc(ops, HFile.getWriteTimeMs());
            }
            if ((ops = (int)HLog.getWriteOps()) != 0) {
                this.fsWriteLatency.inc(ops, HLog.getWriteTime());
            }
            if ((ops = (int)HLog.getSyncOps()) != 0) {
                this.fsSyncLatency.inc(ops, HLog.getSyncTime());
            }
            for (Long latency : HFile.getReadLatenciesNanos()) {
                this.fsReadLatencyHistogram.update(latency);
            }
            for (Long latency : HFile.getWriteLatenciesNanos()) {
                this.fsWriteLatencyHistogram.update(latency);
            }
            this.hlogFileCount.set(HLog.getLogCount());
            this.hlogFileCount.pushMetric(this.metricsRecord);
            this.fsReadLatency.pushMetric(this.metricsRecord);
            this.fsWriteLatency.pushMetric(this.metricsRecord);
            this.fsReadLatencyHistogram.pushMetric(this.metricsRecord);
            this.fsWriteLatencyHistogram.pushMetric(this.metricsRecord);
            this.fsSyncLatency.pushMetric(this.metricsRecord);
            this.compactionTime.pushMetric(this.metricsRecord);
            this.compactionSize.pushMetric(this.metricsRecord);
            this.flushTime.pushMetric(this.metricsRecord);
            this.flushSize.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
        this.atomicIncrementTime.resetMinMax();
        this.fsReadLatency.resetMinMax();
        this.fsWriteLatency.resetMinMax();
        this.fsSyncLatency.resetMinMax();
    }

    public float getRequests() {
        return this.requests.getPreviousIntervalValue();
    }

    public synchronized void addCompaction(long time, long size) {
        this.compactionTime.inc(time);
        this.compactionSize.inc(size);
    }

    public synchronized void addFlush(List<Pair<Long, Long>> flushes) {
        for (Pair<Long, Long> f : flushes) {
            this.flushTime.inc(f.getFirst());
            this.flushSize.inc(f.getSecond());
        }
    }

    public void incrementRequests(int inc) {
        this.requests.inc(inc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb = Strings.appendKeyValue(sb, "requestsPerSecond", (int)this.requests.getPreviousIntervalValue());
        sb = Strings.appendKeyValue(sb, "numberOfOnlineRegions", this.regions.get());
        sb = Strings.appendKeyValue(sb, "numberOfStores", this.stores.get());
        sb = Strings.appendKeyValue(sb, "numberOfStorefiles", this.storefiles.get());
        sb = Strings.appendKeyValue(sb, this.storefileIndexSizeMB.getName(), this.storefileIndexSizeMB.get());
        sb = Strings.appendKeyValue(sb, "rootIndexSizeKB", this.rootIndexSizeKB.get());
        sb = Strings.appendKeyValue(sb, "totalStaticIndexSizeKB", this.totalStaticIndexSizeKB.get());
        sb = Strings.appendKeyValue(sb, "totalStaticBloomSizeKB", this.totalStaticBloomSizeKB.get());
        sb = Strings.appendKeyValue(sb, this.memstoreSizeMB.getName(), this.memstoreSizeMB.get());
        sb = Strings.appendKeyValue(sb, "mbInMemoryWithoutWAL", this.mbInMemoryWithoutWAL.get());
        sb = Strings.appendKeyValue(sb, "numberOfPutsWithoutWAL", this.numPutsWithoutWAL.get());
        sb = Strings.appendKeyValue(sb, "readRequestsCount", this.readRequestsCount.get());
        sb = Strings.appendKeyValue(sb, "writeRequestsCount", this.writeRequestsCount.get());
        sb = Strings.appendKeyValue(sb, "compactionQueueSize", this.compactionQueueSize.get());
        sb = Strings.appendKeyValue(sb, "flushQueueSize", this.flushQueueSize.get());
        MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        sb = Strings.appendKeyValue(sb, "usedHeapMB", memory.getUsed() / 0x100000L);
        sb = Strings.appendKeyValue(sb, "maxHeapMB", memory.getMax() / 0x100000L);
        sb = Strings.appendKeyValue(sb, this.blockCacheSize.getName() + "MB", StringUtils.limitDecimalTo2((double)((float)this.blockCacheSize.get() / 1048576.0f)));
        sb = Strings.appendKeyValue(sb, this.blockCacheFree.getName() + "MB", StringUtils.limitDecimalTo2((double)((float)this.blockCacheFree.get() / 1048576.0f)));
        sb = Strings.appendKeyValue(sb, this.blockCacheCount.getName(), this.blockCacheCount.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheHitCount.getName(), this.blockCacheHitCount.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheMissCount.getName(), this.blockCacheMissCount.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheEvictedCount.getName(), this.blockCacheEvictedCount.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheHitRatio.getName(), Long.valueOf(this.blockCacheHitRatio.get()) + "%");
        sb = Strings.appendKeyValue(sb, this.blockCacheHitCachingRatio.getName(), Long.valueOf(this.blockCacheHitCachingRatio.get()) + "%");
        sb = Strings.appendKeyValue(sb, this.hdfsBlocksLocalityIndex.getName(), this.hdfsBlocksLocalityIndex.get());
        sb = this.appendHistogram(sb, this.deleteLatencies);
        sb = this.appendHistogram(sb, this.getLatencies);
        sb = this.appendHistogram(sb, this.putLatencies);
        sb = this.appendHistogram(sb, this.fsReadLatencyHistogram);
        sb = this.appendHistogram(sb, this.fsWriteLatencyHistogram);
        return sb.toString();
    }

    private StringBuilder appendHistogram(StringBuilder sb, MetricsHistogram histogram) {
        sb = Strings.appendKeyValue(sb, histogram.getName() + "Mean", StringUtils.limitDecimalTo2((double)histogram.getMean()));
        sb = Strings.appendKeyValue(sb, histogram.getName() + "Count", StringUtils.limitDecimalTo2((double)histogram.getCount()));
        Snapshot s = histogram.getSnapshot();
        sb = Strings.appendKeyValue(sb, histogram.getName() + "Median", StringUtils.limitDecimalTo2((double)s.getMedian()));
        sb = Strings.appendKeyValue(sb, histogram.getName() + "75th", StringUtils.limitDecimalTo2((double)s.get75thPercentile()));
        sb = Strings.appendKeyValue(sb, histogram.getName() + "95th", StringUtils.limitDecimalTo2((double)s.get95thPercentile()));
        sb = Strings.appendKeyValue(sb, histogram.getName() + "99th", StringUtils.limitDecimalTo2((double)s.get99thPercentile()));
        sb = Strings.appendKeyValue(sb, histogram.getName() + "999th", StringUtils.limitDecimalTo2((double)s.get999thPercentile()));
        return sb;
    }
}

