/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class HLogKey
implements WritableComparable<HLogKey> {
    private static final int VERSION = -1;
    private byte[] encodedRegionName;
    private byte[] tablename;
    private long logSeqNum;
    private long writeTime;
    private UUID clusterId;

    public HLogKey() {
        this(null, null, 0L, Long.MAX_VALUE, HConstants.DEFAULT_CLUSTER_ID);
    }

    public HLogKey(byte[] encodedRegionName, byte[] tablename, long logSeqNum, long now, UUID clusterId) {
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
        this.clusterId = clusterId;
    }

    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public byte[] getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    void setLogSeqNum(long logSeqNum) {
        this.logSeqNum = logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public UUID getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(UUID clusterId) {
        this.clusterId = clusterId;
    }

    public String toString() {
        return Bytes.toString(this.tablename) + "/" + Bytes.toString(this.encodedRegionName) + "/" + this.logSeqNum;
    }

    public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", Bytes.toStringBinary(this.tablename));
        stringMap.put("region", Bytes.toStringBinary(this.encodedRegionName));
        stringMap.put("sequence", this.logSeqNum);
        return stringMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HLogKey)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.encodedRegionName);
        result = (int)((long)result ^ this.logSeqNum);
        result = (int)((long)result ^ this.writeTime);
        return result ^= this.clusterId.hashCode();
    }

    public int compareTo(HLogKey o) {
        int result = Bytes.compareTo(this.encodedRegionName, o.encodedRegionName);
        if (result == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.writeTime) {
                    result = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result;
    }

    void internTableName(byte[] tablename) {
        assert (Bytes.equals(tablename, this.tablename));
        this.tablename = tablename;
    }

    void internEncodedRegionName(byte[] encodedRegionName) {
        assert (Bytes.equals(this.encodedRegionName, encodedRegionName));
        this.encodedRegionName = encodedRegionName;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)-1);
        Bytes.writeByteArray(out, this.encodedRegionName);
        Bytes.writeByteArray(out, this.tablename);
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
        if (this.clusterId == HConstants.DEFAULT_CLUSTER_ID) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.clusterId.getMostSignificantBits());
            out.writeLong(this.clusterId.getLeastSignificantBits());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int version = 0;
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            version = len;
            len = WritableUtils.readVInt((DataInput)in);
        }
        this.encodedRegionName = new byte[len];
        in.readFully(this.encodedRegionName);
        this.tablename = Bytes.readByteArray(in);
        this.logSeqNum = in.readLong();
        this.writeTime = in.readLong();
        this.clusterId = HConstants.DEFAULT_CLUSTER_ID;
        if (version < 0) {
            if (in.readBoolean()) {
                this.clusterId = new UUID(in.readLong(), in.readLong());
            }
        } else {
            try {
                in.readByte();
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }
}

