/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class SequenceFileLogReader
implements HLog.Reader {
    private static final Log LOG = LogFactory.getLog(SequenceFileLogReader.class);
    Configuration conf;
    WALReader reader;
    Path path;
    int edit = 0;
    long entryStart = 0L;
    protected Class<? extends HLogKey> keyClass;

    public SequenceFileLogReader() {
    }

    public SequenceFileLogReader(Class<? extends HLogKey> keyClass) {
        this.keyClass = keyClass;
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf) throws IOException {
        this.conf = conf;
        this.path = path;
        this.reader = new WALReader(fs, path, conf);
    }

    @Override
    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    @Override
    public HLog.Entry next() throws IOException {
        return this.next(null);
    }

    @Override
    public HLog.Entry next(HLog.Entry reuse) throws IOException {
        this.entryStart = this.reader.getPosition();
        HLog.Entry e = reuse;
        if (e == null) {
            HLogKey key;
            if (this.keyClass == null) {
                key = HLog.newKey(this.conf);
            } else {
                try {
                    key = this.keyClass.newInstance();
                }
                catch (InstantiationException ie) {
                    throw new IOException(ie);
                }
                catch (IllegalAccessException iae) {
                    throw new IOException(iae);
                }
            }
            WALEdit val = new WALEdit();
            e = new HLog.Entry(key, val);
        }
        boolean b = false;
        try {
            b = this.reader.next((Writable)e.getKey(), e.getEdit());
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
        ++this.edit;
        return b ? e : null;
    }

    @Override
    public void seek(long pos) throws IOException {
        try {
            this.reader.seek(pos);
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.reader.getPosition();
    }

    protected IOException addFileInfoToException(IOException ioe) throws IOException {
        long pos = -1L;
        try {
            pos = this.getPosition();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed getting position to add to throw", (Throwable)e);
        }
        long end = Long.MAX_VALUE;
        try {
            Field fEnd = SequenceFile.Reader.class.getDeclaredField("end");
            fEnd.setAccessible(true);
            end = fEnd.getLong((Object)this.reader);
        }
        catch (Exception e) {
            // empty catch block
        }
        String msg = (this.path == null ? "" : this.path.toString()) + ", entryStart=" + this.entryStart + ", pos=" + pos + (end == Long.MAX_VALUE ? "" : ", end=" + end) + ", edit=" + this.edit;
        try {
            return (IOException)((IOException)ioe.getClass().getConstructor(String.class).newInstance(msg)).initCause(ioe);
        }
        catch (Exception e) {
            return ioe;
        }
    }

    static class WALReader
    extends SequenceFile.Reader {
        WALReader(FileSystem fs, Path p, Configuration c) throws IOException {
            super(fs, p, c);
        }

        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return new WALReaderFSDataInputStream(super.openFile(fs, file, bufferSize, length), length);
        }

        static class WALReaderFSDataInputStream
        extends FSDataInputStream {
            private boolean firstGetPosInvocation = true;
            private long length;

            WALReaderFSDataInputStream(FSDataInputStream is, long l) throws IOException {
                super((InputStream)is);
                this.length = l;
            }

            public long getPos() throws IOException {
                if (this.firstGetPosInvocation) {
                    this.firstGetPosInvocation = false;
                    long adjust = 0L;
                    try {
                        Field fIn = FilterInputStream.class.getDeclaredField("in");
                        fIn.setAccessible(true);
                        Object realIn = fIn.get(this.in);
                        if (realIn.getClass().getName().endsWith("DFSInputStream")) {
                            Method getFileLength = realIn.getClass().getDeclaredMethod("getFileLength", new Class[0]);
                            getFileLength.setAccessible(true);
                            long realLength = (Long)getFileLength.invoke(realIn, new Object[0]);
                            assert (realLength >= this.length);
                            adjust = realLength - this.length;
                        } else {
                            LOG.info((Object)("Input stream class: " + realIn.getClass().getName() + ", not adjusting length"));
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error while trying to get accurate file length.  Truncation / data loss may occur if RegionServers die.", (Throwable)e);
                    }
                    return adjust + super.getPos();
                }
                return super.getPos();
            }
        }
    }
}

