/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;

public class Replication
implements WALActionsListener {
    private final boolean replication;
    private final ReplicationSourceManager replicationManager;
    private final AtomicBoolean replicating = new AtomicBoolean(true);
    private final ReplicationZookeeper zkHelper;
    private final Configuration conf;
    private ReplicationSink replicationSink;
    private final Server server;

    public Replication(Server server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException, KeeperException {
        this.server = server;
        this.conf = this.server.getConfiguration();
        this.replication = Replication.isReplication(this.conf);
        if (this.replication) {
            this.zkHelper = new ReplicationZookeeper(server, this.replicating);
            this.replicationManager = new ReplicationSourceManager(this.zkHelper, this.conf, this.server, fs, this.replicating, logDir, oldLogDir);
        } else {
            this.replicationManager = null;
            this.zkHelper = null;
        }
    }

    public static boolean isReplication(Configuration c) {
        return c.getBoolean("hbase.replication", false);
    }

    public void join() {
        if (this.replication) {
            this.replicationManager.join();
        }
    }

    public void replicateLogEntries(HLog.Entry[] entries) throws IOException {
        if (this.replication) {
            this.replicationSink.replicateEntries(entries);
        }
    }

    public void startReplicationServices() throws IOException {
        if (this.replication) {
            this.replicationManager.init();
            this.replicationSink = new ReplicationSink(this.conf, this.server);
        }
    }

    public ReplicationSourceManager getReplicationManager() {
        return this.replicationManager;
    }

    @Override
    public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
    }

    @Override
    public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (KeyValue kv : logEdit.getKeyValues()) {
            byte[] family = kv.getFamily();
            int scope = htd.getFamily(family).getScope();
            if (scope == 0 || scopes.containsKey(family)) continue;
            scopes.put(family, scope);
        }
        if (!scopes.isEmpty()) {
            logEdit.setScopes(scopes);
        }
    }

    @Override
    public void logRolled(Path p) throws IOException {
        this.getReplicationManager().logRolled(p);
    }

    public static void decorateMasterConfiguration(Configuration conf) {
        if (!Replication.isReplication(conf)) {
            return;
        }
        String plugins = conf.get("hbase.master.logcleaner.plugins");
        if (!plugins.contains(ReplicationLogCleaner.class.toString())) {
            conf.set("hbase.master.logcleaner.plugins", plugins + "," + ReplicationLogCleaner.class.getCanonicalName());
        }
    }

    @Override
    public void logRollRequested() {
    }

    @Override
    public void logCloseRequested() {
    }
}

