/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;

public class MultiRowResource
extends ResourceBase {
    public static final String ROW_KEYS_PARAM_NAME = "row";
    TableResource tableResource;
    Integer versions = null;

    public MultiRowResource(TableResource tableResource, String versions) throws IOException {
        this.tableResource = tableResource;
        if (versions != null) {
            this.versions = Integer.valueOf(versions);
        }
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        this.servlet.getMetrics().incrementRequests(1);
        try {
            CellSetModel model = new CellSetModel();
            for (String rk : (List)params.get((Object)ROW_KEYS_PARAM_NAME)) {
                ResultGenerator generator;
                RowSpec rowSpec = new RowSpec(rk);
                if (this.versions != null) {
                    rowSpec.setMaxVersions(this.versions);
                }
                if (!(generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), rowSpec, null)).hasNext()) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                KeyValue value = null;
                RowModel rowModel = new RowModel(rk);
                while ((value = (KeyValue)generator.next()) != null) {
                    rowModel.addCell(new CellModel(value.getFamily(), value.getQualifier(), value.getTimestamp(), value.getValue()));
                }
                model.addRow(rowModel);
            }
            return Response.ok((Object)model).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }
}

