/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

public class RemoteHTable
implements HTableInterface {
    private static final Log LOG = LogFactory.getLog(RemoteHTable.class);
    final Client client;
    final Configuration conf;
    final byte[] name;
    final String accessToken;
    final int maxRetries;
    final long sleepTime;

    protected String buildRowSpec(byte[] row, Map familyMap, long startTime, long endTime, int maxVersions) {
        StringBuffer sb = new StringBuffer();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(this.name));
        sb.append('/');
        sb.append(Bytes.toStringBinary(row));
        Set families = familyMap.entrySet();
        if (families != null) {
            Iterator i = familyMap.entrySet().iterator();
            if (i.hasNext()) {
                sb.append('/');
            }
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Collection quals = (Collection)e.getValue();
                if (quals != null && !quals.isEmpty()) {
                    Iterator ii = quals.iterator();
                    while (ii.hasNext()) {
                        sb.append(Bytes.toStringBinary((byte[])e.getKey()));
                        sb.append(':');
                        Object o = ii.next();
                        if (o instanceof byte[]) {
                            sb.append(Bytes.toStringBinary((byte[])o));
                        } else if (o instanceof KeyValue) {
                            sb.append(Bytes.toStringBinary(((KeyValue)o).getQualifier()));
                        } else {
                            throw new RuntimeException("object type not handled");
                        }
                        if (!ii.hasNext()) continue;
                        sb.append(',');
                    }
                } else {
                    sb.append(Bytes.toStringBinary((byte[])e.getKey()));
                    sb.append(':');
                }
                if (!i.hasNext()) continue;
                sb.append(',');
            }
        }
        if (startTime != 0L && endTime != Long.MAX_VALUE) {
            sb.append('/');
            sb.append(startTime);
            if (startTime != endTime) {
                sb.append(',');
                sb.append(endTime);
            }
        } else if (endTime != Long.MAX_VALUE) {
            sb.append('/');
            sb.append(endTime);
        }
        if (maxVersions > 1) {
            sb.append("?v=");
            sb.append(maxVersions);
        }
        return sb.toString();
    }

    protected Result[] buildResultFromModel(CellSetModel model) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (RowModel row : model.getRows()) {
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            for (CellModel cell : row.getCells()) {
                byte[][] split = KeyValue.parseColumn(cell.getColumn());
                byte[] column = split[0];
                byte[] qualifier = split.length > 1 ? split[1] : null;
                kvs.add(new KeyValue(row.getKey(), column, qualifier, cell.getTimestamp(), cell.getValue()));
            }
            results.add(new Result(kvs));
        }
        return results.toArray(new Result[results.size()]);
    }

    protected CellSetModel buildModelFromPut(Put put) {
        RowModel row = new RowModel(put.getRow());
        long ts = put.getTimeStamp();
        for (List<KeyValue> kvs : put.getFamilyMap().values()) {
            for (KeyValue kv : kvs) {
                row.addCell(new CellModel(kv.getFamily(), kv.getQualifier(), ts != Long.MAX_VALUE ? ts : kv.getTimestamp(), kv.getValue()));
            }
        }
        CellSetModel model = new CellSetModel();
        model.addRow(row);
        return model;
    }

    public RemoteHTable(Client client, String name) {
        this(client, HBaseConfiguration.create(), Bytes.toBytes(name), null);
    }

    public RemoteHTable(Client client, String name, String accessToken) {
        this(client, HBaseConfiguration.create(), Bytes.toBytes(name), accessToken);
    }

    public RemoteHTable(Client client, Configuration conf, String name, String accessToken) {
        this(client, conf, Bytes.toBytes(name), accessToken);
    }

    public RemoteHTable(Client client, Configuration conf, byte[] name, String accessToken) {
        this.client = client;
        this.conf = conf;
        this.name = name;
        this.accessToken = accessToken;
        this.maxRetries = conf.getInt("hbase.rest.client.max.retries", 10);
        this.sleepTime = conf.getLong("hbase.rest.client.sleep", 1000L);
    }

    @Override
    public byte[] getTableName() {
        return (byte[])this.name.clone();
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(this.name));
        sb.append('/');
        sb.append("schema");
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(sb.toString(), "application/x-protobuf");
            int code = response.getCode();
            switch (code) {
                case 200: {
                    TableSchemaModel schema = new TableSchemaModel();
                    schema.getObjectFromMessage(response.getBody());
                    return schema.getTableDescriptor();
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
                default: {
                    throw new IOException("schema request returned " + code);
                }
            }
        }
        throw new IOException("schema request timed out");
    }

    @Override
    public void close() throws IOException {
        this.client.shutdown();
    }

    @Override
    public Result get(Get get2) throws IOException {
        TimeRange range = get2.getTimeRange();
        String spec = this.buildRowSpec(get2.getRow(), get2.getFamilyMap(), range.getMin(), range.getMax(), get2.getMaxVersions());
        if (get2.getFilter() != null) {
            LOG.warn((Object)"filters not supported on gets");
        }
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(spec, "application/x-protobuf");
            int code = response.getCode();
            switch (code) {
                case 200: {
                    CellSetModel model = new CellSetModel();
                    model.getObjectFromMessage(response.getBody());
                    Result[] results = this.buildResultFromModel(model);
                    if (results.length > 0) {
                        if (results.length > 1) {
                            LOG.warn((Object)("too many results for get (" + results.length + ")"));
                        }
                        return results[0];
                    }
                }
                case 404: {
                    return new Result();
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block7;
                }
                default: {
                    throw new IOException("get request returned " + code);
                }
            }
        }
        throw new IOException("get request timed out");
    }

    @Override
    public boolean exists(Get get2) throws IOException {
        LOG.warn((Object)"exists() is really get(), just use get()");
        Result result = this.get(get2);
        return result != null && !result.isEmpty();
    }

    @Override
    public void put(Put put) throws IOException {
        CellSetModel model = this.buildModelFromPut(put);
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(this.name));
        sb.append('/');
        sb.append(Bytes.toStringBinary(put.getRow()));
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
                default: {
                    throw new IOException("put request failed with " + code);
                }
            }
        }
        throw new IOException("put request timed out");
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        TreeMap map = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Put put : puts) {
            byte[] row = put.getRow();
            ArrayList<KeyValue> kvs = (ArrayList<KeyValue>)map.get(row);
            if (kvs == null) {
                kvs = new ArrayList<KeyValue>();
                map.put(row, kvs);
            }
            for (List<KeyValue> l : put.getFamilyMap().values()) {
                kvs.addAll(l);
            }
        }
        CellSetModel model = new CellSetModel();
        for (Map.Entry e : map.entrySet()) {
            RowModel row = new RowModel(e.getKey());
            for (KeyValue kv : (List)e.getValue()) {
                row.addCell(new CellModel(kv));
            }
            model.addRow(row);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(this.name));
        sb.append("/$multiput");
        block10: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block10;
                }
                default: {
                    throw new IOException("multiput request failed with " + code);
                }
            }
        }
        throw new IOException("multiput request timed out");
    }

    @Override
    public void delete(Delete delete) throws IOException {
        String spec = this.buildRowSpec(delete.getRow(), delete.getFamilyMap(), delete.getTimeStamp(), delete.getTimeStamp(), 1);
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.delete(spec);
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
                default: {
                    throw new IOException("delete request failed with " + code);
                }
            }
        }
        throw new IOException("delete request timed out");
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.delete(delete);
        }
    }

    @Override
    public void flushCommits() throws IOException {
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return new Scanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return new Scanner(scan);
    }

    @Override
    public boolean isAutoFlush() {
        return true;
    }

    @Override
    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        throw new IOException("getRowOrBefore not supported");
    }

    @Override
    public RowLock lockRow(byte[] row) throws IOException {
        throw new IOException("lockRow not implemented");
    }

    @Override
    public void unlockRow(RowLock rl) throws IOException {
        throw new IOException("unlockRow not implemented");
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        put.add(new KeyValue(row, family, qualifier, value));
        CellSetModel model = this.buildModelFromPut(put);
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(this.name));
        sb.append('/');
        sb.append(Bytes.toStringBinary(put.getRow()));
        sb.append("?check=put");
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return true;
                }
                case 304: {
                    return false;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block7;
                }
                default: {
                    throw new IOException("checkAndPut request failed with " + code);
                }
            }
        }
        throw new IOException("checkAndPut request timed out");
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        Put put = new Put(row);
        put.add(new KeyValue(row, family, qualifier, value));
        CellSetModel model = this.buildModelFromPut(put);
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (this.accessToken != null) {
            sb.append(this.accessToken);
            sb.append('/');
        }
        sb.append(Bytes.toStringBinary(this.name));
        sb.append('/');
        sb.append(Bytes.toStringBinary(row));
        sb.append("?check=delete");
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return true;
                }
                case 304: {
                    return false;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {}
                    continue block7;
                }
                default: {
                    throw new IOException("checkAndDelete request failed with " + code);
                }
            }
        }
        throw new IOException("checkAndDelete request timed out");
    }

    @Override
    public Result increment(Increment increment) throws IOException {
        throw new IOException("Increment not supported");
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        throw new IOException("incrementColumnValue not supported");
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        throw new IOException("incrementColumnValue not supported");
    }

    @Override
    public void batch(List<Row> actions, Object[] results) throws IOException {
        throw new IOException("batch not supported");
    }

    @Override
    public Object[] batch(List<Row> actions) throws IOException {
        throw new IOException("batch not supported");
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        throw new IOException("get(List<Get>) not supported");
    }

    @Override
    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
        throw new UnsupportedOperationException("coprocessorProxy not implemented");
    }

    @Override
    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
        throw new UnsupportedOperationException("coprocessorExec not implemented");
    }

    @Override
    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
        throw new UnsupportedOperationException("coprocessorExec not implemented");
    }

    class Scanner
    implements ResultScanner {
        String uri;

        public Scanner(Scan scan) throws IOException {
            ScannerModel model;
            try {
                model = ScannerModel.fromScan(scan);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append('/');
            if (RemoteHTable.this.accessToken != null) {
                sb.append(RemoteHTable.this.accessToken);
                sb.append('/');
            }
            sb.append(Bytes.toStringBinary(RemoteHTable.this.name));
            sb.append('/');
            sb.append("scanner");
            block8: for (int i = 0; i < RemoteHTable.this.maxRetries; ++i) {
                Response response = RemoteHTable.this.client.post(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
                int code = response.getCode();
                switch (code) {
                    case 201: {
                        this.uri = response.getLocation();
                        return;
                    }
                    case 509: {
                        try {
                            Thread.sleep(RemoteHTable.this.sleepTime);
                        }
                        catch (InterruptedException e) {}
                        continue block8;
                    }
                    default: {
                        throw new IOException("scan request failed with " + code);
                    }
                }
            }
            throw new IOException("scan request timed out");
        }

        @Override
        public Result[] next(int nbRows) throws IOException {
            StringBuilder sb = new StringBuilder(this.uri);
            sb.append("?n=");
            sb.append(nbRows);
            block7: for (int i = 0; i < RemoteHTable.this.maxRetries; ++i) {
                Response response = RemoteHTable.this.client.get(sb.toString(), "application/x-protobuf");
                int code = response.getCode();
                switch (code) {
                    case 200: {
                        CellSetModel model = new CellSetModel();
                        model.getObjectFromMessage(response.getBody());
                        return RemoteHTable.this.buildResultFromModel(model);
                    }
                    case 204: 
                    case 206: {
                        return null;
                    }
                    case 509: {
                        try {
                            Thread.sleep(RemoteHTable.this.sleepTime);
                        }
                        catch (InterruptedException e) {}
                        continue block7;
                    }
                    default: {
                        throw new IOException("scanner.next request failed with " + code);
                    }
                }
            }
            throw new IOException("scanner.next request timed out");
        }

        @Override
        public Result next() throws IOException {
            Result[] results = this.next(1);
            if (results == null || results.length < 1) {
                return null;
            }
            return results[0];
        }

        @Override
        public Iterator<Result> iterator() {
            return new Iter();
        }

        @Override
        public void close() {
            try {
                RemoteHTable.this.client.delete(this.uri);
            }
            catch (IOException e) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            }
        }

        class Iter
        implements Iterator<Result> {
            Result cache;

            public Iter() {
                try {
                    this.cache = Scanner.this.next();
                }
                catch (IOException e) {
                    LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
                }
            }

            @Override
            public boolean hasNext() {
                return this.cache != null;
            }

            @Override
            public Result next() {
                Result result = this.cache;
                try {
                    this.cache = Scanner.this.next();
                }
                catch (IOException e) {
                    LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
                    this.cache = null;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new RuntimeException("remove() not supported");
            }
        }
    }
}

