/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessControllerProtocol;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class AccessController
extends BaseRegionObserver
implements MasterObserver,
AccessControllerProtocol {
    public static final Log LOG = LogFactory.getLog(AccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + AccessController.class.getName()));
    private static final long PROTOCOL_VERSION = 1L;
    TableAuthManager authManager = null;
    boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();

    void initialize(RegionCoprocessorEnvironment e) throws IOException {
        HRegion region = e.getRegion();
        Map<byte[], ListMultimap<String, TablePermission>> tables = AccessControlLists.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, TablePermission>> t : tables.entrySet()) {
            byte[] table = t.getKey();
            ListMultimap<String, TablePermission> perms = t.getValue();
            byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, this.regionEnv.getConfiguration());
            this.authManager.getZKPermissionWatcher().writeToZookeeper(table, serialized);
        }
    }

    void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<KeyValue>> familyMap) {
        TreeSet<byte[]> tableSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], List<KeyValue>> f : familyMap.entrySet()) {
            List<KeyValue> kvs = f.getValue();
            for (KeyValue kv : kvs) {
                if (!Bytes.equals(kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), AccessControlLists.ACL_LIST_FAMILY, 0, AccessControlLists.ACL_LIST_FAMILY.length)) continue;
                tableSet.add(kv.getRow());
            }
        }
        ZKPermissionWatcher zkw = this.authManager.getZKPermissionWatcher();
        Configuration conf = this.regionEnv.getConfiguration();
        for (byte[] tableName : tableSet) {
            try {
                ListMultimap<String, TablePermission> perms = AccessControlLists.getTablePermissions(conf, tableName);
                byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
                zkw.writeToZookeeper(tableName, serialized);
            }
            catch (IOException ex) {
                LOG.error((Object)("Failed updating permissions mirror for '" + tableName + "'"), (Throwable)ex);
            }
        }
    }

    AuthResult permissionGranted(User user, Permission.Action permRequest, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families) {
        HRegionInfo hri = e.getRegion().getRegionInfo();
        HTableDescriptor htd = e.getRegion().getTableDesc();
        byte[] tableName = hri.getTableName();
        if ((hri.isRootRegion() || hri.isMetaRegion()) && permRequest == Permission.Action.READ) {
            return AuthResult.allow("All users allowed", user, permRequest, tableName);
        }
        if (user == null) {
            return AuthResult.deny("No user associated with request!", null, permRequest, tableName);
        }
        if (permRequest == Permission.Action.WRITE && (hri.isRootRegion() || hri.isMetaRegion() || Bytes.equals(tableName, AccessControlLists.ACL_GLOBAL_NAME)) && (this.authManager.authorize(user, Permission.Action.CREATE) || this.authManager.authorize(user, Permission.Action.ADMIN))) {
            return AuthResult.allow("Table permission granted", user, permRequest, tableName);
        }
        String owner = htd.getOwnerString();
        if (user.getShortName().equals(owner)) {
            return AuthResult.allow("User is table owner", user, permRequest, tableName);
        }
        if (this.authManager.authorize(user, tableName, (byte[])null, permRequest)) {
            return AuthResult.allow("Table permission granted", user, permRequest, tableName);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.authManager.authorize(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.authManager.authorize(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny("Failed qualifier check", user, permRequest, tableName, family.getKey(), qualifier);
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List kvList = (List)family.getValue();
                    for (KeyValue kv : kvList) {
                        if (this.authManager.authorize(user, tableName, family.getKey(), kv.getQualifier(), permRequest)) continue;
                        return AuthResult.deny("Failed qualifier check", user, permRequest, tableName, family.getKey(), kv.getQualifier());
                    }
                    continue;
                }
                return AuthResult.deny("Failed family check", user, permRequest, tableName, family.getKey(), null);
            }
            return AuthResult.allow("All family checks passed", user, permRequest, tableName);
        }
        return AuthResult.deny("No families to check and table permission failed", user, permRequest, tableName);
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            AUDITLOG.trace((Object)("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; context: " + result.toContextString()));
        }
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            user = User.getCurrent();
        }
        return user;
    }

    private void requireTableAdminPermission(MasterCoprocessorEnvironment e, byte[] tableName) throws IOException {
        if (this.isActiveUserTableOwner(e, tableName)) {
            this.requirePermission(Permission.Action.CREATE);
        } else {
            this.requirePermission(Permission.Action.ADMIN);
        }
    }

    private void requirePermission(Permission.Action perm) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny("Global check failed", user, perm, null));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow("Global check allowed", user, perm, null));
    }

    private void requirePermission(Permission.Action perm, RegionCoprocessorEnvironment env, Collection<byte[]> families) throws IOException {
        HashMap<byte[], Object> familyMap = new HashMap<byte[], Object>();
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requirePermission(perm, env, familyMap);
    }

    private void requirePermission(Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> families) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = this.permissionGranted(user, perm, env, families);
        this.logResult(result);
        if (!result.isAllowed()) {
            StringBuffer sb = new StringBuffer("");
            if (families != null && families.size() > 0) {
                for (byte[] familyName : families.keySet()) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(Bytes.toString(familyName));
                }
            }
            throw new AccessDeniedException("Insufficient permissions (table=" + env.getRegion().getTableDesc().getNameAsString() + (families != null && families.size() > 0 ? ", family: " + sb.toString() : "") + ", action=" + perm.toString() + ")");
        }
    }

    private boolean hasFamilyQualifierPermission(User user, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Set<byte[]>> familyMap) throws IOException {
        HRegionInfo hri = env.getRegion().getRegionInfo();
        byte[] tableName = hri.getTableName();
        if (user == null) {
            return false;
        }
        if (familyMap != null && familyMap.size() > 0) {
            for (Map.Entry<byte[], ? extends Set<byte[]>> family : familyMap.entrySet()) {
                if (family.getValue() != null && !family.getValue().isEmpty()) {
                    for (byte[] qualifier : family.getValue()) {
                        if (!this.authManager.matchPermission(user, tableName, family.getKey(), qualifier, perm)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.authManager.matchPermission(user, tableName, family.getKey(), perm)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Empty family map passed for permission check");
        }
        return false;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment e = (MasterCoprocessorEnvironment)env;
            this.authManager = TableAuthManager.get(e.getMasterServices().getZooKeeper(), e.getConfiguration());
        }
        if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        this.requirePermission(Permission.Action.CREATE);
        User owner = this.getActiveUser();
        if (desc.getOwnerString() == null || desc.getOwnerString().equals("")) {
            desc.setOwner(owner);
        }
    }

    @Override
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName);
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HTableDescriptor htd) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor column) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, byte[] col) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName, byte[] col) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName, col);
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
        this.requireTableAdminPermission(c.getEnvironment(), tableName);
    }

    @Override
    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, byte[] tableName) throws IOException {
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
    }

    @Override
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
    }

    @Override
    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
    }

    @Override
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
    }

    @Override
    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
        return newValue;
    }

    @Override
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean oldValue, boolean newValue) throws IOException {
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        AccessControlLists.init(ctx.getEnvironment().getMasterServices());
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment e = c.getEnvironment();
        HRegion region = e.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        try {
            this.authManager = TableAuthManager.get(e.getRegionServerServices().getZooKeeper(), this.regionEnv.getConfiguration());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error obtaining TableAuthManager", ioe);
        }
        if (AccessControlLists.isAclRegion(region)) {
            this.aclRegion = true;
            try {
                this.initialize(e);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        }
    }

    @Override
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        this.requirePermission(Permission.Action.READ, c.getEnvironment(), family != null ? Lists.newArrayList((Object[])new byte[][]{family}) : null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void preGet(ObserverContext<RegionCoprocessorEnvironment> c, Get get2, List<KeyValue> result) throws IOException {
        RegionCoprocessorEnvironment e = c.getEnvironment();
        User requestUser = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(requestUser, Permission.Action.READ, e, get2.getFamilyMap());
        if (authResult.isAllowed()) {
            this.logResult(authResult);
            return;
        }
        if (!this.hasFamilyQualifierPermission(requestUser, Permission.Action.READ, e, get2.getFamilyMap())) {
            this.logResult(authResult);
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getNameAsString() + ", action=READ)");
        }
        byte[] table = this.getTableName(e);
        AccessControlFilter filter = new AccessControlFilter(this.authManager, requestUser, table);
        if (get2.getFilter() != null) {
            FilterList wrapper = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList((Object[])new Filter[]{filter, get2.getFilter()}));
            get2.setFilter(wrapper);
        } else {
            get2.setFilter(filter);
        }
        this.logResult(AuthResult.allow("Access allowed with filter", requestUser, Permission.Action.READ, authResult.table));
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get2, boolean exists) throws IOException {
        this.requirePermission(Permission.Action.READ, c.getEnvironment(), get2.familySet());
        return exists;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) throws IOException {
        this.requirePermission(Permission.Action.WRITE, c.getEnvironment(), put.getFamilyMap());
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put.getFamilyMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        this.requirePermission(Permission.Action.WRITE, c.getEnvironment(), delete.getFamilyMap());
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Put put, boolean result) throws IOException {
        List<byte[]> familyMap = Arrays.asList(new byte[][]{family});
        this.requirePermission(Permission.Action.READ, c.getEnvironment(), familyMap);
        this.requirePermission(Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        List<byte[]> familyMap = Arrays.asList(new byte[][]{family});
        this.requirePermission(Permission.Action.READ, c.getEnvironment(), familyMap);
        this.requirePermission(Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return result;
    }

    @Override
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.requirePermission(Permission.Action.WRITE, c.getEnvironment(), Arrays.asList(new byte[][]{family}));
        return -1L;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.requirePermission(Permission.Action.WRITE, c.getEnvironment(), increment.getFamilyMap().keySet());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        String string;
        RegionCoprocessorEnvironment e = c.getEnvironment();
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(user, Permission.Action.READ, e, scan.getFamilyMap());
        if (authResult.isAllowed()) {
            this.logResult(authResult);
            return s;
        }
        if (this.hasFamilyQualifierPermission(user, Permission.Action.READ, e, scan.getFamilyMap())) {
            byte[] table = this.getTableName(e);
            AccessControlFilter filter = new AccessControlFilter(this.authManager, user, table);
            if (scan.hasFilter()) {
                FilterList wrapper = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList((Object[])new Filter[]{filter, scan.getFilter()}));
                scan.setFilter(wrapper);
            } else {
                scan.setFilter(filter);
            }
            this.logResult(AuthResult.allow("Access allowed with filter", user, Permission.Action.READ, authResult.table));
            return s;
        }
        this.logResult(authResult);
        StringBuilder stringBuilder = new StringBuilder().append("Insufficient permissions for user '");
        if (user != null) {
            string = user.getShortName();
            throw new AccessDeniedException(stringBuilder.append(string).append("' ").append("for scanner open on table ").append(Bytes.toString(this.getTableName(e))).toString());
        }
        string = "null";
        throw new AccessDeniedException(stringBuilder.append(string).append("' ").append("for scanner open on table ").append(Bytes.toString(this.getTableName(e))).toString());
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUserName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUserName)) {
                throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void grant(UserPermission userPermission) throws IOException {
        if (this.aclRegion) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received request to grant access permission " + userPermission.toString()));
            }
            this.requirePermission(Permission.Action.ADMIN);
            AccessControlLists.addUserPermission(this.regionEnv.getConfiguration(), userPermission);
            if (AUDITLOG.isTraceEnabled()) {
                AUDITLOG.trace((Object)("Granted permission " + userPermission.toString()));
            }
        } else {
            throw new CoprocessorException(AccessController.class, "This method can only execute at " + Bytes.toString(AccessControlLists.ACL_TABLE_NAME) + " table.");
        }
    }

    @Override
    @Deprecated
    public void grant(byte[] user, TablePermission permission) throws IOException {
        this.grant(new UserPermission(user, permission.getTable(), permission.getFamily(), permission.getQualifier(), permission.getActions()));
    }

    @Override
    public void revoke(UserPermission userPermission) throws IOException {
        if (this.aclRegion) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received request to revoke access permission " + userPermission.toString()));
            }
            this.requirePermission(Permission.Action.ADMIN);
            AccessControlLists.removeUserPermission(this.regionEnv.getConfiguration(), userPermission);
            if (AUDITLOG.isTraceEnabled()) {
                AUDITLOG.trace((Object)("Revoked permission " + userPermission.toString()));
            }
        } else {
            throw new CoprocessorException(AccessController.class, "This method can only execute at " + Bytes.toString(AccessControlLists.ACL_TABLE_NAME) + " table.");
        }
    }

    @Override
    @Deprecated
    public void revoke(byte[] user, TablePermission permission) throws IOException {
        this.revoke(new UserPermission(user, permission.getTable(), permission.getFamily(), permission.getQualifier(), permission.getActions()));
    }

    @Override
    public List<UserPermission> getUserPermissions(byte[] tableName) throws IOException {
        if (this.aclRegion) {
            this.requirePermission(Permission.Action.ADMIN);
            List<UserPermission> perms = AccessControlLists.getUserPermissions(this.regionEnv.getConfiguration(), tableName);
            return perms;
        }
        throw new CoprocessorException(AccessController.class, "This method can only execute at " + Bytes.toString(AccessControlLists.ACL_TABLE_NAME) + " table.");
    }

    @Override
    public void checkPermissions(Permission[] permissions) throws IOException {
        byte[] tableName = this.regionEnv.getRegion().getTableDesc().getName();
        for (Permission permission : permissions) {
            if (permission instanceof TablePermission) {
                TablePermission tperm = (TablePermission)permission;
                for (Permission.Action action : permission.getActions()) {
                    if (!Arrays.equals(tperm.getTable(), tableName)) {
                        throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", Bytes.toString(tableName), Bytes.toString(tperm.getTable())));
                    }
                    HashMap familyMap = Maps.newHashMapWithExpectedSize((int)1);
                    if (tperm.getFamily() != null) {
                        if (tperm.getQualifier() != null) {
                            familyMap.put(tperm.getFamily(), Sets.newHashSet((Object[])new byte[][]{tperm.getQualifier()}));
                        } else {
                            familyMap.put(tperm.getFamily(), null);
                        }
                    }
                    this.requirePermission(action, this.regionEnv, familyMap);
                }
                continue;
            }
            for (Permission.Action action : permission.getActions()) {
                this.requirePermission(action);
            }
        }
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return 1L;
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        if (AccessControllerProtocol.class.getName().equals(protocol)) {
            return new ProtocolSignature(1L, null);
        }
        throw new HBaseRPC.UnknownProtocolException("Unexpected protocol requested: " + protocol);
    }

    private byte[] getTableName(RegionCoprocessorEnvironment e) {
        HRegionInfo regionInfo;
        HRegion region = e.getRegion();
        byte[] tableName = null;
        if (region != null && (regionInfo = region.getRegionInfo()) != null) {
            tableName = regionInfo.getTableName();
        }
        return tableName;
    }

    private String getTableOwner(MasterCoprocessorEnvironment e, byte[] tableName) throws IOException {
        HTableDescriptor htd = e.getTable(tableName).getTableDescriptor();
        return htd.getOwnerString();
    }

    private boolean isActiveUserTableOwner(MasterCoprocessorEnvironment e, byte[] tableName) throws IOException {
        String activeUser = this.getActiveUser().getShortName();
        return activeUser.equals(this.getTableOwner(e, tableName));
    }

    private static class AuthResult {
        private final boolean allowed;
        private final byte[] table;
        private final byte[] family;
        private final byte[] qualifier;
        private final Permission.Action action;
        private final String reason;
        private final User user;

        public AuthResult(boolean allowed, String reason, User user, Permission.Action action, byte[] table, byte[] family, byte[] qualifier) {
            this.allowed = allowed;
            this.reason = reason;
            this.user = user;
            this.table = table;
            this.family = family;
            this.qualifier = qualifier;
            this.action = action;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public User getUser() {
            return this.user;
        }

        public String getReason() {
            return this.reason;
        }

        public String toContextString() {
            return "(user=" + (this.user != null ? this.user.getName() : "UNKNOWN") + ", " + "scope=" + (this.table == null ? "GLOBAL" : Bytes.toString(this.table)) + ", " + "family=" + (this.family != null ? Bytes.toString(this.family) : "") + ", " + "qualifer=" + (this.qualifier != null ? Bytes.toString(this.qualifier) : "") + ", " + "action=" + (this.action != null ? this.action.toString() : "") + ")";
        }

        public String toString() {
            return "AuthResult" + this.toContextString();
        }

        public static AuthResult allow(String reason, User user, Permission.Action action, byte[] table) {
            return new AuthResult(true, reason, user, action, table, null, null);
        }

        public static AuthResult deny(String reason, User user, Permission.Action action, byte[] table) {
            return new AuthResult(false, reason, user, action, table, null, null);
        }

        public static AuthResult deny(String reason, User user, Permission.Action action, byte[] table, byte[] family, byte[] qualifier) {
            return new AuthResult(false, reason, user, action, table, family, qualifier);
        }
    }
}

