/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class TableAuthManager {
    private static Log LOG = LogFactory.getLog(TableAuthManager.class);
    private static TableAuthManager instance;
    private ListMultimap<String, Permission> USER_CACHE = ArrayListMultimap.create();
    private ListMultimap<String, Permission> GROUP_CACHE = ArrayListMultimap.create();
    private ConcurrentSkipListMap<byte[], ListMultimap<String, TablePermission>> TABLE_USER_CACHE = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private ConcurrentSkipListMap<byte[], ListMultimap<String, TablePermission>> TABLE_GROUP_CACHE = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private Configuration conf;
    private ZKPermissionWatcher zkperms;
    static Map<ZooKeeperWatcher, TableAuthManager> managerMap;

    private TableAuthManager(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        this.conf = conf;
        this.zkperms = new ZKPermissionWatcher(watcher, this, conf);
        try {
            this.zkperms.start();
        }
        catch (KeeperException ke) {
            LOG.error((Object)"ZooKeeper initialization failed", (Throwable)ke);
        }
        this.initGlobal(conf);
    }

    private void initGlobal(Configuration conf) throws IOException {
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String currentUser = user.getShortName();
        List superusers = Lists.asList((Object)currentUser, (Object[])conf.getStrings("hbase.superuser", new String[0]));
        if (superusers != null) {
            for (String name : superusers) {
                if (AccessControlLists.isGroupPrincipal(name)) {
                    this.GROUP_CACHE.put((Object)AccessControlLists.getGroupName(name), (Object)new Permission(Permission.Action.values()));
                    continue;
                }
                this.USER_CACHE.put((Object)name, (Object)new Permission(Permission.Action.values()));
            }
        }
    }

    public ZKPermissionWatcher getZKPermissionWatcher() {
        return this.zkperms;
    }

    public void refreshCacheFromWritable(byte[] table, byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            ListMultimap perms = AccessControlLists.readPermissions(in, this.conf);
            if (perms != null) {
                if (Bytes.equals(table, AccessControlLists.ACL_GLOBAL_NAME)) {
                    this.updateGlobalCache(perms);
                } else {
                    this.updateTableCache(table, perms);
                }
            }
        } else {
            LOG.debug((Object)"Skipping permission cache refresh because writable data is empty");
        }
    }

    private void updateGlobalCache(ListMultimap<String, TablePermission> userPerms) {
        for (Map.Entry entry : userPerms.entries()) {
            if (AccessControlLists.isGroupPrincipal((String)entry.getKey())) {
                this.GROUP_CACHE.put((Object)AccessControlLists.getGroupName((String)entry.getKey()), (Object)new Permission(((TablePermission)((Object)entry.getValue())).getActions()));
                continue;
            }
            this.USER_CACHE.put(entry.getKey(), (Object)new Permission(((TablePermission)((Object)entry.getValue())).getActions()));
        }
    }

    private void updateTableCache(byte[] table, ListMultimap<String, TablePermission> tablePerms) {
        ArrayListMultimap userPerms = ArrayListMultimap.create();
        ArrayListMultimap groupPerms = ArrayListMultimap.create();
        for (Map.Entry entry : tablePerms.entries()) {
            if (AccessControlLists.isGroupPrincipal((String)entry.getKey())) {
                groupPerms.put((Object)AccessControlLists.getGroupName((String)entry.getKey()), entry.getValue());
                continue;
            }
            userPerms.put(entry.getKey(), entry.getValue());
        }
        this.TABLE_GROUP_CACHE.put(table, (ListMultimap<String, TablePermission>)groupPerms);
        this.TABLE_USER_CACHE.put(table, (ListMultimap<String, TablePermission>)userPerms);
    }

    private List<TablePermission> getUserPermissions(String username, byte[] table) {
        ListMultimap<String, TablePermission> tablePerms = this.TABLE_USER_CACHE.get(table);
        if (tablePerms != null) {
            return tablePerms.get((Object)username);
        }
        return null;
    }

    private List<TablePermission> getGroupPermissions(String groupName, byte[] table) {
        ListMultimap<String, TablePermission> tablePerms = this.TABLE_GROUP_CACHE.get(table);
        if (tablePerms != null) {
            return tablePerms.get((Object)groupName);
        }
        return null;
    }

    private boolean authorize(List<Permission> perms, Permission.Action action) {
        if (perms != null) {
            for (Permission p : perms) {
                if (!p.implies(action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No permissions found");
        }
        return false;
    }

    public boolean authorize(User user, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (this.authorize(this.USER_CACHE.get((Object)user.getShortName()), action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.authorize(this.GROUP_CACHE.get((Object)group), action)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, byte[] table, byte[] family, Permission.Action action) {
        return this.authorize(perms, table, family, null, action);
    }

    private boolean authorize(List<TablePermission> perms, byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(table, family, qualifier, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No permissions found for table=" + Bytes.toStringBinary(table)));
        }
        return false;
    }

    public boolean authorize(User user, byte[] table, KeyValue kv, Permission.Action action) {
        List<TablePermission> userPerms = this.getUserPermissions(user.getShortName(), table);
        if (this.authorize(userPerms, table, kv, action)) {
            return true;
        }
        String[] groupNames = user.getGroupNames();
        if (groupNames != null) {
            for (String group : groupNames) {
                List<TablePermission> groupPerms = this.getGroupPermissions(group, table);
                if (!this.authorize(groupPerms, table, kv, action)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, byte[] table, KeyValue kv, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(table, kv, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No permissions for authorize() check, table=" + Bytes.toStringBinary(table)));
        }
        return false;
    }

    public boolean authorizeUser(String username, Permission.Action action) {
        return this.authorize(this.USER_CACHE.get((Object)username), action);
    }

    public boolean authorizeUser(String username, byte[] table, byte[] family, Permission.Action action) {
        return this.authorizeUser(username, table, family, null, action);
    }

    public boolean authorizeUser(String username, byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.authorizeUser(username, action)) {
            return true;
        }
        return this.authorize(this.getUserPermissions(username, table), table, family, qualifier, action);
    }

    public boolean authorizeGroup(String groupName, Permission.Action action) {
        return this.authorize(this.GROUP_CACHE.get((Object)groupName), action);
    }

    public boolean authorizeGroup(String groupName, byte[] table, byte[] family, Permission.Action action) {
        if (this.authorizeGroup(groupName, action)) {
            return true;
        }
        return this.authorize(this.getGroupPermissions(groupName, table), table, family, action);
    }

    public boolean authorize(User user, byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.authorizeUser(user.getShortName(), table, family, qualifier, action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.authorizeGroup(group, table, family, action)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean authorize(User user, byte[] table, byte[] family, Permission.Action action) {
        return this.authorize(user, table, family, null, action);
    }

    public boolean matchPermission(User user, byte[] table, byte[] family, Permission.Action action) {
        String[] groups;
        List<TablePermission> userPerms = this.getUserPermissions(user.getShortName(), table);
        if (userPerms != null) {
            for (TablePermission p : userPerms) {
                if (!p.matchesFamily(table, family, action)) continue;
                return true;
            }
        }
        if ((groups = user.getGroupNames()) != null) {
            for (String group : groups) {
                List<TablePermission> groupPerms = this.getGroupPermissions(group, table);
                if (groupPerms == null) continue;
                for (TablePermission p : groupPerms) {
                    if (!p.matchesFamily(table, family, action)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean matchPermission(User user, byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        String[] groups;
        List<TablePermission> userPerms = this.getUserPermissions(user.getShortName(), table);
        if (userPerms != null) {
            for (TablePermission p : userPerms) {
                if (!p.matchesFamilyQualifier(table, family, qualifier, action)) continue;
                return true;
            }
        }
        if ((groups = user.getGroupNames()) != null) {
            for (String group : groups) {
                List<TablePermission> groupPerms = this.getGroupPermissions(group, table);
                if (groupPerms == null) continue;
                for (TablePermission p : groupPerms) {
                    if (!p.matchesFamilyQualifier(table, family, qualifier, action)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void remove(byte[] table) {
        this.TABLE_USER_CACHE.remove(table);
        this.TABLE_GROUP_CACHE.remove(table);
    }

    public void setUserPermissions(String username, byte[] table, List<TablePermission> perms) {
        ArrayListMultimap tablePerms = this.TABLE_USER_CACHE.get(table);
        if (tablePerms == null) {
            tablePerms = ArrayListMultimap.create();
            this.TABLE_USER_CACHE.put(table, (ListMultimap<String, TablePermission>)tablePerms);
        }
        tablePerms.replaceValues((Object)username, perms);
        this.writeToZooKeeper(table, (ListMultimap<String, TablePermission>)tablePerms, this.TABLE_GROUP_CACHE.get(table));
    }

    public void setGroupPermissions(String group, byte[] table, List<TablePermission> perms) {
        ArrayListMultimap tablePerms = this.TABLE_GROUP_CACHE.get(table);
        if (tablePerms == null) {
            tablePerms = ArrayListMultimap.create();
            this.TABLE_GROUP_CACHE.put(table, (ListMultimap<String, TablePermission>)tablePerms);
        }
        tablePerms.replaceValues((Object)group, perms);
        this.writeToZooKeeper(table, this.TABLE_USER_CACHE.get(table), (ListMultimap<String, TablePermission>)tablePerms);
    }

    public void writeToZooKeeper(byte[] table, ListMultimap<String, TablePermission> userPerms, ListMultimap<String, TablePermission> groupPerms) {
        ArrayListMultimap tmp = ArrayListMultimap.create();
        if (userPerms != null) {
            tmp.putAll(userPerms);
        }
        if (groupPerms != null) {
            for (String group : groupPerms.keySet()) {
                tmp.putAll((Object)("@" + group), (Iterable)groupPerms.get((Object)group));
            }
        }
        byte[] serialized = AccessControlLists.writePermissionsAsBytes((ListMultimap<String, ? extends Permission>)tmp, this.conf);
        this.zkperms.writeToZookeeper(table, serialized);
    }

    public static synchronized TableAuthManager get(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        instance = managerMap.get(watcher);
        if (instance == null) {
            instance = new TableAuthManager(watcher, conf);
            managerMap.put(watcher, instance);
        }
        return instance;
    }

    static {
        managerMap = new HashMap<ZooKeeperWatcher, TableAuthManager>();
    }
}

