/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.SecureServer;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationProtocol;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class TokenProvider
extends BaseEndpointCoprocessor
implements AuthenticationProtocol {
    public static final long VERSION = 0L;
    private static Log LOG = LogFactory.getLog(TokenProvider.class);
    private AuthenticationTokenSecretManager secretManager;

    @Override
    public void start(CoprocessorEnvironment env) {
        SecretManager<? extends TokenIdentifier> mgr;
        RegionCoprocessorEnvironment regionEnv;
        RpcServer server;
        super.start(env);
        if (env instanceof RegionCoprocessorEnvironment && (server = (regionEnv = (RegionCoprocessorEnvironment)env).getRegionServerServices().getRpcServer()) instanceof SecureServer && (mgr = ((SecureServer)server).getSecretManager()) instanceof AuthenticationTokenSecretManager) {
            this.secretManager = (AuthenticationTokenSecretManager)mgr;
        }
    }

    @Override
    public Token<AuthenticationTokenIdentifier> getAuthenticationToken() throws IOException {
        if (this.secretManager == null) {
            throw new IOException("No secret manager configured for token authentication");
        }
        User currentUser = RequestContext.getRequestUser();
        UserGroupInformation ugi = null;
        if (currentUser != null) {
            ugi = currentUser.getUGI();
        }
        if (currentUser == null) {
            throw new AccessDeniedException("No authenticated user for request!");
        }
        if (ugi.getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS) {
            LOG.warn((Object)("Token generation denied for user=" + currentUser.getName() + ", authMethod=" + ugi.getAuthenticationMethod()));
            throw new AccessDeniedException("Token generation only allowed for Kerberos authenticated clients");
        }
        return this.secretManager.generateToken(currentUser.getName());
    }

    @Override
    public String whoami() {
        return RequestContext.getRequestUserName();
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (AuthenticationProtocol.class.getName().equals(protocol)) {
            return 0L;
        }
        LOG.warn((Object)("Unknown protocol requested: " + protocol));
        return -1L;
    }
}

