/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class BatchMutation
implements TBase<BatchMutation, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("BatchMutation");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField MUTATIONS_FIELD_DESC = new TField("mutations", 15, 2);
    public ByteBuffer row;
    public List<Mutation> mutations;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public BatchMutation() {
    }

    public BatchMutation(ByteBuffer row, List<Mutation> mutations) {
        this();
        this.row = row;
        this.mutations = mutations;
    }

    public BatchMutation(BatchMutation other) {
        if (other.isSetRow()) {
            this.row = other.row;
        }
        if (other.isSetMutations()) {
            ArrayList<Mutation> __this__mutations = new ArrayList<Mutation>();
            for (Mutation other_element : other.mutations) {
                __this__mutations.add(new Mutation(other_element));
            }
            this.mutations = __this__mutations;
        }
    }

    public BatchMutation deepCopy() {
        return new BatchMutation(this);
    }

    public void clear() {
        this.row = null;
        this.mutations = null;
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return this.row;
    }

    public BatchMutation setRow(byte[] row) {
        this.setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
        return this;
    }

    public BatchMutation setRow(ByteBuffer row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getMutationsSize() {
        return this.mutations == null ? 0 : this.mutations.size();
    }

    public Iterator<Mutation> getMutationsIterator() {
        return this.mutations == null ? null : this.mutations.iterator();
    }

    public void addToMutations(Mutation elem) {
        if (this.mutations == null) {
            this.mutations = new ArrayList<Mutation>();
        }
        this.mutations.add(elem);
    }

    public List<Mutation> getMutations() {
        return this.mutations;
    }

    public BatchMutation setMutations(List<Mutation> mutations) {
        this.mutations = mutations;
        return this;
    }

    public void unsetMutations() {
        this.mutations = null;
    }

    public boolean isSetMutations() {
        return this.mutations != null;
    }

    public void setMutationsIsSet(boolean value) {
        if (!value) {
            this.mutations = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case MUTATIONS: {
                if (value == null) {
                    this.unsetMutations();
                    break;
                }
                this.setMutations((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case MUTATIONS: {
                return this.getMutations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case MUTATIONS: {
                return this.isSetMutations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof BatchMutation) {
            return this.equals((BatchMutation)that);
        }
        return false;
    }

    public boolean equals(BatchMutation that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_mutations = this.isSetMutations();
        boolean that_present_mutations = that.isSetMutations();
        if (this_present_mutations || that_present_mutations) {
            if (!this_present_mutations || !that_present_mutations) {
                return false;
            }
            if (!((Object)this.mutations).equals(that.mutations)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(BatchMutation other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        BatchMutation typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(typedOther.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)typedOther.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMutations()).compareTo(typedOther.isSetMutations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMutations() && (lastComparison = TBaseHelper.compareTo(this.mutations, typedOther.mutations)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.row = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.mutations = new ArrayList<Mutation>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            Mutation _elem2 = new Mutation();
                            _elem2.read(iprot);
                            this.mutations.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.row != null) {
            oprot.writeFieldBegin(ROW_FIELD_DESC);
            oprot.writeBinary(this.row);
            oprot.writeFieldEnd();
        }
        if (this.mutations != null) {
            oprot.writeFieldBegin(MUTATIONS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.mutations.size()));
            for (Mutation _iter3 : this.mutations) {
                _iter3.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BatchMutation(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            sb.append(this.row);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("mutations:");
        if (this.mutations == null) {
            sb.append("null");
        } else {
            sb.append(this.mutations);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 3, new FieldValueMetaData(11, "Text")));
        tmpMap.put(_Fields.MUTATIONS, new FieldMetaData("mutations", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Mutation.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(BatchMutation.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        MUTATIONS(2, "mutations");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROW;
                }
                case 2: {
                    return MUTATIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

