/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.compress.Compressor;

public class CompressionTest {
    static final Log LOG = LogFactory.getLog(CompressionTest.class);
    private static final Boolean[] compressionTestResults = new Boolean[Compression.Algorithm.values().length];
    protected static Path path;

    public static boolean testCompression(String codec) {
        Compression.Algorithm a;
        codec = codec.toLowerCase();
        try {
            a = Compression.getCompressionAlgorithmByName(codec);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Codec type: " + codec + " is not known"));
            return false;
        }
        try {
            CompressionTest.testCompression(a);
            return true;
        }
        catch (IOException ignored) {
            LOG.warn((Object)("Can't instantiate codec: " + codec), (Throwable)ignored);
            return false;
        }
    }

    public static void testCompression(Compression.Algorithm algo) throws IOException {
        if (compressionTestResults[algo.ordinal()] != null) {
            if (compressionTestResults[algo.ordinal()].booleanValue()) {
                return;
            }
            throw new IOException("Compression algorithm '" + algo.getName() + "'" + " previously failed test.");
        }
        Configuration conf = HBaseConfiguration.create();
        try {
            Compressor c = algo.getCompressor();
            algo.returnCompressor(c);
            CompressionTest.compressionTestResults[algo.ordinal()] = true;
        }
        catch (Throwable t) {
            CompressionTest.compressionTestResults[algo.ordinal()] = false;
            throw new IOException(t);
        }
    }

    public static void usage() {
        System.err.println("Usage: CompressionTest <path> none|gz|lzo|snappy\n\nFor example:\n  hbase " + CompressionTest.class + " file:///tmp/testfile gz\n");
        System.exit(1);
    }

    public static void doSmokeTest(FileSystem fs, Path path, String codec) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HFile.Writer writer = HFile.getWriterFactory(conf).createWriter(fs, path, 65536, codec, null);
        writer.append(Bytes.toBytes("testkey"), Bytes.toBytes("testval"));
        writer.appendFileInfo(Bytes.toBytes("infokey"), Bytes.toBytes("infoval"));
        writer.close();
        HFile.Reader reader = HFile.createReader(fs, path, new CacheConfig(conf));
        reader.loadFileInfo();
        byte[] key = reader.getFirstKey();
        boolean rc = Bytes.toString(key).equals("testkey");
        reader.close();
        if (!rc) {
            throw new Exception("Read back incorrect result: " + Bytes.toStringBinary(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            CompressionTest.usage();
            System.exit(1);
        }
        Configuration conf = new Configuration();
        Path path = new Path(args[0]);
        FileSystem fs = path.getFileSystem(conf);
        try {
            CompressionTest.doSmokeTest(fs, path, args[1]);
        }
        finally {
            fs.delete(path, false);
        }
        System.out.println("SUCCESS");
    }

    static {
        for (int i = 0; i < compressionTestResults.length; ++i) {
            CompressionTest.compressionTestResults[i] = null;
        }
        path = new Path(".hfile-comp-test");
    }
}

