/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;

public class FSHDFSUtils
extends FSUtils {
    private static final Log LOG = LogFactory.getLog(FSHDFSUtils.class);
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;

    @Override
    public void recoverFileLease(FileSystem fs, Path p) throws IOException {
        if (!FSHDFSUtils.isSyncSupported() && !FSHDFSUtils.isHflushSupported()) {
            LOG.warn((Object)"Running on HDFS without sync or hflush enabled may result in data loss");
            return;
        }
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        LOG.info((Object)("Recovering file " + p));
        long startWaiting = System.currentTimeMillis();
        boolean recovered = false;
        while (!recovered) {
            try {
                try {
                    if (!(fs instanceof DistributedFileSystem)) {
                        throw new Exception("Not a DistributedFileSystem");
                    }
                    DistributedFileSystem dfs = (DistributedFileSystem)fs;
                    DistributedFileSystem.class.getMethod("recoverLease", Path.class).invoke((Object)dfs, p);
                }
                catch (InvocationTargetException ite) {
                    throw (IOException)ite.getCause();
                }
                catch (Exception e) {
                    LOG.debug((Object)("Failed fs.recoverLease invocation, " + e.toString() + ", trying fs.append instead"));
                    FSDataOutputStream out = fs.append(p);
                    out.close();
                }
                recovered = true;
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException(e);
                if (e instanceof AlreadyBeingCreatedException) {
                    long waitedFor = System.currentTimeMillis() - startWaiting;
                    if (waitedFor > 60000L) {
                        LOG.warn((Object)("Waited " + waitedFor + "ms for lease recovery on " + p + ":" + e.getMessage()));
                    }
                }
                if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                    throw new FileNotFoundException("The given HLog wasn't found at " + p.toString());
                }
                throw new IOException("Failed to open " + p + " for append", e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                new InterruptedIOException().initCause(ex);
            }
        }
        LOG.info((Object)("Finished lease recover attempt for " + p));
    }
}

