/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryCounter {
    private static final Log LOG = LogFactory.getLog(RetryCounter.class);
    private final int maxRetries;
    private int retriesRemaining;
    private final int retryIntervalMillis;
    private final TimeUnit timeUnit;

    public RetryCounter(int maxRetries, int retryIntervalMillis, TimeUnit timeUnit) {
        this.maxRetries = maxRetries;
        this.retriesRemaining = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
        this.timeUnit = timeUnit;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void sleepUntilNextRetry() throws InterruptedException {
        int attempts = this.getAttemptTimes();
        long sleepTime = (long)((double)this.retryIntervalMillis * Math.pow(2.0, attempts));
        LOG.info((Object)("The " + attempts + " times to retry  after sleeping " + sleepTime + " ms"));
        this.timeUnit.sleep(sleepTime);
    }

    public boolean shouldRetry() {
        return this.retriesRemaining > 0;
    }

    public void useRetry() {
        --this.retriesRemaining;
    }

    public int getAttemptTimes() {
        return this.maxRetries - this.retriesRemaining + 1;
    }
}

