/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import pt.webdetails.cgg.charts.Chart;
import pt.webdetails.cgg.charts.SVGChart;
import pt.webdetails.cgg.scripts.Script;
import pt.webdetails.cgg.scripts.ScriptFactory;

public class CggContentGenerator
extends BaseContentGenerator {
    public static final String CDW_EXTENSION = ".cdw";
    public static final String PLUGIN_NAME = "cgg";
    public static final String PLUGIN_PATH = "system/cgg/";
    private static final Log logger = LogFactory.getLog(CggContentGenerator.class);
    private static final String MIME_XML = "text/xml";
    private static final String MIME_HTML = "text/html";
    private static final String MIME_SVG = "image/svg+xml";
    private static final String MIME_PNG = "image/png";

    public Log getLogger() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void createContent() throws Exception {
        try {
            IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
            IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
            OutputStream out = this.outputHandler.getOutputContentItem("response", "content", "", this.instanceId, MIME_PNG).getOutputStream(null);
            String method = pathParams.getStringParameter("path", null);
            try {
                switch (methods.valueOf(method.replaceAll("/", "").toUpperCase())) {
                    case DRAW: {
                        this.draw(requestParams, out);
                        break;
                    }
                    case REFRESH: {
                        this.refresh(requestParams, out);
                        break;
                    }
                    default: {
                        logger.error((Object)"No method passed to content generator");
                        break;
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(CggContentGenerator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(CggContentGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void draw(IParameterProvider requestParams, OutputStream out) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Iterator inputParams = requestParams.getParameterNames();
            while (inputParams.hasNext()) {
                String paramName = inputParams.next().toString();
                if (!paramName.startsWith("param")) continue;
                String pName = paramName.substring(5);
                Object[] p = requestParams.getArrayParameter(paramName, null);
                if (p.length == 1) {
                    params.put(pName, p[0]);
                    continue;
                }
                params.put(pName, p);
            }
            IPentahoSession session = PentahoSessionHolder.getSession();
            ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            ISolutionFile systemPath = solutionRepository.getSolutionFile(PLUGIN_PATH, 0);
            String solutionRoot = PentahoSystem.getApplicationContext().getSolutionRootPath();
            String scriptName = requestParams.getStringParameter("script", "");
            String scriptType = requestParams.getStringParameter("type", "svg");
            String outputType = requestParams.getStringParameter("outputType", "png");
            String attachmentName = requestParams.getStringParameter("attachmentName", null);
            if (attachmentName != null) {
                HttpServletResponse response = (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
                String filename = attachmentName.indexOf(".") > 0 ? attachmentName : attachmentName + "." + outputType;
                response.setHeader("content-disposition", "attachment; filename=" + filename);
            }
            Long width = requestParams.getLongParameter("width", 0L);
            Long height = requestParams.getLongParameter("height", 0L);
            logger.debug((Object)("Starting:" + new Date().getTime()));
            try {
                ScriptFactory factory = ScriptFactory.getInstance();
                factory.setSystemPath(solutionRoot + "/" + systemPath.getSolutionPath() + "/libs/");
                Script script = factory.createScript(scriptName, scriptType, (long)width, (long)height);
                logger.debug((Object)("Script created:" + new Date().getTime()));
                Chart chart = script.execute(params);
                logger.debug((Object)("Script executed:" + new Date().getTime()));
                this.getOutput(chart, outputTypes.valueOf(outputType.toUpperCase()), out);
                logger.debug((Object)("Image exported:" + new Date().getTime()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(CggContentGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void getOutput(Chart chart, outputTypes outputType, OutputStream out) {
        switch (outputType) {
            case PDF: {
                break;
            }
            case PNG: {
                chart.toPNG(out);
                break;
            }
            case SVG: {
                this.setResponseHeaders(MIME_SVG, null);
                if (!(chart instanceof SVGChart)) break;
                ((SVGChart)chart).toSVG(out);
                break;
            }
        }
    }

    private void refresh(IParameterProvider requestParams, OutputStream out) {
        ScriptFactory.getInstance().clearCachedScopes();
    }

    private void setResponseHeaders(String mimeType, String attachmentName) {
        HttpServletResponse response = (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
        response.setHeader("Content-Type", mimeType);
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        response.setHeader("Cache-Control", "max-age=0, no-store");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum outputTypes {
        SVG,
        PNG,
        PDF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum methods {
        DRAW,
        REFRESH,
        DRAWCDW,
        LISTCDW,
        GETCDW;

    }
}

