/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.charts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import pt.webdetails.cgg.charts.Chart;

public class SVGChart
implements Chart {
    private static final Log logger = LogFactory.getLog(SVGChart.class);
    private Document svg;
    private String svgSource;

    public SVGChart(String svgSource) {
        this.svgSource = svgSource;
    }

    public SVGChart(Document doc) {
        this.svg = doc;
    }

    public void toPNG(OutputStream out) {
        PNGTranscoder t = new PNGTranscoder();
        TranscoderInput input = new TranscoderInput(this.svg);
        TranscoderOutput output = new TranscoderOutput(out);
        try {
            t.transcode(input, output);
            out.flush();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        catch (TranscoderException ex) {
            logger.error((Object)ex);
        }
    }

    public void toSVG(OutputStream out) {
        SVGTranscoder t = new SVGTranscoder();
        TranscoderInput input = new TranscoderInput(this.svg);
        TranscoderOutput output = new TranscoderOutput((Writer)new OutputStreamWriter(out));
        try {
            t.transcode(input, output);
            out.flush();
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        catch (TranscoderException ex) {
            logger.error((Object)ex);
        }
    }
}

