/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.datasources;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cgg.datasources.Datasource;

public class CdaDatasource
implements Datasource {
    private Map<String, Object> requestMap = new HashMap<String, Object>();
    private static final Log logger = LogFactory.getLog(CdaDatasource.class);

    private String getQueryData() {
        IContentGenerator cda;
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)userSession);
        try {
            cda = pluginManager.getContentGenerator("cda", userSession);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to acquire CDA plugin to query");
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SimpleOutputHandler outputHandler = new SimpleOutputHandler((OutputStream)outputStream, false);
        SimpleParameterProvider requestParams = new SimpleParameterProvider(this.requestMap);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("path", "/doQuery");
        SimpleParameterProvider pathParams = new SimpleParameterProvider(pathMap);
        HashMap<String, SimpleParameterProvider> paramProvider = new HashMap<String, SimpleParameterProvider>();
        paramProvider.put("request", requestParams);
        paramProvider.put("path", pathParams);
        try {
            cda.setSession(userSession);
            cda.setOutputHandler((IOutputHandler)outputHandler);
            cda.setParameterProviders(paramProvider);
            cda.createContent();
            return outputStream.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to execute query: " + e.toString()));
            return null;
        }
    }

    public String execute() {
        return this.getQueryData();
    }

    public void setParameter(String param, String val) {
        this.requestMap.put("param" + param, val);
    }

    public void setParameter(String param, String[] val) {
        this.requestMap.put("param" + param, val);
    }

    public void setParameter(String param, Date val) {
        this.requestMap.put("param" + param, val);
    }

    public void setParameter(String param, List val) {
        this.requestMap.put("param" + param, val.toArray());
    }

    public void setDataAccessId(String id) {
        this.requestMap.put("dataAccessId", id);
    }

    public void setDefinitionFile(String file) {
        this.requestMap.put("path", file);
    }
}

