/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cgg.scripts.BaseScope;
import pt.webdetails.cgg.scripts.Java2DScript;
import pt.webdetails.cgg.scripts.Script;
import pt.webdetails.cgg.scripts.SvgScript;

public class ScriptFactory {
    private static final Log logger = LogFactory.getLog(ScriptFactory.class);
    private static ScriptFactory instance;
    private Map<ScriptType, Scriptable> scopes = new EnumMap<ScriptType, Scriptable>(ScriptType.class);
    private String systemPath;

    public static synchronized ScriptFactory getInstance() {
        if (instance == null) {
            instance = new ScriptFactory();
        }
        return instance;
    }

    private ScriptFactory() {
    }

    public Script createScript(String path, String scriptType, long width, long height) {
        try {
            ScriptType st = ScriptType.valueOf(scriptType.toUpperCase());
            return this.createScript(path, st, width, height);
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)("No such script type: " + scriptType));
            return null;
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage());
            return null;
        }
    }

    public Script createScript(String path, ScriptType scriptType, long width, long height) throws FileNotFoundException {
        String solutionRoot = PentahoSystem.getApplicationContext().getSolutionRootPath();
        IPentahoSession session = PentahoSessionHolder.getSession();
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
        Script script = null;
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.mozilla.javascript.Context");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
        ISolutionFile solutionFile = solutionRepository.getSolutionFile(path, 0);
        if (solutionFile == null) {
            throw new FileNotFoundException("Couldn't find " + path);
        }
        switch (scriptType) {
            case SVG: {
                script = new SvgScript(solutionRoot + "/" + solutionFile.getSolutionPath() + "/" + solutionFile.getFileName());
                break;
            }
            case J2D: {
                script = new Java2DScript(solutionRoot + "/" + solutionFile.getSolutionPath() + "/" + solutionFile.getFileName(), width, height);
                break;
            }
            default: {
                script = null;
            }
        }
        script.setScope(this.getScope(scriptType));
        return script;
    }

    private synchronized Scriptable getScope(ScriptType type) {
        boolean cacheless = true;
        if (cacheless || !this.scopes.containsKey((Object)type)) {
            this.scopes.put(type, this.createScope(type));
        }
        return this.scopes.get((Object)type);
    }

    private synchronized Scriptable createScope(ScriptType type) {
        String[] dependencies;
        Context cx = ContextFactory.getGlobal().enter();
        switch (type) {
            case SVG: {
                dependencies = new String[]{};
                break;
            }
            case J2D: {
                dependencies = new String[]{};
                break;
            }
            default: {
                dependencies = new String[]{};
            }
        }
        BaseScope scope = new BaseScope();
        scope.setSystemPath(this.systemPath);
        scope.init(cx);
        for (String file : dependencies) {
            try {
                cx.evaluateReader((Scriptable)scope, (Reader)new FileReader(file), "<file>", 1, null);
            }
            catch (IOException ex) {
                logger.error((Object)("Failed to read " + file + ": " + ex.toString()));
            }
        }
        Context.exit();
        return scope;
    }

    public void clearCachedScopes() {
        this.scopes = new EnumMap<ScriptType, Scriptable>(ScriptType.class);
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath.replaceAll("\\\\", "/").replaceAll("/+", "/");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScriptType {
        SVG,
        J2D;

    }
}

